/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.ClassUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class URLUtil {
    public static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new UtilException(e.getMessage(), e);
        }
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ClassUtil.getClassLoader().getResource(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return clazz.getResource(path);
    }

    public static URL getURL(File configFile) {
        try {
            return configFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UtilException("Error occured when get URL!", e);
        }
    }

    public static String formatUrl(String url) {
        if (StrUtil.isBlank(url)) {
            return null;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return url;
        }
        return "http://" + url;
    }

    public static String complateUrl(String baseUrl, String relativePath) {
        if (StrUtil.isBlank(baseUrl = URLUtil.formatUrl(baseUrl))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encode(String url, String charset) {
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String decode(String url, String charset) {
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String getPath(String uriStr) {
        URI uri = null;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
        return uri == null ? null : uri.getPath();
    }

    public static void main(String[] args) {
        System.out.println(URLUtil.getPath("http://www.oschina.net/search?scope=blog&q=netty"));
    }
}

