/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.ReUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.URLUtil;
import com.xiaoleilu.hutool.exceptions.SettingException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class Setting
extends HashMap<String, String> {
    private static final long serialVersionUID = -477527787843971824L;
    private static Logger log = Log.get();
    public static final String DEFAULT_CHARSET = "utf8";
    public static final String DEFAULT_DELIMITER = ",";
    protected static final String COMMENT_FLAG_PRE = "#";
    protected static final String ASSIGN_FLAG = "=";
    protected static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private String reg_var = "\\$\\{(.*?)\\}";
    private Charset charset;
    private boolean isUseVariable;
    private URL settingUrl;
    private LinkedList<String> groups = new LinkedList();

    public Setting(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public Setting(String pathBaseClassLoader, String charset, boolean isUseVariable) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = URLUtil.getURL(pathBaseClassLoader)) == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", pathBaseClassLoader));
        }
        this.init(url, charset, isUseVariable);
    }

    public Setting(File configFile, String charset, boolean isUseVariable) {
        if (configFile == null) {
            throw new RuntimeException("Null Setting file!");
        }
        URL url = URLUtil.getURL(configFile);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", configFile.getAbsolutePath()));
        }
        this.init(url, charset, isUseVariable);
    }

    public Setting(String path, Class<?> clazz, String charset, boolean isUseVariable) {
        URL url = URLUtil.getURL(path, clazz);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", path));
        }
        this.init(url, charset, isUseVariable);
    }

    public Setting(URL url, String charset, boolean isUseVariable) {
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init(url, charset, isUseVariable);
    }

    public Setting(String pathBaseClassLoader) {
        this(pathBaseClassLoader, DEFAULT_CHARSET, false);
    }

    public boolean init(URL settingUrl, String charset, boolean isUseVariable) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url or charset define!");
        }
        try {
            this.charset = Charset.forName(charset);
        }
        catch (Exception e) {
            log.warn("User custom charset [{}] parse error, use default charset: [{}]", (Object)charset, (Object)DEFAULT_CHARSET);
            this.charset = Charset.forName(DEFAULT_CHARSET);
        }
        this.isUseVariable = isUseVariable;
        this.settingUrl = settingUrl;
        return this.load(settingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean load(URL settingUrl) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", (Object)settingUrl.getPath());
        InputStream settingStream = null;
        try {
            settingStream = settingUrl.openStream();
            this.load(settingStream, this.isUseVariable);
        }
        catch (IOException e) {
            log.error("Load setting error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.close(settingStream);
        }
        return true;
    }

    public void reload() {
        this.load(this.settingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream, boolean isUseVariable) throws IOException {
        this.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(settingStream, this.charset));
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    group = line.substring(1, line.length() - 1).trim();
                    this.groups.add(group);
                    continue;
                }
                String[] keyValue = line.split(ASSIGN_FLAG, 2);
                if (keyValue.length < 2) continue;
                String key = keyValue[0].trim();
                if (!StrUtil.isBlank(group)) {
                    key = group + "." + key;
                }
                String value = keyValue[1].trim();
                if (isUseVariable) {
                    value = this.replaceVar(value);
                }
                this.put(key, value);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(reader);
            throw throwable;
        }
        FileUtil.close(reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    public String getSettingPath() {
        return this.settingUrl.getPath();
    }

    public String getWithLog(String key) {
        return this.get(key, null);
    }

    public String getWithLog(String key, String group) {
        String value = this.get(key, group);
        if (value == null) {
            log.debug("No key define for [{}]!", (Object)key);
        }
        return value;
    }

    public String get(String key, String group) {
        String keyWithGroup = key;
        if (!StrUtil.isBlank(group)) {
            keyWithGroup = group + "." + keyWithGroup;
        }
        return (String)this.get(keyWithGroup);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getStringWithDefault(String key, String defaultValue) {
        return this.getStringWithDefault(key, null, defaultValue);
    }

    public String getString(String key, String group) {
        return this.get(key, group);
    }

    public String getStringWithDefault(String key, String group, String defaultValue) {
        String value = this.getString(key, group);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, DEFAULT_DELIMITER);
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getString(key, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return StrUtil.split(value, delimiter);
    }

    public Integer getInt(String key) throws NumberFormatException {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Conver.toInt(this.get(key, group), defaultValue);
    }

    public Boolean getBool(String key) throws NumberFormatException {
        return this.getBool(key, null);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Conver.toBool(this.get(key, group), defaultValue);
    }

    public Long getLong(String key) throws NumberFormatException {
        return this.getLong(key, null);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Conver.toLong(this.get(key, group), defaultValue);
    }

    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    public Character getChar(String key, String group) {
        String value = this.get(key, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Conver.toDouble(this.get(key, group), defaultValue);
    }

    public void setSetting(String key, Object value) {
        this.put(key, value.toString());
    }

    public void store(String absolutePath) {
        try {
            FileUtil.touch(absolutePath);
            BufferedOutputStream out = FileUtil.getOutputStream(absolutePath);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, this.charset));
            Set entrySet = this.entrySet();
            for (Map.Entry entry : entrySet) {
                writer.write((String)entry.getKey() + ASSIGN_FLAG + (String)entry.getValue());
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(StrUtil.format("Can not find file [{}]!", absolutePath), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Store Setting error!", e);
        }
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path, clazz));
    }

    public void toObject(String group, Object object) throws SettingException {
        try {
            Method[] methods;
            for (Method method : methods = object.getClass().getMethods()) {
                Class<?>[] parameterTypes;
                String field;
                String value;
                String methodName = method.getName();
                if (!methodName.startsWith("set") || (value = this.get(field = StrUtil.getGeneralField(methodName), group)) == null || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                Object castedValue = Conver.parse(parameterTypes[0], value);
                method.invoke(object, castedValue);
                log.debug("Parse setting to object field [{}={}]", (Object)field, (Object)value);
            }
        }
        catch (Exception e) {
            throw new SettingException("Parse setting to object error!", e);
        }
    }

    public void toObject(Object object) throws SettingException {
        this.toObject(null, object);
    }

    public LinkedList<String> getGroups() {
        return this.groups;
    }

    private String replaceVar(String value) {
        Set vars = ReUtil.findAll(this.reg_var, value, 0, new HashSet());
        for (String var : vars) {
            String varValue = (String)this.get(ReUtil.get(this.reg_var, var, 1));
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

