/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.ClassUtil;
import com.xiaoleilu.hutool.IoUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileUtil.file(path = FileUtil.getAbsolutePath(path));
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new UtilException(StrUtil.format("Path [{}] is not directory!", path));
    }

    public static List<String> listFileNames(String path) {
        if (path == null) {
            return null;
        }
        if (!(path = FileUtil.getAbsolutePath(path)).endsWith(String.valueOf('/'))) {
            path = path + '/';
        }
        ArrayList<String> paths = new ArrayList<String>();
        int index = path.lastIndexOf(JAR_PATH_EXT);
        try {
            if (index == -1) {
                File[] files;
                for (File file : files = FileUtil.ls(path)) {
                    if (!file.isFile()) continue;
                    paths.add(file.getName());
                }
            } else {
                String jarPath = path.substring(0, index += JAR_FILE_EXT.length());
                String subPath = path.substring(index + 2);
                for (JarEntry entry : Collections.list(new JarFile(jarPath).entries())) {
                    String nameSuffix;
                    String name = entry.getName();
                    if (!name.startsWith(subPath) || (nameSuffix = StrUtil.removePrefix(name, subPath)).contains(String.valueOf('/'))) continue;
                    paths.add(nameSuffix);
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Can not read file path of [{}]", path), e);
        }
        return paths;
    }

    public static File file(String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(path);
    }

    public static File file(String parent, String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(File parent, String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File touch(String fullFilePath) throws IOException {
        if (fullFilePath == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(fullFilePath));
    }

    public static File touch(File file) throws IOException {
        if (null == file) {
            return null;
        }
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static boolean del(String fullFileOrDirPath) throws IOException {
        return FileUtil.del(FileUtil.file(fullFileOrDirPath));
    }

    public static boolean del(File file) throws IOException {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles()) {
                boolean isOk = FileUtil.del(childFile);
                if (isOk) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileUtil.file(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, dir).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw ioex;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest, boolean isOverride) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("File not exist: " + src);
        }
        if (!src.isFile()) {
            throw new IOException("Not a file:" + src);
        }
        if (FileUtil.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        if (dest.exists()) {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (dest.exists() && !isOverride) {
                throw new IOException("File already exist: " + dest);
            }
        }
        FileInputStream input = new FileInputStream(src);
        FileOutputStream output = new FileOutputStream(dest);
        try {
            IoUtil.copy(input, output);
        }
        finally {
            FileUtil.close(output);
            FileUtil.close(input);
        }
        if (src.length() != dest.length()) {
            throw new IOException("Copy file failed of '" + src + "' to '" + dest + "' due to different sizes");
        }
    }

    public static void move(File src, File dest, boolean isOverride) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("File already exist: " + src);
        }
        if (dest.exists()) {
            if (!isOverride) {
                throw new IOException("File already exist: " + dest);
            }
            dest.delete();
        }
        if (src.isDirectory() && dest.isFile()) {
            throw new IOException(StrUtil.format("Can not move directory [{}] to file [{}]", src, dest));
        }
        if (src.isFile() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (!src.renameTo(dest)) {
            try {
                FileUtil.copy(src, dest, isOverride);
                src.delete();
            }
            catch (Exception e) {
                throw new IOException(StrUtil.format("Move [{}] to [{}] failed!", src, dest), e);
            }
        }
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        if (path == null) {
            path = "";
        }
        if (baseClass == null) {
            return FileUtil.getAbsolutePath(path);
        }
        return StrUtil.removePrefix(PATH_FILE_PRE, baseClass.getResource(path).getPath());
    }

    public static String getAbsolutePath(String path) {
        if (path == null) {
            path = "";
        } else if ((path = FileUtil.normalize(path)).startsWith("/") || path.matches("^[a-zA-Z]:/.*")) {
            return path;
        }
        ClassLoader classLoader = ClassUtil.getClassLoader();
        URL url = classLoader.getResource(path);
        String reultPath = url != null ? url.getPath() : classLoader.getResource("").getPath() + path;
        return StrUtil.removePrefix(reultPath, PATH_FILE_PRE);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isExist(String path) {
        return FileUtil.file(path).exists();
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean equals(File file1, File file2) {
        try {
            file1 = file1.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException ignore) {
            return false;
        }
        return file1.equals(file2);
    }

    public static BufferedInputStream getInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws FileNotFoundException {
        return FileUtil.getInputStream(FileUtil.file(path));
    }

    public static BufferedWriter getBufferedWriter(String path, String charset, boolean isAppend) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtil.touch(path), isAppend), charset));
    }

    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileUtil.getBufferedWriter(path, charset, isAppend));
    }

    public static BufferedOutputStream getOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static BufferedOutputStream getOutputStream(String path) throws IOException {
        return FileUtil.getOutputStream(FileUtil.touch(path));
    }

    public static BufferedReader getReader(File file, String charset) throws IOException {
        return IoUtil.getReader(FileUtil.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String path, String charset) throws IOException {
        return FileUtil.getReader(FileUtil.file(path), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = FileUtil.getReader(path, charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
            T t = collection;
            return t;
        }
        finally {
            FileUtil.close(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Collection<String>> T readLines(URL url, String charset, T collection) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoUtil.getLines(in, charset, collection);
            return t;
        }
        finally {
            FileUtil.close(in);
        }
    }

    public static List<String> readLines(URL url, String charset) throws IOException {
        return FileUtil.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(String path, String charset) throws IOException {
        return FileUtil.readLines(path, charset, new ArrayList());
    }

    public static <T> T load(ReaderHandler<T> readerHandler, String path, String charset) throws IOException {
        BufferedReader reader = null;
        T result = null;
        try {
            reader = FileUtil.getReader(path, charset);
            result = readerHandler.handle(reader);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            FileUtil.close(reader);
        }
        return result;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext.contains(String.valueOf('/')) || ext.contains(String.valueOf('\\')) ? "" : ext;
    }

    public static int indexOfLastSeparator(String filePath) {
        int lastWindowsPos;
        if (filePath == null) {
            return -1;
        }
        int lastUnixPos = filePath.lastIndexOf(47);
        return lastUnixPos >= (lastWindowsPos = filePath.lastIndexOf(92)) ? lastUnixPos : lastWindowsPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String content, String path, String charset) throws IOException {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(path, charset, false);
            writer.print(content);
        }
        catch (Throwable throwable) {
            FileUtil.close(writer);
            throw throwable;
        }
        FileUtil.close(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendString(String content, String path, String charset) throws IOException {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(path, charset, true);
            writer.print(content);
        }
        catch (Throwable throwable) {
            FileUtil.close(writer);
            throw throwable;
        }
        FileUtil.close(writer);
    }

    public static String readString(String path, String charset) throws IOException {
        return new String(FileUtil.readBytes(FileUtil.file(path)), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL url, String charset) throws IOException {
        if (url == null) {
            throw new RuntimeException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoUtil.getString(in, charset);
            return string;
        }
        finally {
            FileUtil.close(in);
        }
    }

    public static <T> void writeLines(Collection<T> list, String path, String charset) throws IOException {
        FileUtil.writeLines(list, path, charset, false);
    }

    public static <T> void appendLines(Collection<T> list, String path, String charset) throws IOException {
        FileUtil.writeLines(list, path, charset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws IOException {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(path, charset, isAppend);
            for (T t : list) {
                if (t == null) continue;
                writer.println(t.toString());
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(writer);
            throw throwable;
        }
        FileUtil.close(writer);
    }

    public static void writeBytes(byte[] data, String path) throws IOException {
        FileUtil.writeBytes(FileUtil.touch(path), data);
    }

    public static void writeBytes(File dest, byte[] data) throws IOException {
        FileUtil.writeBytes(dest, data, 0, data.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File dest, byte[] data, int off, int len, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException("Not a file: " + dest);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data, off, len);
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IOException("Not a file:" + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IOException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(bytes);
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(in);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(File dest, InputStream in) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            IoUtil.copy(in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(out);
    }

    public static void writeStream(String fullFilePath, InputStream in) throws IOException {
        FileUtil.writeStream(FileUtil.touch(fullFilePath), in);
    }

    public static boolean isModifed(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        return path.replaceAll("[/\\\\]{1,}", "/");
    }

    public static String subPath(String rootDir, String filePath) {
        return FileUtil.subPath(rootDir, FileUtil.file(filePath));
    }

    public static String subPath(String rootDir, File file) {
        if (StrUtil.isEmpty(rootDir)) {
            // empty if block
        }
        String subPath = null;
        try {
            subPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        if (StrUtil.isNotEmpty(rootDir) && StrUtil.isNotEmpty(subPath)) {
            rootDir = FileUtil.normalize(rootDir);
            if ((subPath = FileUtil.normalize(subPath)) != null && subPath.toLowerCase().startsWith(subPath.toLowerCase())) {
                subPath = subPath.substring(rootDir.length() + 1);
            }
        }
        return subPath;
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

