/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds;

import com.alibaba.druid.pool.DruidDataSource;
import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.Setting;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.exceptions.SettingException;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DruidDS {
    private static Logger log = Log.get();
    public static final String DEFAULT_DRUID_CONFIG_PATH = "config/druid.setting";
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private static Setting dbSetting;
    private static Setting druidSetting;
    private static Map<String, DruidDataSource> dsMap;

    public static synchronized void init(Setting druid_setting, Setting db_setting) {
        dsMap = new HashMap<String, DruidDataSource>();
        druidSetting = druid_setting;
        if (druidSetting == null) {
            try {
                druidSetting = new Setting(DEFAULT_DRUID_CONFIG_PATH, "utf8", true);
            }
            catch (Exception e) {
                log.info("Druid setting file {} not found.", (Object)DEFAULT_DRUID_CONFIG_PATH);
            }
        }
        if ((dbSetting = db_setting) == null) {
            try {
                dbSetting = new Setting(DEFAULT_DB_CONFIG_PATH, "utf8", true);
            }
            catch (Exception e) {
                log.info("No default DB config file {} found, custom to init it.", (Object)DEFAULT_DB_CONFIG_PATH);
            }
        }
    }

    public static synchronized DataSource getDataSource(String group) {
        DruidDataSource existedDataSource;
        if (null == dsMap) {
            DruidDS.init(null, null);
        }
        if (dbSetting == null) {
            throw new UtilException("No setting found, please init it!");
        }
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DruidDataSource dds = new DruidDataSource();
        DruidDS.injectSetting(druidSetting, dds);
        dds.setName(group);
        String jdbcUrl = dbSetting.getString("url", group);
        Log.debug(log, "JDBC url: {}", jdbcUrl);
        dds.setDriverClassName(dbSetting.getStringWithDefault("driver", group, DbUtil.identifyDriver(jdbcUrl)));
        dds.setUrl(jdbcUrl);
        dds.setUsername(dbSetting.getString("user", group));
        dds.setPassword(dbSetting.getString("pass", group));
        String dsSettingPath = dbSetting.getString("ds.setting.path");
        if (StrUtil.isNotBlank(dsSettingPath)) {
            DruidDS.injectSetting(new Setting(dsSettingPath), dds);
        }
        dsMap.put(group, dds);
        return dds;
    }

    public static DataSource getDataSource() {
        return DruidDS.getDataSource(null);
    }

    public static Connection getConnection(String datasource) throws SQLException {
        return DruidDS.getDataSource(datasource).getConnection();
    }

    public static Connection getConnection() throws SQLException {
        return DruidDS.getConnection(null);
    }

    public static synchronized void closeDs(String dsName) {
        DruidDataSource dds;
        if (dsName == null) {
            dsName = "";
        }
        if ((dds = dsMap.get(dsName)) != null) {
            FileUtil.close((Closeable)dds);
            dsMap.remove(dsName);
        }
    }

    public static synchronized void closeDs() {
        DruidDS.closeDs(null);
    }

    public static synchronized void closeAll() {
        Collection<DruidDataSource> values = dsMap.values();
        for (DruidDataSource dds : values) {
            if (dds == null) continue;
            dds.close();
        }
        dsMap.clear();
    }

    private static void injectSetting(Setting setting, DruidDataSource dds) {
        if (null != setting) {
            try {
                setting.toObject(dds);
            }
            catch (SettingException e) {
                throw new UtilException("Read Druid setting error!", e);
            }
        }
    }
}

