/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.StrUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReUtil {
    public static final String RE_CHINESE = "[u4e00-u9fa5]";
    public static final Pattern NUMBER = Pattern.compile("\\d+", 32);
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)", 32);
    public static final Pattern IPV4 = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", 32);

    private ReUtil() {
    }

    public static String get(String regex, String content, int groupIndex) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, String content, int groupIndex) {
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String extractMulti(Pattern pattern, String content, String template) {
        HashSet<String> varNums = ReUtil.findAll(GROUP_VAR, template, 1, new HashSet());
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(Pattern pattern, String[] contents, String template) {
        HashSet<String> varNums = ReUtil.findAll(GROUP_VAR, template, 1, new HashSet());
        String content = contents[0];
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contents[0] = StrUtil.sub(content, matcher.end(), content.length());
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, String content, String template) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(String regex, String[] contents, String template) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.extractMultiAndDelPre(pattern, contents, template);
    }

    public static String delFirst(String regex, String content) {
        return content.replaceFirst(regex, "");
    }

    public static String delPreLocation(String regex, String content) {
        Matcher matcher = Pattern.compile(regex, 32).matcher(content);
        if (matcher.find()) {
            return StrUtil.sub(content, matcher.end(), content.length());
        }
        return content;
    }

    public static <T extends Collection<String>> T findAll(String regex, String content, int group, T collection) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.findAll(pattern, content, group, collection);
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, String content, int group, T collection) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static int getFirstNumber(String StringWithNumber) {
        return Integer.parseInt(ReUtil.get(NUMBER, StringWithNumber, 0));
    }

    public static boolean isIpv4(String ip) {
        if (StrUtil.isBlank(ip)) {
            return false;
        }
        return IPV4.matcher(ip).matches();
    }

    public static boolean isMatch(String regex, String content) {
        if (content == null) {
            return false;
        }
        if (StrUtil.isEmpty(regex)) {
            return true;
        }
        return Pattern.matches(regex, content);
    }
}

