/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    public static Logger get(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    public static Logger get(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static Logger get() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return LoggerFactory.getLogger((String)stackTrace[2].getClassName());
    }

    public static void trace(String format, Object ... arguments) {
        Log.trace(Log.innerGet(), format, arguments);
    }

    public static void trace(Logger log, String format, Object ... arguments) {
        log.trace(format, arguments);
    }

    public static void debug(String format, Object ... arguments) {
        Log.debug(Log.innerGet(), format, arguments);
    }

    public static void debug(Logger log, String format, Object ... arguments) {
        log.debug(format, arguments);
    }

    public static void info(String format, Object ... arguments) {
        Log.info(Log.innerGet(), format, arguments);
    }

    public static void info(Logger log, String format, Object ... arguments) {
        log.info(format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        Log.warn(Log.innerGet(), format, arguments);
    }

    public static void warn(Logger log, String format, Object ... arguments) {
        log.warn(format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        Log.warn(Log.innerGet(), e, StrUtil.format(format, arguments), new Object[0]);
    }

    public static void warn(Logger log, Throwable e, String format, Object ... arguments) {
        log.warn(StrUtil.format(format, arguments), e);
    }

    public static void error(String format, Object ... arguments) {
        Log.error(Log.innerGet(), format, arguments);
    }

    public static void error(Logger log, String format, Object ... arguments) {
        log.error(format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        Log.error(Log.innerGet(), e, StrUtil.format(format, arguments), new Object[0]);
    }

    public static void error(Logger log, Throwable e, String format, Object ... arguments) {
        log.error(StrUtil.format(format, arguments), e);
    }

    public static void error(Logger log, Throwable e) {
        log.error(e.getMessage(), e);
    }

    public static void error(Throwable e) {
        Log.innerGet().error(e.getMessage(), e);
    }

    private static Logger innerGet() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return LoggerFactory.getLogger((String)stackTrace[3].getClassName());
    }
}

