/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.ChunkFactory;
import com.x5.template.ChunkLocale;
import com.x5.template.ContentSource;
import com.x5.template.EndOfSnippetException;
import com.x5.template.Filter;
import com.x5.template.LoopTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetTag;
import com.x5.template.TemplateSet;
import com.x5.template.Theme;
import com.x5.template.filters.Calc;
import com.x5.util.DataCapsule;
import com.x5.util.DataCapsuleReader;
import com.x5.util.ObjectDataMap;
import com.x5.util.TableData;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk
implements Map<String, Object> {
    public static final int HASH_THRESH = 8;
    public static final int DEPTH_LIMIT = 17;
    public static final String VERSION = "3.3.0";
    public static final String TRUE = "TRUE";
    protected Snippet templateRoot = null;
    private String templateOrigin = null;
    private String[] firstTags = new String[8];
    private Object[] firstValues = new Object[8];
    private int tagCount = 0;
    protected Vector<Snippet> template = null;
    private Hashtable<String, Object> tags = null;
    protected String tagStart = TemplateSet.DEFAULT_TAG_START;
    protected String tagEnd = TemplateSet.DEFAULT_TAG_END;
    private Vector<Vector<Chunk>> contextStack = null;
    private ContentSource macroLibrary = null;
    private ChunkFactory chunkFactory = null;
    private String localeCode = null;
    private ChunkLocale locale = null;
    private boolean renderErrs = true;
    private PrintStream errLog = null;
    private Hashtable<String, ContentSource> altSources = null;
    private static final Pattern INCLUDEIF_PATTERN = Pattern.compile("^\\.include(If|\\.\\()");
    private static final SimpleDateFormat LOG_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zZ ");

    void setMacroLibrary(ContentSource repository, ChunkFactory factory) {
        this.macroLibrary = repository;
        if (this.altSources != null) {
            this.addProtocol(repository);
        }
        this.chunkFactory = factory;
    }

    public ContentSource getTemplateSet() {
        return this.macroLibrary;
    }

    public void setChunkFactory(ChunkFactory factory) {
        this.chunkFactory = factory;
    }

    public ChunkFactory getChunkFactory() {
        return this.chunkFactory;
    }

    public void append(Snippet toAdd) {
        if (this.templateRoot == null && this.template == null) {
            this.templateRoot = toAdd;
        } else if (this.template == null) {
            this.template = new Vector();
            this.template.addElement(this.templateRoot);
            this.template.addElement(toAdd);
        } else {
            this.template.addElement(toAdd);
        }
    }

    public void append(String toAdd) {
        if (toAdd == null) {
            return;
        }
        Snippet snippet = Snippet.getSnippet(toAdd);
        this.append(snippet);
    }

    public void append(Chunk toAdd) {
        if (this.template == null) {
            this.template = new Vector();
            if (this.templateRoot != null) {
                this.template.addElement(this.templateRoot);
            }
        }
        String chunkKey = ";CHUNK_" + toAdd.hashCode();
        this.set(chunkKey, toAdd);
        String autoTag = this.makeTag(chunkKey);
        this.template.addElement(Snippet.getSnippet(autoTag));
    }

    public void set(String tagName, String tagValue) {
        this.set(tagName, tagValue, "");
    }

    public void set(String tagName, Chunk tagValue) {
        this.set(tagName, tagValue, "");
    }

    public void set(String tagName, Object tagValue) {
        String ifNull = null;
        this.set(tagName, tagValue, ifNull);
    }

    public void setOrDelete(String tagName, Object tagValue) {
        if (tagValue == null) {
            if (this.containsKey(tagName)) {
                this.tags.remove(tagName);
            }
            return;
        }
        this.set(tagName, tagValue, null);
    }

    public void setLiteral(String tagName, String literalValue) {
        Snippet hardValue = Snippet.makeLiteralSnippet(literalValue);
        this.set(tagName, hardValue);
    }

    public void set(String tagName, Object tagValue, String ifNull) {
        if (tagName == null) {
            return;
        }
        if (tagValue != null) {
            tagValue = Chunk.coercePrimitivesToStringAndBoxAliens(tagValue);
        }
        if (tagValue == null) {
            Object object = tagValue = ifNull == null ? "NULL" : ifNull;
        }
        if (this.tags != null) {
            this.tags.put(tagName, tagValue);
        } else {
            for (int i = 0; i < this.tagCount; ++i) {
                if (!this.firstTags[i].equals(tagName)) continue;
                this.firstValues[i] = tagValue;
                return;
            }
            if (this.tagCount >= 8) {
                this.tags = new Hashtable(16);
                this.copyToHashtable();
                this.tags.put(tagName, tagValue);
            } else {
                this.firstTags[this.tagCount] = tagName;
                this.firstValues[this.tagCount] = tagValue;
                ++this.tagCount;
            }
        }
    }

    public void setToBean(String tagName, Object bean) {
        this.setToBean(tagName, bean, null);
    }

    public void setToBean(String tagName, Object bean, String ifNull) {
        ObjectDataMap boxedBean = ObjectDataMap.wrapBean(bean);
        this.set(tagName, boxedBean, ifNull);
    }

    public void set(String tagName) {
        this.set(tagName, TRUE);
    }

    public void set(String tagName, int tagValue) {
        this.set(tagName, Integer.toString(tagValue));
    }

    public void set(String tagName, char tagValue) {
        this.set(tagName, Character.toString(tagValue));
    }

    public void set(String tagName, long tagValue) {
        this.set(tagName, Long.toString(tagValue));
    }

    public void set(String tagName, StringBuilder tagValue) {
        if (tagValue != null) {
            this.set(tagName, tagValue.toString());
        }
    }

    public void set(String tagName, boolean value) {
        if (value) {
            this.set(tagName, TRUE);
        } else {
            this.unset(tagName);
        }
    }

    public void set(String tagName, StringBuffer tagValue) {
        if (tagValue != null) {
            this.set(tagName, tagValue.toString());
        }
    }

    public void unset(String tagName) {
        if (tagName != null) {
            this.setOrDelete(tagName, null);
        }
    }

    public boolean hasValue(String tagName) {
        if (tagName == null) {
            return false;
        }
        if (this.tags != null) {
            return this.tags.containsKey(tagName);
        }
        for (int i = 0; i < this.tagCount; ++i) {
            if (!this.firstTags[i].equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean stillNeeds(String tagName) {
        if (tagName == null) {
            return false;
        }
        return !this.hasValue(tagName);
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            this.render(out);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public String toString(Chunk context) {
        StringWriter out = new StringWriter();
        try {
            this.render(out, context);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public void render(PrintStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        this.render(writer);
        writer.flush();
    }

    public void render(Writer out) throws IOException {
        this.explodeForParentToPrinter(out, null);
    }

    public void render(Writer out, Chunk context) throws IOException {
        Vector<Chunk> parentContext = context.prepareParentContext();
        this.explodeForParentToPrinter(out, parentContext);
    }

    private void pushContextStack(Vector<Chunk> parentContext) {
        if (this.contextStack == null) {
            this.contextStack = new Vector();
        }
        this.contextStack.insertElementAt(parentContext, 0);
    }

    private void popContextStack() {
        if (this.contextStack == null || this.contextStack.size() == 0) {
            return;
        }
        this.contextStack.removeElementAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explodeForParentToPrinter(Writer out, Vector<Chunk> ancestors) throws IOException {
        if (this.template == null && this.templateRoot == null) {
            return;
        }
        if (ancestors != null) {
            Chunk chunk = this;
            synchronized (chunk) {
                this.pushContextStack(ancestors);
                this.renderForParentToPrinter(out);
                this.popContextStack();
            }
        } else {
            this.renderForParentToPrinter(out);
        }
    }

    private void renderForParentToPrinter(Writer out) throws IOException {
        if (this.template == null) {
            this.explodeToPrinter(out, this.templateRoot, 1);
        } else {
            if (this.template.size() > 1) {
                this.template = this.mergeTemplateParts();
            }
            for (int i = 0; i < this.template.size(); ++i) {
                Snippet s = this.template.elementAt(i);
                this.explodeToPrinter(out, s, 1);
            }
        }
    }

    private Vector<Snippet> mergeTemplateParts() {
        Snippet merged;
        try {
            merged = Snippet.consolidateSnippets(this.template);
        }
        catch (EndOfSnippetException e) {
            return this.template;
        }
        Vector<Snippet> newTemplate = new Vector<Snippet>();
        newTemplate.add(merged);
        return newTemplate;
    }

    void explodeToPrinter(Writer out, Object obj, int depth) throws IOException {
        if (depth >= 17) {
            String err = this.handleError("[**ERR** max template recursions: 17]");
            if (err != null) {
                out.append(err);
            }
        } else if (obj instanceof Snippet) {
            Snippet snippet = (Snippet)obj;
            snippet.render(out, this, depth);
        } else if (obj instanceof String) {
            Snippet snippet = Snippet.getSnippet((String)obj);
            this.explodeToPrinter(out, snippet, depth);
        } else if (obj instanceof Chunk) {
            Vector<Chunk> parentContext = this.prepareParentContext();
            Chunk c = (Chunk)obj;
            c.explodeForParentToPrinter(out, parentContext);
        } else if (obj instanceof DataCapsule[]) {
            DataCapsuleReader reader = DataCapsuleReader.getReader((DataCapsule[])obj);
            String err = this.handleError("[LIST(" + reader.getDataClassName() + ") - Use a loop construct to display list data.]");
            if (err != null) {
                out.append(err);
            }
        } else if (obj instanceof String[]) {
            String err = this.handleError("[LIST(java.lang.String) - Use a loop construct to display list data, or pipe to join().]");
            if (err != null) {
                out.append(err);
            }
        } else if (obj instanceof List) {
            String err = this.handleError("[LIST - Use a loop construct to display list data, or pipe to join().]");
            if (err != null) {
                out.append(err);
            }
        } else {
            String repr = ObjectDataMap.getAsString(obj);
            this.explodeToPrinter(out, repr, depth);
        }
    }

    private Vector<Chunk> prepareParentContext() {
        if (this.contextStack == null) {
            Vector<Chunk> parentContext = new Vector<Chunk>();
            parentContext.add(this);
            return parentContext;
        }
        Vector parentContext = this.contextStack.firstElement();
        parentContext = (Vector)parentContext.clone();
        parentContext.insertElementAt(this, 0);
        return parentContext;
    }

    private Vector<Chunk> getCurrentParentContext() {
        if (this.contextStack == null || this.contextStack.size() == 0) {
            return null;
        }
        return this.contextStack.firstElement();
    }

    public Object getTagValue(String tagName) {
        if (this.tags != null) {
            Object x = this.tags.get(tagName);
            if (x instanceof String) {
                Snippet s = Snippet.getSnippet((String)x);
                this.tags.put(tagName, s);
                return s.isSimple() ? s.toString() : s;
            }
            if (x instanceof Snippet) {
                Snippet s = (Snippet)x;
                return s.isSimple() ? s.toString() : s;
            }
            return x;
        }
        for (int i = 0; i < this.tagCount; ++i) {
            if (!this.firstTags[i].equals(tagName)) continue;
            Object x = this.firstValues[i];
            if (x instanceof String) {
                Snippet s = Snippet.getSnippet((String)x);
                this.firstValues[i] = s;
                return s.isSimple() ? s.toString() : s;
            }
            if (x instanceof Snippet) {
                Snippet s = (Snippet)x;
                return s.isSimple() ? s.toString() : s;
            }
            return x;
        }
        return null;
    }

    public void addProtocol(ContentSource src) {
        if (this.altSources == null) {
            this.altSources = new Hashtable();
            if (this.macroLibrary != null) {
                this.altSources.put(this.macroLibrary.getProtocol(), this.macroLibrary);
            }
        }
        String protocol = src.getProtocol();
        this.altSources.put(protocol, src);
    }

    private Object altFetch(String tagName, int depth) {
        return this.altFetch(tagName, depth, false);
    }

    private Object altFetch(String tagName, int depth, boolean ignoreParentContext) {
        Vector<Chunk> parentContext;
        String itemName;
        String tagValue = null;
        if (tagName.startsWith(".calc(")) {
            String eval = null;
            try {
                eval = Calc.evalCalc(tagName, this);
            }
            catch (NoClassDefFoundError e) {
                String errMsg = "[ERROR: jeplite jar missing from classpath! .calc command requires jeplite library]";
                eval = this.handleError(errMsg);
            }
            return eval;
        }
        if (tagName.startsWith(".version")) {
            return VERSION;
        }
        if (tagName.startsWith(".loop")) {
            return LoopTag.expandLoop(tagName, this, this.templateOrigin, depth);
        }
        if (tagName.startsWith(".tagStack")) {
            String format = "text";
            if (tagName.contains("html")) {
                format = "html";
            }
            return this.formatTagStack(format);
        }
        if (this.altSources == null && this.macroLibrary == null && this.getCurrentParentContext() == null) {
            return null;
        }
        Matcher m = INCLUDEIF_PATTERN.matcher(tagName);
        if (m.find()) {
            String translation = Filter.translateIncludeIf(tagName, this.tagStart, this.tagEnd, this);
            return translation;
        }
        int delimPos = tagName.indexOf(".", 1);
        int spacePos = tagName.indexOf(" ", 1);
        if (delimPos < 0 && spacePos < 0) {
            if (tagName.startsWith("./")) {
                return null;
            }
            String errMsg = "[CHUNK_ERR: malformed content reference: '" + tagName + "' -- missing argument]";
            return this.handleError(errMsg);
        }
        if (spacePos > 0 && (delimPos < 0 || spacePos < delimPos)) {
            delimPos = spacePos;
        }
        String srcName = tagName.substring(1, delimPos);
        String cleanItemName = itemName = tagName.substring(delimPos + 1);
        cleanItemName = cleanItemName.replaceAll("[\\|:].*$", "");
        ContentSource fetcher = null;
        if (this.altSources != null) {
            fetcher = this.altSources.get(srcName);
        } else if (this.macroLibrary != null && srcName.equals(this.macroLibrary.getProtocol())) {
            fetcher = this.macroLibrary;
        }
        if (fetcher != null) {
            if (fetcher instanceof Theme) {
                Theme theme = (Theme)fetcher;
                String templateRef = BlockTag.qualifyTemplateRef(this.templateOrigin, cleanItemName);
                Snippet s = theme.getSnippet(templateRef);
                if (s != null) {
                    return s;
                }
            } else {
                tagValue = fetcher.fetch(cleanItemName);
            }
        }
        if (tagValue == null && !ignoreParentContext && (parentContext = this.getCurrentParentContext()) != null) {
            for (Chunk ancestor : parentContext) {
                Object x = ancestor.altFetch(tagName, depth, true);
                if (x == null) continue;
                return x;
            }
        }
        return tagValue;
    }

    protected String resolveBackticks(String lookupName, int depth) {
        int backtickA = lookupName.indexOf(96);
        if (backtickA < 0) {
            return lookupName;
        }
        int backtickB = lookupName.indexOf(96, backtickA + 1);
        if (backtickB < 0) {
            return lookupName;
        }
        String embeddedTag = lookupName.substring(backtickA + 2, backtickB);
        char typeChar = lookupName.charAt(backtickA + 1);
        if (typeChar == '^' || typeChar == '.') {
            embeddedTag = '.' + embeddedTag;
        } else if (typeChar != '~' && typeChar != '$') {
            return lookupName;
        }
        Object backtickExprValue = this.resolveTagValue(embeddedTag, depth);
        if (backtickExprValue == null) {
            return lookupName;
        }
        String dynLookupName = lookupName.substring(0, backtickA) + backtickExprValue + lookupName.substring(backtickB + 1);
        return this.resolveBackticks(dynLookupName, depth);
    }

    protected Object resolveTagValue(SnippetTag tag, int depth, String origin) {
        if (origin == null) {
            return this._resolveTagValue(tag, depth, false);
        }
        this.templateOrigin = origin;
        Object value = this._resolveTagValue(tag, depth, false);
        this.templateOrigin = null;
        return value;
    }

    protected Object resolveTagValue(SnippetTag tag, int depth) {
        return this._resolveTagValue(tag, depth, false);
    }

    protected Object _resolveTagValue(SnippetTag tag, int depth, boolean ignoreParentContext) {
        String[] path = tag.getPath();
        int segment = 0;
        String segmentName = path[segment];
        if (tag.hasBackticks()) {
            segmentName = this.resolveBackticks(segmentName, depth);
        }
        Object tagValue = null;
        if (segmentName.charAt(0) == '.') {
            tagValue = this.altFetch(segmentName, depth);
        } else if (this.hasValue(segmentName)) {
            tagValue = this.getTagValue(segmentName);
        } else {
            if (ignoreParentContext) {
                return tagValue;
            }
            Vector<Chunk> parentContext = this.getCurrentParentContext();
            if (parentContext != null) {
                Chunk ancestor;
                Iterator<Chunk> iterator = parentContext.iterator();
                while (iterator.hasNext() && (tagValue = (ancestor = iterator.next()).getTagValue(segmentName)) == null) {
                }
            }
        }
        ++segment;
        while (path.length > segment && tagValue != null) {
            if (tagValue instanceof Map) {
                Map obj;
                segmentName = path[segment];
                if (tag.hasBackticks()) {
                    segmentName = this.resolveBackticks(segmentName, depth);
                }
                if ((tagValue = (obj = (Map)tagValue).get(segmentName)) != null || path.length != ++segment) continue;
                String fakeRef = path[segment - 2] + "." + segmentName;
                tagValue = this.getTagValue(fakeRef);
                continue;
            }
            tagValue = null;
        }
        if (tagValue != null && !(tagValue instanceof String)) {
            tagValue = Chunk.coercePrimitivesToStringAndBoxAliens(tagValue);
        }
        Filter[] filters = tag.getFilters();
        if (tagValue == null) {
            Object filteredNull;
            String tagDefault = tag.getDefaultValue();
            if (filters != null && (tag.applyFiltersFirst() || tagDefault == null) && (filteredNull = Filter.applyFilter(this, filters, null)) != null) {
                return filteredNull;
            }
            if (tag.applyFiltersFirst()) {
                return tagDefault;
            }
            if (filters != null) {
                return Filter.applyFilter(this, filters, (Object)tagDefault);
            }
            return tagDefault;
        }
        if (filters == null) {
            return tagValue;
        }
        Object filteredVal = Filter.applyFilter(this, filters, tagValue);
        if (filteredVal == null && tag.applyFiltersFirst()) {
            return tag.getDefaultValue();
        }
        return filteredVal;
    }

    private static Object coercePrimitivesToStringAndBoxAliens(Object o) {
        if (o == null) {
            return o;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? TRUE : null;
        }
        if (ObjectDataMap.isWrapperType(o.getClass())) {
            return o.toString();
        }
        return Chunk.boxIfAlienObject(o);
    }

    public static Object boxIfAlienObject(Object o) {
        if (o == null) {
            return o;
        }
        if (o instanceof Chunk || o instanceof TableData) {
            return o;
        }
        if (o instanceof Map) {
            return o;
        }
        if (o instanceof String || o instanceof Snippet || o instanceof List || o instanceof Object[]) {
            return o;
        }
        return new ObjectDataMap(o);
    }

    protected Object resolveTagValue(String tagName, int depth) {
        return this._resolveTagValue(SnippetTag.parseTag(tagName), depth, false);
    }

    public void resetTags() {
        if (this.tags != null) {
            this.tags.clear();
        } else {
            this.tagCount = 0;
        }
    }

    @Override
    public void clear() {
        this.resetTags();
    }

    public void resetTemplate() {
        if (this.template == null) {
            this.templateRoot = null;
        } else {
            this.template.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.resolveTagValue((String)key, 1);
    }

    @Override
    public int hashCode() {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.hashCode();
    }

    @Override
    public boolean isEmpty() {
        if (this.tags == null) {
            return this.tagCount == 0;
        }
        return this.tags.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        Object x = this.getTagValue(key);
        this.set(key, value, "");
        return x;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        if (t == null || t.size() < 0) {
            return;
        }
        Set set = t.keySet();
        for (String tagName : set) {
            this.set(tagName, t.get(tagName), "");
        }
    }

    @Override
    public int size() {
        if (this.tags != null) {
            return this.tags.size();
        }
        return this.tagCount;
    }

    @Override
    public Collection<Object> values() {
        if (this.tags == null) {
            this.tags = new Hashtable();
            this.copyToHashtable();
        }
        return this.tags.values();
    }

    public void setMultiple(Map<String, Object> rules) {
        if (rules == null || rules.size() <= 0) {
            return;
        }
        Set<String> keys = rules.keySet();
        for (String tagName : keys) {
            this.setOrDelete(tagName, rules.get(tagName));
        }
    }

    public void setMultiple(Chunk copyFrom) {
        if (copyFrom != null) {
            Map<String, Object> h = copyFrom.getTagsTable();
            this.setMultiple(h);
        }
    }

    public Map<String, Object> getTagsTable() {
        if (this.tags != null) {
            return this.tags;
        }
        if (this.tagCount <= 0) {
            return null;
        }
        this.copyToHashtable();
        return this.tags;
    }

    private void copyToHashtable() {
        if (this.tags == null) {
            this.tags = new Hashtable(this.tagCount * 2);
        }
        for (int i = 0; i < this.tagCount; ++i) {
            this.tags.put(this.firstTags[i], this.firstValues[i]);
        }
    }

    private String formatTagStack(String format) {
        StringBuilder stack = new StringBuilder();
        String lineFeed = "\n";
        String indent = "  ";
        if (format.equals("html")) {
            lineFeed = "<br/>\n";
            indent = "&nbsp;&nbsp;";
        }
        stack.append("Available tags:");
        stack.append(lineFeed);
        int indentLevel = 0;
        this.outputTags(stack, lineFeed, indent, indentLevel);
        ++indentLevel;
        Vector<Chunk> parentContext = this.getCurrentParentContext();
        if (parentContext != null) {
            for (Chunk ancestor : parentContext) {
                ancestor.outputTags(stack, lineFeed, indent, indentLevel);
                ++indentLevel;
            }
        }
        return stack.toString();
    }

    private void outputTags(StringBuilder output, String lf, String ind, int indent) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.tags == null) {
            for (int i = 0; i < this.tagCount; ++i) {
                list.add(this.firstTags[i]);
            }
        } else {
            list.addAll(this.tags.keySet());
        }
        Collections.sort(list);
        for (String tag : list) {
            for (int x = 0; x < indent; ++x) {
                output.append(ind);
            }
            output.append('$');
            output.append(tag);
            output.append(lf);
        }
    }

    public void addData(DataCapsule smartObj) {
        DataCapsuleReader reader = DataCapsuleReader.getReader(smartObj);
        String[] tags = reader.getColumnLabels(null);
        Object[] data = reader.extractData(smartObj);
        for (int i = 0; i < tags.length; ++i) {
            Object val = data[i];
            if (val == null || val instanceof String || val instanceof DataCapsule) {
                this.setOrDelete(tags[i], val);
                continue;
            }
            this.set(tags[i], val.toString());
        }
    }

    public void addData(DataCapsule smartObj, String altPrefix) {
        if (smartObj == null) {
            return;
        }
        if (altPrefix == null) {
            this.addData(smartObj);
        } else {
            this.set(altPrefix, smartObj);
        }
    }

    public String makeTag(String tagName) {
        return this.tagStart + tagName + this.tagEnd;
    }

    public void setErrorHandling(boolean renderErrs, PrintStream err) {
        this.renderErrs = renderErrs;
        this.errLog = err;
    }

    boolean renderErrorsToOutput() {
        return this.renderErrs;
    }

    private String handleError(String errMsg) {
        this.logError(errMsg);
        return this.renderErrs ? errMsg : null;
    }

    void logError(String errMsg) {
        Chunk.logChunkError(this.errLog, errMsg);
    }

    static void logChunkError(PrintStream log, String errMsg) {
        if (log != null) {
            log.print(LOG_DATE.format(new Date()));
            log.println(errMsg);
        }
    }

    public void setLocale(String localeCode) {
        this.localeCode = localeCode;
    }

    public void setLocale(Locale javaLocale) {
        if (javaLocale == null) {
            this.localeCode = null;
        } else {
            String localeCode = javaLocale.toString();
            localeCode = localeCode.replace('-', '_');
            this.setLocale(localeCode);
        }
    }

    public void setLocale(ChunkLocale chunkLocale) {
        if (chunkLocale == null) {
            this.localeCode = null;
        } else {
            this.setLocale(chunkLocale.toString());
        }
    }

    public ChunkLocale getLocale() {
        if (this.localeCode == null) {
            return null;
        }
        if (this.locale == null) {
            this.locale = ChunkLocale.getInstance(this.localeCode, this);
        }
        return this.locale;
    }

    public static String findAndReplace(String toSearch, String find, String replace) {
        int findPos;
        if (find == null || toSearch == null || toSearch.indexOf(find) == -1) {
            return toSearch;
        }
        if (replace == null) {
            replace = "";
        }
        int marker = 0;
        int findLen = find.length();
        StringBuilder sb = new StringBuilder();
        while ((findPos = toSearch.indexOf(find, marker)) > -1) {
            sb.append(toSearch.substring(marker, findPos));
            sb.append(replace);
            marker = findPos + findLen;
        }
        sb.append(toSearch.substring(marker));
        return sb.toString();
    }

    public String getTemplateOrigin() {
        return this.templateOrigin;
    }
}

