/*
 * Decompiled with CFR 0.152.
 */
package com.x5.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteXml {
    private String xml;
    private Map<String, String> attrs = null;
    private static final int MAX_PARSE = 15;
    private static final Pattern XML_ENTITY_REGEX = Pattern.compile("&(#?)([^;]+);");
    private static final Map<String, String> STD_ENTITIES = LiteXml.getStandardEntities();

    public LiteXml(String xmlNode) {
        this.xml = xmlNode;
    }

    public String getNodeType() {
        int begPos;
        if (this.xml == null) {
            return null;
        }
        int startAt = 0;
        int headerPos = this.xml.indexOf("?>");
        if (headerPos > -1) {
            startAt = headerPos + 2;
        }
        if ((begPos = this.xml.indexOf(60, startAt)) < 0) {
            return null;
        }
        int spacePos = this.xml.indexOf(32, begPos);
        int endPos = this.xml.indexOf(62, begPos);
        if (spacePos > -1 && spacePos < endPos) {
            endPos = spacePos;
        }
        if (endPos < begPos + 1) {
            return null;
        }
        String nodeType = this.xml.substring(begPos + 1, endPos);
        return nodeType;
    }

    public Map<String, String> getAttributes() {
        if (this.xml == null) {
            return null;
        }
        if (this.attrs != null) {
            return this.attrs;
        }
        int tagEndPos = this.xml.indexOf(62);
        if (tagEndPos < 0) {
            return null;
        }
        int spacePos = this.xml.indexOf(32);
        if (spacePos < 0 || spacePos > tagEndPos) {
            return null;
        }
        String attrDefs = this.xml.substring(spacePos + 1, tagEndPos);
        this.attrs = this.parseAttributes(attrDefs);
        return this.attrs;
    }

    private Map<String, String> parseAttributes(String attrDef) {
        int openQuotePos;
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int cursor = 0; cursor < attrDef.length() && (openQuotePos = attrDef.indexOf(61, cursor)) >= 0; ++cursor) {
            int closeQuotePos;
            String param = attrDef.substring(cursor, openQuotePos);
            if ((openQuotePos = attrDef.indexOf(34, openQuotePos + 1)) < 0 || (closeQuotePos = LiteXml.nextUnescapedDelim("\"", attrDef, cursor = openQuotePos + 1)) < 0) break;
            String val = attrDef.substring(cursor, closeQuotePos);
            val = val.replaceAll("\\\\\"", "\"");
            val = val.replaceAll("\\\\\\\\", "\\\\");
            attrs.put(param.trim(), LiteXml.unescapeXML(val));
            cursor = attrDef.indexOf(32, closeQuotePos + 1);
            if (cursor < 0) break;
        }
        return attrs;
    }

    public static int nextUnescapedDelim(String delim, String toScan, int searchFrom) {
        int delimPos = toScan.indexOf(delim, searchFrom);
        boolean isProvenDelimeter = false;
        while (!isProvenDelimeter) {
            int bsCount = 0;
            while (delimPos - (1 + bsCount) >= searchFrom && toScan.charAt(delimPos - (1 + bsCount)) == '\\') {
                ++bsCount;
            }
            if (bsCount % 2 == 0) {
                isProvenDelimeter = true;
                continue;
            }
            if ((delimPos = toScan.indexOf(delim, delimPos + 1)) >= 0) continue;
            return -1;
        }
        return delimPos;
    }

    public String getAttribute(String attr) {
        Map<String, String> myAttrs = this.getAttributes();
        if (myAttrs == null || myAttrs.size() < 1) {
            return null;
        }
        return myAttrs.get(attr);
    }

    private String getRawNodeValue() {
        if (this.xml == null) {
            return null;
        }
        String nodeType = this.getNodeType();
        if (nodeType == null) {
            return null;
        }
        int topTagEnd = this.xml.indexOf(nodeType) + nodeType.length();
        topTagEnd = this.xml.indexOf(62, topTagEnd);
        int endTagBeg = this.xml.lastIndexOf(60);
        if (topTagEnd < 0 || endTagBeg < topTagEnd) {
            return null;
        }
        if (this.xml.indexOf(nodeType, endTagBeg) < 0) {
            return this.xml;
        }
        return this.xml.substring(topTagEnd + 1, endTagBeg);
    }

    private boolean isCDATA(String x) {
        if (x == null) {
            return false;
        }
        String contents = x.trim();
        return contents.startsWith("<![CDATA[") && contents.endsWith("]]>");
    }

    public String getNodeValue() {
        String contents = this.getRawNodeValue();
        if (contents == null) {
            return null;
        }
        if (this.isCDATA(contents)) {
            return contents.trim().substring(9, contents.length() - 3);
        }
        return LiteXml.unescapeXML(contents);
    }

    public LiteXml[] getChildNodes(String nodeType) {
        if (nodeType == null) {
            return null;
        }
        LiteXml[] children = this.getChildNodes();
        if (children == null) {
            return null;
        }
        boolean[] isMatch = new boolean[children.length];
        int matches = 0;
        for (int i = 0; i < children.length; ++i) {
            LiteXml child = children[i];
            if (!child.getNodeType().equals(nodeType)) continue;
            ++matches;
            isMatch[i] = true;
        }
        if (matches == 0) {
            return null;
        }
        if (matches == children.length) {
            return children;
        }
        LiteXml[] matchingNodes = new LiteXml[matches];
        matches = 0;
        for (int i = 0; i < isMatch.length; ++i) {
            if (!isMatch[i]) continue;
            matchingNodes[matches] = children[i];
            ++matches;
        }
        return matchingNodes;
    }

    public LiteXml[] getChildNodes() {
        if (this.xml == null) {
            return null;
        }
        String insides = this.getRawNodeValue();
        if (insides == null || this.isCDATA(insides)) {
            return null;
        }
        int[] endpoints = new int[30];
        int marker = 0;
        int len = insides.length();
        int count = 0;
        while (marker < len) {
            int opening;
            if (count * 2 >= endpoints.length) {
                endpoints = this.extendArray(endpoints);
            }
            if ((opening = insides.indexOf(60, marker)) < 0) break;
            if (insides.charAt(opening + 1) == '/') {
                return null;
            }
            int closing = insides.indexOf(62, opening + 1);
            if (closing < 0) {
                return null;
            }
            if (insides.charAt(closing - 1) == '/') {
                endpoints[count * 2] = opening;
                endpoints[count * 2 + 1] = closing + 1;
                ++count;
                marker = closing + 1;
                continue;
            }
            int spacePos = insides.indexOf(32, opening + 1);
            int bracketPos = insides.indexOf(62, opening + 1);
            if (spacePos < 0 && bracketPos < 0) {
                return null;
            }
            int typeEnd = spacePos;
            if (typeEnd < 0 || typeEnd > bracketPos) {
                typeEnd = bracketPos;
            }
            String type = insides.substring(opening + 1, typeEnd);
            String childEnd = "</" + type;
            int childEndPos = insides.indexOf(childEnd, closing + 1);
            String nestedSOB = "<" + type;
            int nestedPos = insides.indexOf(nestedSOB, closing + 1);
            while (nestedPos > -1 && nestedPos < childEndPos) {
                if ((childEndPos = insides.indexOf(childEnd, childEndPos + 3)) < 0) {
                    return null;
                }
                nestedPos = insides.indexOf(nestedSOB, nestedPos + 3);
            }
            int finalBoundary = insides.indexOf(62, childEndPos + 2);
            if (finalBoundary < 0) {
                return null;
            }
            endpoints[count * 2] = opening;
            endpoints[count * 2 + 1] = finalBoundary + 1;
            ++count;
            marker = finalBoundary + 1;
        }
        if (count < 1) {
            return null;
        }
        LiteXml[] children = new LiteXml[count];
        for (int i = 0; i < count; ++i) {
            LiteXml child;
            int beg = endpoints[i * 2];
            int end = endpoints[i * 2 + 1];
            children[i] = child = new LiteXml(insides.substring(beg, end));
        }
        return children;
    }

    private int[] extendArray(int[] endpoints) {
        int[] largerArray = new int[endpoints.length + 30];
        System.arraycopy(endpoints, 0, largerArray, 0, endpoints.length);
        return largerArray;
    }

    public LiteXml getFirstChild() {
        LiteXml[] children = this.getChildNodes();
        if (children == null) {
            return null;
        }
        return children[0];
    }

    public String getPathValue(String xpathLite) {
        LiteXml x = this.findNode(xpathLite);
        if (x == null) {
            return null;
        }
        return x.getNodeValue();
    }

    public String getNodeValue(String branchPath) {
        if (branchPath == null) {
            return null;
        }
        String actualPath = this.normalizeBranchPath(branchPath);
        return this.getPathValue(actualPath);
    }

    private String normalizeBranchPath(String branchPath) {
        if (branchPath == null) {
            return null;
        }
        if (branchPath.startsWith("/")) {
            return "*" + branchPath;
        }
        return "*/" + branchPath;
    }

    public LiteXml findChildNode(String branchPath) {
        return this.findNode(this.normalizeBranchPath(branchPath));
    }

    public LiteXml findNode(String xpathLite) {
        if (xpathLite == null) {
            return null;
        }
        if (xpathLite.charAt(0) == '/') {
            if (xpathLite.charAt(1) == '/') {
                return null;
            }
            xpathLite = xpathLite.substring(1);
        }
        StringTokenizer splitter = new StringTokenizer(xpathLite, "/");
        int depth = splitter.countTokens();
        String[] nodeNames = new String[depth];
        for (int i = 0; i < depth; ++i) {
            nodeNames[i] = splitter.nextToken();
        }
        return this.findNode(nodeNames);
    }

    public LiteXml findNode(String[] xpathLite) {
        return this.findNodeX(xpathLite, 0);
    }

    private static boolean isMatch(String nodeName, String pattern) {
        if (nodeName == null || pattern == null) {
            return false;
        }
        if (nodeName.equals(pattern)) {
            return true;
        }
        return pattern.equals("*");
    }

    private LiteXml findNodeX(String[] xpathLite, int x) {
        if (LiteXml.isMatch(this.getNodeType(), xpathLite[x])) {
            LiteXml[] childNodes = this.getChildNodes();
            if (childNodes == null) {
                return null;
            }
            for (int i = 0; i < childNodes.length; ++i) {
                LiteXml child = childNodes[i];
                String nodeType = child.getNodeType();
                if (!LiteXml.isMatch(nodeType, xpathLite[x + 1])) continue;
                if (xpathLite.length == x + 2) {
                    return child;
                }
                LiteXml node = child.findNodeX(xpathLite, x + 1);
                if (node == null) continue;
                return node;
            }
            return null;
        }
        return null;
    }

    public static String unescapeXML(String xml) {
        StringBuffer unescapedOutput = new StringBuffer(xml.length());
        Matcher m = XML_ENTITY_REGEX.matcher(xml);
        while (m.find()) {
            String entity;
            String ent = m.group(2);
            String hashmark = m.group(1);
            if (hashmark != null && hashmark.length() > 0) {
                int code = ent.substring(0, 1).toLowerCase().equals("x") ? Integer.parseInt(ent.substring(1), 16) : Integer.parseInt(ent);
                entity = Character.toString((char)code);
            } else {
                entity = STD_ENTITIES.get(ent);
                if (entity == null) {
                    entity = "&" + ent + ';';
                }
            }
            m.appendReplacement(unescapedOutput, entity);
        }
        m.appendTail(unescapedOutput);
        return unescapedOutput.toString();
    }

    private static Map<String, String> getStandardEntities() {
        HashMap<String, String> entities = new HashMap<String, String>(10);
        entities.put("lt", "<");
        entities.put("gt", ">");
        entities.put("amp", "&");
        entities.put("apos", "'");
        entities.put("quot", "\"");
        return entities;
    }

    public String toString() {
        return this.xml;
    }
}

