/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.EndOfSnippetException;
import com.x5.template.Snippet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDoc
implements Iterator<Doclet>,
Iterable<Doclet> {
    private static final String COMMENT_START = "{!--";
    private static final String COMMENT_END = "--}";
    public static final String LITERAL_START = "{^literal}";
    public static final String LITERAL_START2 = "{.literal}";
    public static final String LITERAL_SHORTHAND = "{^^}";
    public static final String LITERAL_END = "{^}";
    public static final String LITERAL_END_LONGHAND = "{/literal}";
    private static final String SUB_START = "{#";
    private static final String SUB_NAME_END = "}";
    private static final String SUB_END = "{#}";
    private static final String SKIP_BLANK_LINE = "";
    public static final String MACRO_START = "{*";
    public static final String MACRO_NAME_END = "}";
    public static final String MACRO_END = "{*}";
    public static final String MACRO_LET = "{=";
    public static final String MACRO_LET_END = "}";
    private String stub;
    private InputStream in;
    private String encoding = TemplateDoc.getDefaultEncoding();
    private Doclet queued = null;
    private BufferedReader brTemp;
    private StringBuilder rootTemplate = new StringBuilder();
    private String line = null;
    private ArrayList<String> lineStack = new ArrayList();
    private ArrayList<String> nameStack = new ArrayList();
    private ArrayList<StringBuilder> bufferStack = new ArrayList();
    private static final Pattern SUPER_TAG = Pattern.compile("\\{\\% *super *\\%?\\}");
    private static final String LITERAL_OPEN = "(\\{\\^\\^\\}|\\{[\\.\\^]literal\\}|\\{\\% *literal *\\%?\\})";
    private static final Pattern LITERAL_OPEN_HERE = Pattern.compile("\\G(\\{\\^\\^\\}|\\{[\\.\\^]literal\\}|\\{\\% *literal *\\%?\\})");
    private static final Pattern LITERAL_OPEN_ANYWHERE = Pattern.compile("(\\{\\^\\^\\}|\\{[\\.\\^]literal\\}|\\{\\% *literal *\\%?\\})");
    private static final Pattern LITERAL_CLOSE = Pattern.compile("(\\{\\^\\}|\\{/literal\\}|\\{\\% *endliteral *\\%?\\})");

    public TemplateDoc(String name, String rawTemplate) {
        this.stub = TemplateDoc.truncateNameToStub(name);
        try {
            this.in = new ByteArrayInputStream(rawTemplate.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            this.in = new ByteArrayInputStream(rawTemplate.getBytes());
        }
    }

    public TemplateDoc(String name, InputStream in) {
        this.stub = TemplateDoc.truncateNameToStub(name);
        this.in = in;
    }

    public Iterable<Doclet> parseTemplates(String encoding) throws IOException {
        this.encoding = encoding;
        this.brTemp = new BufferedReader(new InputStreamReader(this.in, encoding));
        return this;
    }

    static String truncateNameToStub(String name) {
        String stub;
        int slashPos = name.lastIndexOf(47);
        if (slashPos < -1) {
            slashPos = name.lastIndexOf(92);
        }
        String folder = null;
        if (slashPos > -1) {
            folder = name.substring(0, slashPos + 1);
            stub = name.substring(slashPos + 1);
        } else {
            stub = name;
        }
        int hashPos = stub.indexOf("#");
        if (hashPos > -1) {
            stub = stub.substring(0, hashPos);
        }
        if (slashPos > -1) {
            char fs = System.getProperty("file.separator").charAt(0);
            folder.replace('\\', fs);
            folder.replace('/', fs);
            return folder + stub;
        }
        return stub;
    }

    protected Doclet nextTemplate() throws IOException {
        Doclet subtpl;
        if (this.rootTemplate == null) {
            return null;
        }
        if (this.bufferStack.size() > 0 && (subtpl = this.nextSubtemplate(this.popNameFromStack(), SKIP_BLANK_LINE)) != null) {
            return subtpl;
        }
        while (this.brTemp.ready()) {
            int subNameEnd;
            int subEndPos;
            this.line = this.brTemp.readLine();
            if (this.line == null) break;
            int comPos = this.line.indexOf(COMMENT_START);
            int subPos = this.line.indexOf(SUB_START);
            while (comPos > -1 && (subPos < 0 || subPos > comPos)) {
                StringBuilder commentBuf = new StringBuilder();
                this.line = this.skipComment(comPos, this.line, this.brTemp, commentBuf);
                String beforeComment = this.line.substring(0, comPos);
                String afterComment = this.line.substring(comPos);
                this.rootTemplate.append(beforeComment);
                this.rootTemplate.append((CharSequence)commentBuf);
                this.line = afterComment;
                comPos = this.line.indexOf(COMMENT_START);
                subPos = this.line.indexOf(SUB_START);
            }
            Doclet subtpl2 = null;
            boolean lineFeed = true;
            if (subPos > -1 && (subEndPos = this.line.indexOf(SUB_END)) != subPos && (subNameEnd = this.line.indexOf("}", subPos + SUB_START.length())) > -1) {
                this.rootTemplate.append(this.line.substring(0, subPos));
                String subName = this.line.substring(subPos + SUB_START.length(), subNameEnd);
                String restOfLine = this.line.substring(subNameEnd + "}".length());
                subtpl2 = this.nextSubtemplate(this.stub + "#" + subName, restOfLine);
                if (this.line.length() < 1) {
                    lineFeed = false;
                }
            }
            if (lineFeed) {
                this.rootTemplate.append(this.line);
                this.rootTemplate.append("\n");
            }
            if (subtpl2 == null) continue;
            return subtpl2;
        }
        String root = this.rootTemplate.toString();
        this.rootTemplate = null;
        return new Doclet(this.stub, root, this.stub);
    }

    private String getCommentLines(int comBegin, String firstLine, BufferedReader brTemp, StringBuilder sbTemp) throws IOException {
        int comEnd = firstLine.indexOf(COMMENT_END, comBegin + 2);
        int endMarkerLen = COMMENT_END.length();
        if (comEnd > -1) {
            sbTemp.append(firstLine.substring(0, comEnd += endMarkerLen));
            return firstLine.substring(comEnd);
        }
        sbTemp.append(firstLine);
        sbTemp.append("\n");
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            comEnd = line.indexOf(COMMENT_END);
            if (comEnd > -1) {
                sbTemp.append(line.substring(0, comEnd += endMarkerLen));
                return line.substring(comEnd);
            }
            sbTemp.append(line);
            sbTemp.append("\n");
        }
        return SKIP_BLANK_LINE;
    }

    private String getLiteralLines(int litBegin, String firstLine, BufferedReader brTemp, StringBuilder sbTemp) throws IOException {
        Matcher m = LITERAL_CLOSE.matcher(firstLine);
        if (m.find(litBegin + 2)) {
            int litEnd = m.end();
            sbTemp.append(firstLine.substring(0, litEnd));
            return firstLine.substring(litEnd);
        }
        sbTemp.append(firstLine);
        sbTemp.append("\n");
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            m.reset(line);
            if (m.find()) {
                int litEnd = m.end();
                sbTemp.append(line.substring(0, litEnd));
                return line.substring(litEnd);
            }
            sbTemp.append(line);
            sbTemp.append("\n");
        }
        return SKIP_BLANK_LINE;
    }

    private String skipComment(int comPos, String firstLine, BufferedReader brTemp, StringBuilder commentBuf) throws IOException {
        String beforeComment = firstLine.substring(0, comPos);
        int comEndPos = firstLine.indexOf(COMMENT_END);
        if (comEndPos > -1) {
            commentBuf.append(firstLine.substring(comPos, comEndPos += COMMENT_END.length()));
            return beforeComment + firstLine.substring(comEndPos);
        }
        commentBuf.append(firstLine.substring(comPos));
        commentBuf.append("\n");
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            comEndPos = line.indexOf(COMMENT_END);
            if (comEndPos > -1) {
                commentBuf.append(line.substring(0, comEndPos += COMMENT_END.length()));
                return beforeComment + line.substring(comEndPos);
            }
            commentBuf.append(line);
            commentBuf.append("\n");
        }
        return beforeComment;
    }

    private String stripComment(int comPos, String firstLine, BufferedReader brTemp) throws IOException {
        String beforeComment = firstLine.substring(0, comPos);
        int comEndPos = firstLine.indexOf(COMMENT_END);
        if (comEndPos > -1) {
            return beforeComment + firstLine.substring(comEndPos += COMMENT_END.length());
        }
        String line = null;
        while (brTemp.ready() && (line = brTemp.readLine()) != null) {
            comEndPos = line.indexOf(COMMENT_END);
            if (comEndPos <= -1) continue;
            return beforeComment + line.substring(comEndPos += COMMENT_END.length());
        }
        return beforeComment;
    }

    public static int findLiteralMarker(String text) {
        return TemplateDoc.findLiteralMarker(text, 0);
    }

    public static int findLiteralMarker(String text, int startAt) {
        Matcher m = LITERAL_OPEN_ANYWHERE.matcher(text);
        if (m.find(startAt)) {
            return m.start();
        }
        return -1;
    }

    private Doclet nextSubtemplate(String name, String firstLine) throws IOException {
        StringBuilder sbTemp = this.bufferStack.size() > 0 ? this.popBufferFromStack() : new StringBuilder();
        int subEndPos = firstLine.indexOf(SUB_END);
        int comPos = firstLine.indexOf(COMMENT_START);
        int literalPos = TemplateDoc.findLiteralMarker(firstLine);
        boolean skipFirstLine = false;
        while ((literalPos > -1 || comPos > -1) && (subEndPos <= -1 || literalPos >= 0 && subEndPos >= literalPos || comPos >= 0 && subEndPos >= comPos)) {
            while (!(literalPos <= -1 || comPos >= 0 && comPos <= literalPos || subEndPos >= 0 && subEndPos <= literalPos)) {
                firstLine = this.getLiteralLines(literalPos, firstLine, this.brTemp, sbTemp);
                comPos = firstLine.indexOf(COMMENT_START);
                subEndPos = firstLine.indexOf(SUB_END);
                literalPos = TemplateDoc.findLiteralMarker(firstLine);
            }
            while (!(comPos <= -1 || subEndPos >= 0 && subEndPos <= comPos || literalPos >= 0 && literalPos <= comPos)) {
                int lenAfter;
                int lenBefore = firstLine.length();
                if (lenBefore != (lenAfter = (firstLine = this.stripComment(comPos, firstLine, this.brTemp)).length()) && firstLine.trim().length() == 0) {
                    skipFirstLine = true;
                }
                comPos = firstLine.indexOf(COMMENT_START);
                subEndPos = firstLine.indexOf(SUB_END);
                literalPos = TemplateDoc.findLiteralMarker(firstLine);
            }
        }
        if (subEndPos > -1) {
            sbTemp.append(firstLine.substring(0, subEndPos));
            this.line = firstLine.substring(subEndPos + SUB_END.length());
            return new Doclet(name, sbTemp.toString(), this.stub);
        }
        if (!skipFirstLine) {
            sbTemp.append(firstLine);
            if (this.brTemp.ready() && firstLine.length() > 0) {
                sbTemp.append("\n");
            }
        }
        while (this.brTemp.ready()) {
            try {
                Doclet nested = this.getNestedTemplate(name, sbTemp);
                if (nested != null) {
                    return nested;
                }
                String line = this.popLineFromStack();
                if (line == null) break;
                if (line == SKIP_BLANK_LINE) continue;
                sbTemp.append(line);
                if (!this.brTemp.ready()) continue;
                sbTemp.append("\n");
            }
            catch (EndOfSnippetException e) {
                this.line = e.getRestOfLine();
                return new Doclet(name, sbTemp.toString(), this.stub);
            }
        }
        this.line = SKIP_BLANK_LINE;
        return new Doclet(name, sbTemp.toString(), this.stub);
    }

    private StringBuilder popBufferFromStack() {
        if (this.bufferStack.size() > 0) {
            return this.bufferStack.remove(this.bufferStack.size() - 1);
        }
        return null;
    }

    private String popLineFromStack() {
        return this.popStringFromStack(this.lineStack);
    }

    private String popNameFromStack() {
        return this.popStringFromStack(this.nameStack);
    }

    private String popStringFromStack(ArrayList<String> stack) {
        if (stack.size() > 0) {
            return stack.remove(stack.size() - 1);
        }
        return null;
    }

    private Doclet getNestedTemplate(String name, StringBuilder sbTemp) throws IOException, EndOfSnippetException {
        String line = this.brTemp.readLine();
        if (line == null) {
            this.lineStack.add(null);
            return null;
        }
        int comPos = line.indexOf(COMMENT_START);
        int subPos = line.indexOf(SUB_START);
        int subEndPos = line.indexOf(SUB_END);
        int litPos = TemplateDoc.findLiteralMarker(line);
        while ((litPos > -1 || comPos > -1) && (subEndPos <= -1 || litPos >= 0 && subEndPos >= litPos || comPos >= 0 && comPos >= subEndPos) && (subPos <= -1 || litPos >= 0 && subPos >= litPos || comPos >= 0 && comPos >= subPos)) {
            while (!(litPos <= -1 || comPos >= 0 && comPos <= litPos || subEndPos >= 0 && subEndPos <= litPos)) {
                line = this.getLiteralLines(litPos, line, this.brTemp, sbTemp);
                comPos = line.indexOf(COMMENT_START);
                subPos = line.indexOf(SUB_START);
                subEndPos = line.indexOf(SUB_END);
                litPos = TemplateDoc.findLiteralMarker(line);
            }
            while (!(comPos <= -1 || subPos >= 0 && subPos <= comPos || subEndPos >= 0 && subEndPos <= comPos || litPos >= 0 && litPos <= comPos)) {
                line = this.getCommentLines(comPos, line, this.brTemp, sbTemp);
                comPos = line.indexOf(COMMENT_START);
                subPos = line.indexOf(SUB_START);
                subEndPos = line.indexOf(SUB_END);
                litPos = TemplateDoc.findLiteralMarker(line);
            }
        }
        if (subPos > -1 || subEndPos > -1) {
            int subNameEnd;
            if (subEndPos > -1 && (subPos == -1 || subEndPos <= subPos)) {
                sbTemp.append(line.substring(0, subEndPos));
                throw new EndOfSnippetException(line.substring(subEndPos + SUB_END.length()));
            }
            if (subPos > -1 && (subNameEnd = line.indexOf("}", subPos + SUB_START.length())) > -1) {
                sbTemp.append(line.substring(0, subPos));
                String subName = line.substring(subPos + SUB_START.length(), subNameEnd);
                String restOfLine = line.substring(subNameEnd + "}".length());
                this.bufferStack.add(sbTemp);
                this.nameStack.add(name);
                Doclet nested = this.nextSubtemplate(name + "#" + subName, restOfLine);
                if (line.length() < 1) {
                    this.lineStack.add(SKIP_BLANK_LINE);
                }
                return nested;
            }
        }
        this.lineStack.add(line);
        return null;
    }

    public static StringBuilder expandShorthand(String name, StringBuilder template) {
        if (template.indexOf("{^super}") > -1 || template.indexOf("{.super}") > -1) {
            return null;
        }
        Matcher m = SUPER_TAG.matcher(template);
        if (m.find()) {
            return null;
        }
        int cursor = template.indexOf("{");
        while (cursor > -1) {
            if (template.length() == cursor + 1) {
                return template;
            }
            int afterBrace = template.charAt(cursor + 1);
            if (afterBrace == 94 || afterBrace == 46 || afterBrace == 37) {
                int afterLiteralBlock = TemplateDoc.skipLiterals(template, cursor);
                if (afterLiteralBlock != cursor) {
                    cursor = afterLiteralBlock;
                } else {
                    if (afterBrace != 37) {
                        template.replace(cursor + 1, cursor + 2, "~.");
                    } else {
                        int exprStart;
                        for (exprStart = cursor + 2; exprStart < template.length() && Character.isWhitespace(template.charAt(exprStart)); ++exprStart) {
                        }
                        afterBrace = template.charAt(exprStart);
                        if ("~$%^./!*=+_".indexOf(afterBrace) < 0) {
                            template.replace(exprStart, exprStart, "~.");
                            afterBrace = 126;
                        }
                    }
                    cursor += 2;
                }
            } else if (afterBrace == 47) {
                template.replace(cursor + 1, cursor + 2, "~./");
            } else {
                cursor += 2;
            }
            if (cursor <= -1) continue;
            cursor = template.indexOf("{", cursor);
        }
        return template;
    }

    private static int skipLiterals(StringBuilder template, int cursor) {
        int scanStart = cursor;
        Matcher m = LITERAL_OPEN_HERE.matcher(template);
        if (m.find(scanStart)) {
            scanStart = m.end();
        }
        if (scanStart > cursor) {
            m = LITERAL_CLOSE.matcher(template);
            if (m.find(scanStart)) {
                return m.end();
            }
            return template.length();
        }
        return cursor;
    }

    public static int nextUnescapedDelim(String delim, StringBuilder sb, int searchFrom) {
        int delimPos = sb.indexOf(delim, searchFrom);
        boolean isProvenDelimeter = false;
        while (!isProvenDelimeter) {
            int bsCount = 0;
            while (delimPos - (1 + bsCount) >= searchFrom && sb.charAt(delimPos - (1 + bsCount)) == '\\') {
                ++bsCount;
            }
            if (bsCount % 2 == 0) {
                isProvenDelimeter = true;
                continue;
            }
            if ((delimPos = sb.indexOf(delim, delimPos + 1)) >= 0) continue;
            return -1;
        }
        return delimPos;
    }

    @Override
    public boolean hasNext() {
        if (this.queued != null) {
            return true;
        }
        try {
            this.queued = this.nextTemplate();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return this.queued != null;
    }

    @Override
    public Doclet next() {
        if (this.queued != null) {
            Doclet nextDoc = this.queued;
            this.queued = null;
            return nextDoc;
        }
        try {
            return this.nextTemplate();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<Doclet> iterator() {
        return this;
    }

    static String getDefaultEncoding() {
        String override = System.getProperty("chunk.template.charset");
        if (override != null) {
            if (override.equalsIgnoreCase("SYSTEM")) {
                return Charset.defaultCharset().toString();
            }
            return override;
        }
        return "UTF-8";
    }

    public class Doclet {
        private String name;
        private String rawTemplate;
        private String origin;

        public Doclet(String name, String rawTemplate, String origin) {
            this.name = name;
            this.rawTemplate = rawTemplate;
            this.origin = origin;
        }

        public String getName() {
            return this.name;
        }

        public String getTemplate() {
            return this.rawTemplate;
        }

        public String getOrigin() {
            return this.origin;
        }

        public Snippet getSnippet() {
            return Snippet.getSnippet(this.rawTemplate, this.origin);
        }
    }
}

