/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.TemplateSet;
import com.x5.template.filters.RegexFilter;

public class FilterArgs {
    private String rawInvocation;
    private String rawArgs;
    private String filterName;
    private String[] filterArgs;

    public FilterArgs(String filterInvocation) {
        this.rawInvocation = filterInvocation;
        this.init();
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String[] getFilterArgs() {
        return this.filterArgs;
    }

    public String getUnparsedFilter() {
        return this.rawInvocation;
    }

    public String getUnparsedArgs() {
        return this.rawArgs;
    }

    private void init() {
        this.filterName = this.rawInvocation;
        int parenPos = this.rawInvocation.indexOf(40);
        int slashPos = this.rawInvocation.indexOf(47);
        if (slashPos > -1 && (parenPos < 0 || parenPos > slashPos)) {
            this.filterName = this.rawInvocation.substring(0, slashPos);
            this.rawArgs = this.rawInvocation.substring(slashPos);
            this.filterArgs = new String[]{this.rawArgs};
        } else if (parenPos > -1) {
            this.filterName = this.rawInvocation.substring(0, parenPos);
            int closeParenPos = this.rawInvocation.lastIndexOf(")");
            if (closeParenPos > parenPos) {
                this.rawArgs = this.rawInvocation.substring(parenPos + 1, closeParenPos);
                this.filterArgs = FilterArgs.parseArgs(this.rawArgs);
            }
        }
    }

    private static String[] parseArgs(String parenthetical) {
        return FilterArgs.parseArgs(parenthetical, true);
    }

    private static String[] parseArgs(String filter, boolean splitOnComma) {
        int quote4;
        int quote3;
        int quote2;
        int quote1 = filter.indexOf("\"");
        boolean isQuoted = true;
        if (quote1 < 0 || filter.substring(0, quote1).trim().length() > 0) {
            quote1 = -1;
            quote2 = filter.length();
            isQuoted = false;
        } else {
            quote2 = filter.indexOf("\"", quote1 + 1);
            if (quote2 < 0) {
                quote2 = filter.length();
            }
        }
        String arg0 = filter.substring(quote1 + 1, quote2);
        String arg1 = null;
        if (isQuoted && (quote3 = filter.indexOf("\"", quote2 + 1)) > 0 && (quote4 = filter.indexOf("\"", quote3 + 1)) > 0) {
            arg1 = filter.substring(quote3 + 1, quote4);
        }
        if (arg1 != null) {
            return new String[]{arg0, arg1};
        }
        if (isQuoted || !splitOnComma || arg0.indexOf(",") < 0) {
            return new String[]{arg0};
        }
        return FilterArgs.parseCommaDelimitedArgs(arg0);
    }

    private static String[] parseCommaDelimitedArgs(String argStr) {
        int nextParen;
        String finalArg;
        int commaPos;
        String[] args = new String[15];
        int argX = 0;
        int marker = 0;
        while (argX < args.length && (commaPos = FilterArgs.nextArgDelim(argStr, marker)) >= 0) {
            int endRegexPos;
            String regexOpen;
            String arg;
            int endQuotePos;
            int quotePos = FilterArgs.nextUnescapedDelim("\"", argStr, marker);
            if (quotePos > -1 && quotePos < commaPos && argStr.substring(marker, quotePos).trim().length() == 0 && (endQuotePos = FilterArgs.nextUnescapedDelim("\"", argStr, quotePos + 1)) > 0) {
                args[argX] = arg = argStr.substring(quotePos + 1, endQuotePos);
                ++argX;
                commaPos = FilterArgs.nextArgDelim(argStr, endQuotePos + 1);
                if (commaPos > 0) {
                    marker = commaPos + 1;
                    continue;
                }
                marker = argStr.length();
                continue;
            }
            int regexPos = RegexFilter.nextRegexDelim(argStr, marker);
            if (regexPos > -1 && regexPos < commaPos && ((regexOpen = argStr.substring(marker, regexPos).trim()).length() == 0 || regexOpen.equals("m")) && (endRegexPos = RegexFilter.nextRegexDelim(argStr, regexPos + 1)) > 0) {
                String arg2;
                int endArgPos = commaPos = FilterArgs.nextArgDelim(argStr, endRegexPos + 1);
                marker = commaPos < 0 ? (endArgPos = argStr.length()) : commaPos + 1;
                args[argX] = arg2 = argStr.substring(regexPos, endArgPos);
                ++argX;
                continue;
            }
            args[argX] = arg = argStr.substring(marker, commaPos);
            ++argX;
            marker = commaPos + 1;
            commaPos = FilterArgs.nextArgDelim(argStr, marker);
        }
        if (argX == args.length) {
            return args;
        }
        int closeParenPos = FilterArgs.nextUnescapedDelim(")", argStr, marker);
        int finalArgEnd = argStr.length();
        if (closeParenPos > 0) {
            finalArgEnd = closeParenPos;
        }
        args[argX] = finalArg = argStr.substring(marker, finalArgEnd);
        if (++argX + 1 < args.length && closeParenPos > 0 && closeParenPos + 1 < argStr.length() && (nextParen = argStr.indexOf(40, closeParenPos + 1)) > 0) {
            String appendixArg;
            String appendixTag = argStr.substring(closeParenPos + 1, nextParen);
            args[argX] = "|" + appendixTag + "|";
            ++argX;
            int endPos = argStr.length();
            if (argStr.endsWith(")")) {
                --endPos;
            }
            args[argX] = appendixArg = argStr.substring(nextParen + 1, endPos);
            ++argX;
        }
        String[] truncated = new String[argX];
        System.arraycopy(args, 0, truncated, 0, argX);
        return truncated;
    }

    public static String magicBraces(Chunk context, String output) {
        if (output == null || output.length() == 0) {
            return output;
        }
        char firstChar = output.charAt(0);
        if (firstChar == '~' || firstChar == '$') {
            return context != null ? context.makeTag(output) : "{" + output + "}";
        }
        if (firstChar == '^' || firstChar == '.') {
            if (context == null) {
                return "{." + output.substring(1) + TemplateSet.DEFAULT_TAG_END;
            }
            return context.makeTag('.' + output.substring(1));
        }
        if (firstChar == '+') {
            return "{" + output + "}";
        }
        return output;
    }

    public static int nextArgDelim(String arglist, int searchFrom) {
        return FilterArgs.nextUnescapedDelim(",", arglist, searchFrom);
    }

    public static int nextUnescapedDelim(String delim, String regex, int searchFrom) {
        int delimPos = regex.indexOf(delim, searchFrom);
        boolean isProvenDelimeter = false;
        while (!isProvenDelimeter) {
            int bsCount = 0;
            while (delimPos - (1 + bsCount) >= searchFrom && regex.charAt(delimPos - (1 + bsCount)) == '\\') {
                ++bsCount;
            }
            if (bsCount % 2 == 0) {
                isProvenDelimeter = true;
                continue;
            }
            if ((delimPos = regex.indexOf(delim, delimPos + 1)) >= 0) continue;
            return -1;
        }
        return delimPos;
    }

    public static int grokValidColonScanPoint(String wholeTag, int startHere) {
        int openParen;
        if (wholeTag.charAt(startHere) == 's' && wholeTag.charAt(startHere + 1) == '/') {
            int regexMid = RegexFilter.nextRegexDelim(wholeTag, startHere + 2);
            int regexEnd = RegexFilter.nextRegexDelim(wholeTag, regexMid + 1);
            return regexEnd + 1;
        }
        if (wholeTag.length() > startHere + 7 && wholeTag.substring(startHere, startHere + 7).equals("onmatch")) {
            int commaPos;
            int slashPos;
            boolean skippedArgs = false;
            startHere += 8;
            while (!skippedArgs && (slashPos = wholeTag.indexOf("/", startHere)) >= 0 && (slashPos = RegexFilter.nextRegexDelim(wholeTag, slashPos + 1)) >= 0 && (commaPos = FilterArgs.nextUnescapedDelim(",", wholeTag, slashPos + 1)) >= 0) {
                int moreArgs = FilterArgs.nextUnescapedDelim(",", wholeTag, commaPos + 1);
                if (moreArgs < 0) {
                    int closeParen = FilterArgs.nextUnescapedDelim(")", wholeTag, commaPos + 1);
                    if (closeParen < 0) break;
                    if (wholeTag.length() > closeParen + 8 && wholeTag.substring(closeParen + 1, closeParen + 8).equals("nomatch")) {
                        startHere = closeParen + 1;
                        skippedArgs = true;
                        continue;
                    }
                    return closeParen + 1;
                }
                startHere = moreArgs + 1;
            }
        }
        if ((openParen = wholeTag.indexOf("(", startHere)) < 0) {
            return startHere;
        }
        int closeParen = FilterArgs.nextUnescapedDelim(")", wholeTag, openParen + 1);
        if (closeParen < 0) {
            return startHere;
        }
        return closeParen + 1;
    }
}

