/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.LoopTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import com.x5.util.LiteXml;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroTag
extends BlockTag {
    private String templateRef;
    private Snippet template;
    private Map<String, Object> macroDefs;
    private List<String> inputErrs = null;
    public static final String MACRO_MARKER = "exec";
    public static final String MACRO_END_MARKER = "/exec";
    private static final int ARG_START = "exec".length() + 2;
    private static final String FMT_CHUNK = "chunk";
    private static final String FMT_XML = "xml";
    private static final String FMT_JSON_LAX = "json";
    private static final String FMT_JSON_STRICT = "json-strict";
    private static final String FMT_ORIGINAL = "original";

    public MacroTag() {
    }

    public MacroTag(String tagName, Snippet body) {
        String defFormat = FMT_ORIGINAL;
        if (tagName.length() > ARG_START) {
            this.templateRef = tagName.substring(ARG_START).trim();
            int spacePos = this.templateRef.indexOf(32);
            if (spacePos > 0) {
                defFormat = this.templateRef.substring(spacePos + 1).toLowerCase();
                this.templateRef = this.templateRef.substring(0, spacePos);
            }
            if (this.templateRef.startsWith("@")) {
                this.templateRef = null;
            }
        }
        Snippet bodyDouble = body.copy();
        if (this.templateRef == null) {
            this.parseInlineTemplate(bodyDouble);
        }
        this.parseDefs(bodyDouble, defFormat);
    }

    private void parseInlineTemplate(Snippet body) {
        List<SnippetPart> parts = body.getParts();
        int bodyEnd = parts.size();
        for (int i = bodyEnd - 1; i >= 0; --i) {
            SnippetPart part = parts.get(i);
            if (!part.isTag()) continue;
            SnippetTag tag = (SnippetTag)part;
            if (tag.getTag().equals("./body")) {
                bodyEnd = i;
                continue;
            }
            if (!tag.getTag().equals(".body")) continue;
            Snippet inlineSnippet = new Snippet(parts, i + 1, bodyEnd);
            List<SnippetPart> inlineParts = inlineSnippet.getParts();
            LoopTag.smartTrimSnippetParts(inlineParts, false);
            this.template = inlineSnippet;
            for (int j = parts.size() - 1; j >= i; --j) {
                parts.remove(j);
            }
            return;
        }
    }

    private void parseDefs(Snippet body, String defFormat) {
        if (defFormat.equals(FMT_ORIGINAL)) {
            this.parseDefsOriginal(body);
        } else if (defFormat.equals(FMT_CHUNK)) {
            this.parseDefsSimplified(body);
        } else if (defFormat.equals(FMT_JSON_STRICT)) {
            this.parseDefsJsonStrict(body);
        } else if (defFormat.equals(FMT_JSON_LAX)) {
            this.parseDefsJsonLax(body);
        } else if (defFormat.equals(FMT_XML)) {
            this.parseDefsXML(body);
        }
    }

    private void parseDefsJsonLax(Snippet body) {
        String json = body.toString();
        try {
            Class.forName("net.minidev.json.JSONValue");
        }
        catch (ClassNotFoundException e) {
            this.logInputError("Error: template uses json-formatted args in exec, but json-smart jar is not in the classpath!");
        }
        Object parsedValue = JSONValue.parseKeepingOrder((String)json);
        if (parsedValue instanceof Map) {
            Map defs = (Map)parsedValue;
            this.importJSONDefs(defs);
        } else if (parsedValue instanceof JSONArray || parsedValue instanceof List) {
            this.logInputError("Error processing template: exec expected JSON object, not JSON array.");
        } else if (parsedValue instanceof String && parsedValue.toString().trim().length() > 0) {
            this.logInputError("Error processing template: exec expected JSON object, not String.");
        }
    }

    private void parseDefsJsonStrict(Snippet body) {
        try {
            String json = body.toString();
            try {
                Class.forName("net.minidev.json.JSONValue");
            }
            catch (ClassNotFoundException e) {
                this.logInputError("Error: template uses json-formatted args in exec, but json-smart jar is not in the classpath!");
            }
            Object parsedValue = this.parseStrictJsonKeepingOrder(json);
            if (parsedValue instanceof Map) {
                Map defs = (Map)parsedValue;
                this.importJSONDefs(defs);
            } else if (parsedValue instanceof JSONArray || parsedValue instanceof List) {
                this.logInputError("Error processing template: exec expected JSON object, not JSON array.");
            } else if (parsedValue instanceof String && parsedValue.toString().trim().length() > 0) {
                this.logInputError("Error processing template: exec expected JSON object, not String.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void logInputError(String errMsg) {
        if (this.inputErrs == null) {
            this.inputErrs = new ArrayList<String>();
        }
        this.inputErrs.add(errMsg);
    }

    private Object parseStrictJsonKeepingOrder(String json) throws ParseException {
        return new JSONParser(400).parse(json, ContainerFactory.FACTORY_ORDERED);
    }

    private void importJSONDefs(Map<String, Object> defs) {
        this.macroDefs = defs;
    }

    private void parseDefsSimplified(Snippet body) {
    }

    private void parseDefsXML(Snippet body) {
        LiteXml xml = new LiteXml(body.toString());
        this.macroDefs = this.parseXMLObject(xml);
    }

    private Map<String, Object> parseXMLObject(LiteXml xml) {
        LiteXml[] rules = xml.getChildNodes();
        if (rules == null) {
            return null;
        }
        HashMap<String, Object> tags = new HashMap<String, Object>();
        for (LiteXml rule : rules) {
            String tagName = rule.getNodeType();
            LiteXml[] children = rule.getChildNodes();
            if (children == null) {
                tags.put(tagName, rule.getNodeValue());
            } else {
                tags.put(tagName, this.parseXMLObject(rule));
            }
            Map<String, String> attrs = rule.getAttributes();
            if (attrs == null) continue;
            for (String key : attrs.keySet()) {
                tags.put(tagName + "@" + key, attrs.get(key));
            }
        }
        return tags;
    }

    private void parseDefsOriginal(Snippet body) {
        List<SnippetPart> parts = body.getParts();
        if (parts == null) {
            return;
        }
        for (int i = 0; i < parts.size(); ++i) {
            SnippetPart part = parts.get(i);
            if (!part.isTag()) continue;
            String tagText = ((SnippetTag)part).getTag();
            if (tagText.trim().endsWith("=")) {
                SnippetPart partJ;
                int j = this.findMatchingDefEnd(parts, i + 1);
                Snippet def = new Snippet(parts, i + 1, j);
                String varName = tagText.substring(0, tagText.length() - 1);
                this.saveDef(varName, def);
                i = j;
                if (j >= parts.size() || !(partJ = parts.get(j)).getText().equals("{=}")) continue;
                i = j + 1;
                continue;
            }
            String[] simpleDef = this.getSimpleDef(tagText);
            if (simpleDef == null) continue;
            this.saveDef(simpleDef[0], simpleDef[1]);
        }
    }

    private int findMatchingDefEnd(List<SnippetPart> parts, int startAt) {
        int allTheRest = parts.size();
        for (int i = startAt; i < allTheRest; ++i) {
            String tagText;
            int eqPos;
            SnippetPart part = parts.get(i);
            if (!part.isTag() || (eqPos = (tagText = ((SnippetTag)part).getTag()).indexOf(61)) < 0) continue;
            if (tagText.length() == 1) {
                return i;
            }
            char[] tagChars = tagText.toCharArray();
            int c = 61;
            for (int x = 0; x < eqPos; ++x) {
                c = tagChars[x];
                if (c != 46 && c != 124 && c != 58 && c != 40) continue;
                c = 0;
                break;
            }
            if (c == 0) continue;
            return i;
        }
        return allTheRest;
    }

    private String[] getSimpleDef(String tagText) {
        int eqPos = tagText.indexOf(61);
        if (eqPos > -1) {
            String varName = tagText.substring(0, eqPos).trim();
            String varValue = tagText.substring(eqPos + 1);
            if (varValue.charAt(0) == ' ' && tagText.charAt(eqPos - 1) == ' ') {
                varValue = varValue.trim();
            }
            String[] assignment = new String[]{varName, varValue};
            return assignment;
        }
        return null;
    }

    private void saveDef(String tag, String def) {
        if (tag == null || def == null) {
            return;
        }
        Snippet simple = Snippet.getSnippet(def);
        this.saveDef(tag, simple);
    }

    private void saveDef(String tag, Snippet snippet) {
        if (tag == null || snippet == null) {
            return;
        }
        if (this.macroDefs == null) {
            this.macroDefs = new HashMap<String, Object>();
        }
        this.macroDefs.put(tag, snippet);
    }

    @Override
    public void renderBlock(Writer out, Chunk context, int depth) throws IOException {
        Set<String> keys;
        Chunk macro = null;
        ChunkFactory theme = context.getChunkFactory();
        if (this.templateRef != null && theme != null) {
            macro = theme.makeChunk(this.templateRef);
        } else if (this.template != null) {
            macro = theme == null ? new Chunk() : theme.makeChunk();
            macro.append(this.template);
        } else {
            return;
        }
        if (this.inputErrs != null) {
            if (context.renderErrorsToOutput()) {
                for (String err : this.inputErrs) {
                    out.append('[');
                    out.append(err);
                    out.append(']');
                }
            }
            for (String err : this.inputErrs) {
                context.logError(err);
            }
        }
        if (this.macroDefs != null && (keys = this.macroDefs.keySet()) != null) {
            for (String tagName : keys) {
                Object o = this.macroDefs.get(tagName);
                macro.setOrDelete(tagName, this.resolvePointers(context, o, 0));
            }
        }
        macro.render(out, context);
    }

    private Object resolvePointers(Chunk context, Object o, int depth) {
        Snippet s;
        if (depth > 10) {
            return o;
        }
        if (o instanceof String) {
            o = Snippet.getSnippet((String)o);
        }
        if (o instanceof Snippet && (s = (Snippet)o).isSimplePointer()) {
            Object n = context.get(s.getPointer());
            if (n == null) {
                return o;
            }
            o = this.resolvePointers(context, n, depth + 1);
        }
        return o;
    }

    @Override
    public String getBlockStartMarker() {
        return MACRO_MARKER;
    }

    @Override
    public String getBlockEndMarker() {
        return MACRO_END_MARKER;
    }

    @Override
    public boolean doSmartTrimAroundBlock() {
        return true;
    }
}

