/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.TextFilter;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFilter
extends BasicFilter
implements ChunkFilter {
    private static final Pattern INNOCUOUS_CHARS = Pattern.compile("^[-A-Za-z0-9_ <>\"']*$");

    public String transformText(Chunk chunk, String text, String[] args) {
        if (text == null) {
            return text;
        }
        String regex = null;
        if (args != null && args.length > 0) {
            regex = args[0];
        }
        if (regex == null) {
            return text;
        }
        return RegexFilter.applyRegex(text, regex);
    }

    public String getFilterName() {
        return "s";
    }

    public static int nextRegexDelim(String regex, int searchFrom) {
        return TextFilter.nextUnescapedDelim("/", regex, searchFrom);
    }

    public static String applyRegex(String text, String regex) {
        int patternEnd;
        int patternStart = 1;
        if (regex.charAt(0) == 's') {
            patternStart = 2;
        }
        if ((patternEnd = RegexFilter.nextRegexDelim(regex, patternStart)) < 0) {
            return text;
        }
        int replaceEnd = RegexFilter.nextRegexDelim(regex, patternEnd + 1);
        if (replaceEnd < 0) {
            return text;
        }
        boolean greedy = false;
        boolean ignoreCase = false;
        boolean multiLine = false;
        boolean dotAll = false;
        for (int i = regex.length() - 1; i > replaceEnd; --i) {
            char option = regex.charAt(i);
            if (option == 'g') {
                greedy = true;
            }
            if (option == 'i') {
                ignoreCase = true;
            }
            if (option == 'm') {
                multiLine = true;
            }
            if (option != 's') continue;
            dotAll = true;
        }
        String pattern = regex.substring(patternStart, patternEnd);
        String replaceWith = regex.substring(patternEnd + 1, replaceEnd);
        replaceWith = RegexFilter.parseRegexEscapes(replaceWith);
        replaceWith = Chunk.findAndReplace(replaceWith, "\\", "\\\\");
        if (multiLine) {
            pattern = "(?m)" + pattern;
        }
        if (ignoreCase) {
            pattern = "(?i)" + pattern;
        }
        if (dotAll) {
            pattern = "(?s)" + pattern;
        }
        boolean caseConversions = false;
        if (replaceWith.matches(".*\\\\[UL][\\$\\\\]\\d.*")) {
            caseConversions = true;
            replaceWith = replaceWith.replaceAll("\\\\([UL])[\\$\\\\](\\d)", "!$1@\\$$2@$1!");
        }
        try {
            String result = null;
            result = greedy ? text.replaceAll(pattern, replaceWith) : text.replaceFirst(pattern, replaceWith);
            if (caseConversions) {
                return RegexFilter.applyCaseConversions(result);
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            return text + "[REGEX " + regex + " Error: " + e.getMessage() + "]";
        }
    }

    private static String applyCaseConversions(String result) {
        StringBuilder x = new StringBuilder();
        Matcher m = Pattern.compile("!U@(.*?)@U!").matcher(result);
        int last = 0;
        while (m.find()) {
            x.append(result.substring(last, m.start()));
            x.append(m.group(1).toUpperCase());
            last = m.end();
        }
        if (last > 0) {
            x.append(result.substring(last));
            result = x.toString();
            x = new StringBuilder();
            last = 0;
        }
        m = Pattern.compile("!L@(.*?)@L!").matcher(result);
        while (m.find()) {
            x.append(result.substring(last, m.start()));
            x.append(m.group(1).toLowerCase());
            last = m.end();
        }
        if (last > 0) {
            x.append(result.substring(last));
            return x.toString();
        }
        return result;
    }

    public static String parseRegexEscapes(String str) {
        if (str == null) {
            return str;
        }
        char[] strArr = str.toCharArray();
        boolean escape = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < strArr.length; ++i) {
            if (escape) {
                if (strArr[i] == 'b') {
                    buf.append('\b');
                } else if (strArr[i] == 't') {
                    buf.append('\t');
                } else if (strArr[i] == 'n') {
                    buf.append('\n');
                } else if (strArr[i] == 'r') {
                    buf.append('\r');
                } else if (strArr[i] == 'f') {
                    buf.append('\f');
                } else if (strArr[i] == 'U') {
                    buf.append("\\U");
                } else if (strArr[i] == 'L') {
                    buf.append("\\L");
                } else if (strArr[i] == 'u') {
                    if (i + 4 < strArr.length) {
                        int utf = Integer.parseInt(str.substring(i + 1, i + 5), 16);
                        buf.append((char)utf);
                        i += 4;
                    } else {
                        buf.append('\\');
                        buf.append(strArr[i]);
                    }
                } else if (Character.isDigit(strArr[i])) {
                    int j = 0;
                    for (j = 1; j < 2 && i + j < strArr.length && Character.isDigit(strArr[i + j]); ++j) {
                    }
                    int octal = Integer.parseInt(str.substring(i, i + j), 8);
                    buf.append((char)octal);
                    i += j - 1;
                } else {
                    buf.append(strArr[i]);
                }
                escape = false;
                continue;
            }
            if (strArr[i] == '\\') {
                escape = true;
                continue;
            }
            buf.append(strArr[i]);
        }
        return buf.toString();
    }

    public static String escapeRegex(String x) {
        Matcher m = INNOCUOUS_CHARS.matcher(x);
        if (m.find()) {
            return x;
        }
        StringBuilder noSpecials = new StringBuilder();
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c == ' ' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                noSpecials.append(c);
                continue;
            }
            noSpecials.append("\\");
            noSpecials.append(c);
        }
        return noSpecials.toString();
    }
}

