/*
 * Decompiled with CFR 0.152.
 */
package com.wunderlist.slidinglayer.utils;

public class Transitions {
    public static float intermediateValueForRange(float position, float[] values) {
        return Transitions.intermediateValueForRange(position, new float[]{0.0f, 1.0f}, values);
    }

    public static float intermediateValueForCuePoints(float position, float[] range) {
        return Transitions.intermediateValueForRange(position, range, range);
    }

    public static float intermediateValueForRange(float position, float[] cuePoints, float[] values) {
        if (cuePoints.length != values.length) {
            throw new IllegalArgumentException("Range and values arrays must be of the same size");
        }
        int length = cuePoints.length;
        if (position <= cuePoints[0]) {
            return values[0];
        }
        for (int i = 1; i < length; ++i) {
            float cuePoint = cuePoints[i];
            if (!(position <= cuePoint)) continue;
            float previousCuePoint = cuePoints[i - 1];
            float value = values[i];
            float previousValue = values[i - 1];
            float rangeRatio = (position - previousCuePoint) / (cuePoint - previousCuePoint);
            return previousValue + (value - previousValue) * rangeRatio;
        }
        return values[length - 1];
    }
}

