/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.mandates;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CreateMandateRequest;
import com.onlinepayments.domain.CreateMandateResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetMandateResponse;
import com.onlinepayments.merchant.mandates.MandatesClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class MandatesClient
extends ApiResource
implements MandatesClientInterface {
    public MandatesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CreateMandateResponse createMandate(CreateMandateRequest body) {
        return this.createMandate(body, null);
    }

    @Override
    public CreateMandateResponse createMandate(CreateMandateRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/mandates", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CreateMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetMandateResponse getMandate(String uniqueMandateReference) {
        return this.getMandate(uniqueMandateReference, null);
    }

    @Override
    public GetMandateResponse getMandate(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v2/{merchantId}/mandates/{uniqueMandateReference}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetMandateResponse blockMandate(String uniqueMandateReference) {
        return this.blockMandate(uniqueMandateReference, null);
    }

    @Override
    public GetMandateResponse blockMandate(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v2/{merchantId}/mandates/{uniqueMandateReference}/block", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetMandateResponse unblockMandate(String uniqueMandateReference) {
        return this.unblockMandate(uniqueMandateReference, null);
    }

    @Override
    public GetMandateResponse unblockMandate(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v2/{merchantId}/mandates/{uniqueMandateReference}/unblock", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetMandateResponse revokeMandate(String uniqueMandateReference) {
        return this.revokeMandate(uniqueMandateReference, null);
    }

    @Override
    public GetMandateResponse revokeMandate(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v2/{merchantId}/mandates/{uniqueMandateReference}/revoke", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

