/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.HeaderObfuscator;
import com.onlinepayments.logging.PropertyObfuscator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public final class LoggingUtil {
    private static final PropertyObfuscator PROPERTY_OBFUSCATOR = PropertyObfuscator.builder().withField("accountNumber").withField("bin").withField("cardNumber").withField("cvv").withField("expiryDate").withField("iban").withField("reformattedAccountNumber").withField("additionalInfo").withField("cardholderName").withField("dateOfBirth").withField("emailAddress").withField("faxNumber").withField("firstName").withField("houseNumber").withField("mobilePhoneNumber").withField("passengerName").withField("phoneNumber").withField("street").withField("surname").withField("workPhoneNumber").withField("zip").withField("value").withSensitiveField("keyId").withSensitiveField("publicKey").withSensitiveField("secretKey").withSensitiveField("userAuthenticationToken").withSensitiveField("encryptedCustomerInput").withSensitiveField("encryptedPayload").withSensitiveField("decryptedPayload").build();
    private static final HeaderObfuscator HEADER_OBFUSCATOR = HeaderObfuscator.builder().withSensitiveField("Authorization").withSensitiveField("Proxy-Authenticate").withSensitiveField("Proxy-Authorization").withSensitiveField("WWW-Authenticate").withSensitiveField("X-GCS-Authentication-Token").withSensitiveField("X-GCS-CallerPassword").build();

    private LoggingUtil() {
    }

    public static String obfuscateBody(CharSequence body) {
        return PROPERTY_OBFUSCATOR.obfuscate(body);
    }

    public static String obfuscateBody(InputStream bodyStream, Charset charset) throws IOException {
        return LoggingUtil.obfuscateBody(new InputStreamReader(bodyStream, charset));
    }

    public static String obfuscateBody(Reader bodyStream) throws IOException {
        int len;
        StringBuilder body = new StringBuilder();
        char[] buffer = new char[4096];
        while ((len = bodyStream.read(buffer)) != -1) {
            body.append(buffer, 0, len);
        }
        return LoggingUtil.obfuscateBody(body);
    }

    public static String obfuscateHeader(String name, String value) {
        return HEADER_OBFUSCATOR.obfuscateValue(name, value);
    }
}

