/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.Authenticator;
import com.onlinepayments.Communicator;
import com.onlinepayments.Connection;
import com.onlinepayments.Marshaller;
import com.onlinepayments.MetaDataProvider;
import com.onlinepayments.defaultimpl.DefaultCommunicator;
import java.net.URI;

public class CommunicatorBuilder {
    private URI apiEndpoint;
    private Connection connection;
    private MetaDataProvider metaDataProvider;
    private Authenticator authenticator;
    private Marshaller marshaller;

    public CommunicatorBuilder withAPIEndpoint(URI apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    public CommunicatorBuilder withConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public CommunicatorBuilder withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public CommunicatorBuilder withMetaDataProvider(MetaDataProvider metaDataProvider) {
        this.metaDataProvider = metaDataProvider;
        return this;
    }

    public CommunicatorBuilder withMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public Communicator build() {
        return new DefaultCommunicator(this.apiEndpoint, this.connection, this.authenticator, this.metaDataProvider, this.marshaller);
    }
}

