package com.ec.v2.utlis;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.config.Config;
import com.ec.v2.entity.SignEntity;
import com.ec.v2.entity.customer.file.CrmFileUploadVo;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.IOException;

public class HttpUtils {

	public static HttpPost buidPostRequest(String paramsJson, String postUrl) {
		Config config = Config.get();
		StringEntity postingString = new StringEntity(paramsJson, config.getEncoding());
		HttpPost post = new HttpPost(postUrl);
		post.setEntity(postingString);
		post.setHeader("Content-type", "application/json");
		Long timeStamp = System.currentTimeMillis();
		SignEntity sign = SignEntity.setSignParam(timeStamp, config);
		post.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
		post.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
		post.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
		return post;
	}

	public static HttpPost buidUploadRequest(CrmFileUploadVo params, String postUrl) {
		Config config = Config.get();
		HttpPost post = new HttpPost(postUrl);
		// 1. 设置请求头部 和 签名信息
		//post.setHeader("Content-type", "multipart/form-data;boundary="+System.currentTimeMillis());
		Long timeStamp = System.currentTimeMillis();
		SignEntity sign = SignEntity.setSignParam(timeStamp, config);
		post.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
		post.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
		post.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());

		// 2. 设置其他字段
		MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
		// 添加文件
		for (File file : params.getFiles()) {
			FileBody fileBin = new FileBody(file);
			builder.addPart("file", fileBin);
		}
		// 添加元数据
		builder.addTextBody("optUserId", params.getOptUserId() + "");
		builder.addTextBody("crmId", params.getCrmId() + "");

		HttpEntity reqEntity = builder.build();

		post.setEntity(reqEntity);

		return post;
	}

	public static HttpPost buidPostRequest(String postUrl) {
		Config config = Config.get();
		HttpPost post = new HttpPost(postUrl);
		post.setHeader("Content-type", "application/json");
		Long timeStamp = System.currentTimeMillis();
		SignEntity sign = SignEntity.setSignParam(timeStamp, config);
		post.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
		post.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
		post.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
		return post;
	}

	public static String buildUrl(String url) {
		return Config.get().getDomain() + url;
	}

	public static String post(String params, String url) throws IOException {
		// 1. 构建请求
		HttpPost post = buidPostRequest(params, url);
		// 2. 请求数据
		HttpClient httpClient = HttpClientBuilder.create().build();
		HttpResponse response = httpClient.execute(post);
		// 3. 解析结果
		return EntityUtils.toString(response.getEntity(), Config.get().getEncoding());
	}

	/**
	 * 文件上传
	 * 
	 * @param params
	 * @param url
	 * @return
	 * @throws IOException
	 */
	public static String crmFileUpload(CrmFileUploadVo params, String url) throws IOException {
		// 1. 构建请求
		HttpPost post = buidUploadRequest(params, url);
		// 2. 请求数据
		HttpClient httpClient = HttpClientBuilder.create().build();
		HttpResponse response = httpClient.execute(post);
		// 3. 解析结果
		return EntityUtils.toString(response.getEntity(), Config.get().getEncoding());
	}

	public static String post(String url) throws IOException {
		// 1. 构建请求
		HttpPost post = buidPostRequest(url);
		// 2. 请求数据
		HttpClient httpClient = HttpClientBuilder.create().build();
		HttpResponse response = httpClient.execute(post);
		// 3. 解析结果
		return EntityUtils.toString(response.getEntity(), Config.get().getEncoding());
	}

	public static String get(String url) throws IOException {
		HttpGet get = buidGetRequest(url);
		// 2. 请求数据
		HttpClient httpClient = HttpClientBuilder.create().build();
		HttpResponse response = httpClient.execute(get);
		// 3. 解析结果
		return EntityUtils.toString(response.getEntity(), Config.get().getEncoding());
	}

	public static String get(String url, Object dto) throws IOException {
		String jsonStr = JSONObject.toJSONString(dto);
		JSONObject json = JSONObject.parseObject(jsonStr);
		String parmas = buildGetParmas(json);
		url = url + "?" + parmas;
		return get(url);
	}

	private static String buildGetParmas(JSONObject json) {
		StringBuilder sb = new StringBuilder();
		int i = 0;
		for (String key : json.keySet()) {
			Object val = json.get(key);
			if (val == null) {
				continue;
			}
			String strVal = val.toString();
			if (strVal.trim().equals("")) {
				continue;
			}
			if (i > 0) {
				sb.append("&");
			}
			sb.append(key).append("=").append(strVal);
			i++;
		}
		return new String(sb);
	}

	public static HttpGet buidGetRequest(String postUrl) {
		Config config = Config.get();
		HttpGet get = new HttpGet(postUrl);
		get.setHeader("Content-type", "application/json");
		Long timeStamp = System.currentTimeMillis();
		SignEntity sign = SignEntity.setSignParam(timeStamp, config);
		get.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
		get.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
		get.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
		return get;
	}
}
