package com.ec.v2.service.statistics;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.statistics.DigitalMapDto;
import com.ec.v2.entity.statistics.DigitalMapResp;
import com.ec.v2.entity.statistics.HistogramDto;
import com.ec.v2.entity.statistics.HistogramResp;
import com.ec.v2.entity.statistics.parmas.WorkefficParmas;
import com.ec.v2.utlis.HttpUtils;

/**
 * 
 * @Title: Workeffic.java
 * @Description: 工作效率
 * @author shicy
 * @date 2020-04-21 11:23:19
 */
public class Workeffic {
	
	/**
	 * 
	 * @Title: digitalMap
	 * @Description: 工作效率-数字图-sdk
	 * @param dto
	 * @return
	 * @throws IOException
	 * @author shicy
	 * @date 2020-04-21 11:51:58
	 */
	public static DigitalMapResp digitalMap(DigitalMapDto<WorkefficParmas> dto) throws IOException {
		// 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.WORKEFFIC_DIGITALMAP);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str =  HttpUtils.post(paramsJson,postUrl);
        DigitalMapResp data = JSONObject.parseObject(str, DigitalMapResp.class);
        return data;
	}
	
	
	
	/**
	 * 
	 * @Title: histogram
	 * @Description: 工作效率-折线图-sdk
	 * @param dto
	 * @return
	 * @throws IOException
	 * @author shicy
	 * @date 2020-04-21 11:53:39
	 */
	public static HistogramResp histogram(HistogramDto<WorkefficParmas> dto) throws IOException {
		// 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.WORKEFFIC_HISTOGRAM);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str =  HttpUtils.post(paramsJson,postUrl);
        HistogramResp data = JSONObject.parseObject(str, HistogramResp.class);
        return data;
	}
	
	
	
}
