package com.ec.v2.service.statistics;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.statistics.*;
import com.ec.v2.entity.statistics.parmas.CrmQuantityParam;
import com.ec.v2.utlis.HttpUtils;

/**
 * 
 * @Title: CrmQuantity.java
 * @Description: 客户数量分析 - sdk
 * @author shicy
 * @date 2020-04-21 11:22:15
 */
public class CrmQuantity {

	/**
	 * 客户数量数字图
	 * @Title: digitalMap
	 * @param dto
	 * @return
	 * @throws IOException
	 * @author shicy
	 * @date 2020-04-21 11:57:22
	 */
	public static DigitalMapResp digitalMap(DigitalMapDto<CrmQuantityParam> dto) throws IOException {
		// 1. 构建 接口Url
		String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.CRMQUANTITY_DIGITALMAP);
		// 2. 构建请求参数
		String paramsJson = JSONObject.toJSONString(dto);
		String str = HttpUtils.post(paramsJson, postUrl);
		DigitalMapResp data = JSONObject.parseObject(str, DigitalMapResp.class);
		return data;
	}

	/**
	 * 客户数量折线图
	 * @Title: lineGraph
	 * @param dto
	 * @return
	 * @throws IOException
	 * @author shicy
	 * @date 2020-04-21 11:58:36
	 */
	public static LineGraphResp lineGraph(LineGraphDto<CrmQuantityParam> dto) throws IOException {
		// 1.构建 接口Url
		String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.CRMQUANTITY_LINEGRAPH);
		// 2. 构建请求参数
		String paramsJson = JSONObject.toJSONString(dto);
		String str = HttpUtils.post(paramsJson, postUrl);
		LineGraphResp data = JSONObject.parseObject(str, LineGraphResp.class);
		return data;
	}

}

