package com.ec.v2.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.trajectory.*;
import com.ec.v2.utlis.HttpUtils;

import java.io.IOException;
import java.util.List;

public class Trajectory {

    /**
     * 0.0.5 新增
     * 批量添加跟进记录
     */
    public static TrajectoryResp<List<AddFollowRecordDto>> saveUserTrajectory(FollowRecordRequest followRecordRequest) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.TRAJECTORY.SAVE_USER_TRAJECTORY);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(followRecordRequest);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<TrajectoryResp<List<AddFollowRecordDto>>>() {});
    }

    /**
     * 0.0.5 新增
     * 导出跟进记录
     * @param followRecordRequest
     * @return
     * @throws IOException
     */
    public static TrajectoryResp<Page<SelectFollowRecordResponse>> findUserTrajectory(SelectFollowRecordRequest followRecordRequest) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.TRAJECTORY.FIND_USER_TRAJECTORY);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(followRecordRequest);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<TrajectoryResp<Page<SelectFollowRecordResponse>>>() {});
    }

    /**
     * 0.0.5 新增
     * 	导出历史跟进记录
     * @param request
     * @return
     * @throws IOException
     */
    public static TrajectoryResp<Page<SelectFollowRecordResponse>> findHistoryUserTrajectory(SelectHisFollowRecordRequest request) throws IOException {
        String postUrl = HttpUtils.buildUrl(UrlConstants.TRAJECTORY.FIND_HISTORY_USER_TRAJECTORY);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(request);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<TrajectoryResp<Page<SelectFollowRecordResponse>>>() {});
    }
}
