package com.ec.v2.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.sales.*;
import com.ec.v2.utlis.HttpUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Sales {

    /**
     * 获取订单自定义字段
     * @return
     * @throws IOException
     */
    public static SalesResponse<List<SalesFieldDTO>> getSalesFieldMapping() throws IOException {
        String url = HttpUtils.buildUrl(UrlConstants.SALES.GET_SALES_FIELD_MAPPING);
        String str = HttpUtils.get(url);
        return JSON.parseObject(str, new TypeReference<SalesResponse<List<SalesFieldDTO>>>() {});
    }

    /**
     * 添加订单
     * @param map
     * @return
     * @throws IOException
     */
    public static SalesResponse<Long> addSales(Map<String, Object> map) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.SALES.ADD_SALES);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(map);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<SalesResponse<Long>>() {});
    }

    /**
     * 更新订单
     * @param map
     * @return
     * @throws IOException
     */
    public static SalesResponse<Long> updateSales(Map<String, Object> map) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.SALES.UPDATE_SALES);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(map);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<SalesResponse<Long>>() {});
    }

    /**
     * 更新订单状态
     * @param map
     * @return
     * @throws IOException
     */
    public static SalesResponse<Long> updateStatus(Map<String, Object> map) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.SALES.UPDATE_STATUS);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(map);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<SalesResponse<Long>>() {});
    }

    /**
     * 获取订单列表
     * @param getSalesVO
     * @return
     * @throws IOException
     */
    public static SalesResponse<SalesMoneyArrayDTO> getSales(GetSalesVO getSalesVO) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.SALES.GET_SALES);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(getSalesVO);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, new TypeReference<SalesResponse<SalesMoneyArrayDTO>>() {});
    }

    /**
     * 获取订单详情
     * @param saleId 订单ID
     * @return
     * @throws IOException
     */
    public static SalesResponse<SaleDetailResponse> getSalesDetail(Long saleId) throws IOException {
        String url = HttpUtils.buildUrl(UrlConstants.SALES.GET_SALES_DETAIL);
        Map<String,Object> params = new HashMap<>();
        params.put("saleId",saleId);
        String str = HttpUtils.get(url,params);
        return JSON.parseObject(str, new TypeReference<SalesResponse<SaleDetailResponse>>() {});
    }

}
