package com.ec.v2.service;

import java.io.IOException;

import org.apache.http.client.ClientProtocolException;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.customer.file.CrmFileUploadResp;
import com.ec.v2.entity.customer.file.CrmFileUploadVo;
import com.ec.v2.utlis.HttpUtils;

/**
 * 
 * @Title: CustomerFile.java
 * @Description:  文件上传相关接口
 * <p>1. 客户资料-文件上传 : /v2/customer/file/uploade </p>
 * @author shicy
 * @date 2020-06-04 16:00:00
 */
public class CustomerFile {

	
	
	 /**
	  * 
	  * @Title: uploade
	  * @Description: 客户资料-文件上传
	  * <p>客户资料-文件上传</p>
	 
	  * @param dto
	  * @return
	  * @throws ClientProtocolException
	  * @throws IOException
	  * @author shicy
	  * @date 2020-03-24 10:40:36
	  */
	 public static CrmFileUploadResp upload(CrmFileUploadVo dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMERFILE.UPLOAD);
        // 2. 构建请求参数
        String str =  HttpUtils.crmFileUpload(dto,postUrl);
        CrmFileUploadResp data = JSONObject.parseObject(str, CrmFileUploadResp.class);
        return data;
    }
	 
	 
	 
	 
	
}
