package com.ec.v2.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.MsgResponse;
import com.ec.v2.entity.contactbook.ContactBookRequest;
import com.ec.v2.entity.contactbook.ContactBookResp;
import com.ec.v2.entity.trajectory.LongMsgResponse;
import com.ec.v2.utlis.HttpUtils;

import java.io.IOException;

/**
 * 企业联系人相关操作sdk
 */
public class ContactBook {
    /**
     * 根据crmid， 获取企业联系人列表
     */
    public static ContactBookResp list(ContactBookRequest dto) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CONTACT_BOOK.LIST);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        //return JSONObject.parseObject(str, GeneralDataResp.class);
        return JSON.parseObject(str, new TypeReference<ContactBookResp>() {});
    }

    /**
     * 新增1个企业联系人
     */
    public static LongMsgResponse add(ContactBookRequest dto) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CONTACT_BOOK.ADD);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, LongMsgResponse.class);
    }


    /**
     * 新增1个企业联系人
     */
    public static MsgResponse update(ContactBookRequest dto) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CONTACT_BOOK.UPDATE);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, MsgResponse.class);
    }


    /**
     * 新增1个企业联系人
     */
    public static MsgResponse delete(ContactBookRequest dto) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CONTACT_BOOK.DELETE);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, MsgResponse.class);
    }
}
