package com.ec.v2.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.MsgResponse;
import com.ec.v2.entity.apipush.ApiPushResp;
import com.ec.v2.entity.apipush.ApiPushVo;
import com.ec.v2.entity.contactbook.ContactBookRequest;
import com.ec.v2.entity.contactbook.ContactBookResp;
import com.ec.v2.entity.trajectory.LongMsgResponse;
import com.ec.v2.utlis.HttpUtils;

import java.io.IOException;

/**
 * api 主动推送
 */
public class ApiPush {

    /**
     * 查询主动推送的内容
     *
     * @param dto
     * @return
     * @throws IOException
     */
    public static ApiPushResp list(ApiPushVo dto) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.API_PUSH.list);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, ApiPushResp.class);
    }

}
