package com.ec.v2.entity.trajectory;

import com.alibaba.fastjson.JSONObject;

/**
 * 查询跟进记录
 */
public class SelectHisFollowRecordRequest {
    /**
     * 部门ID 用分号(;)隔开
     */
    private String deptIds;
    /**
     * 操作员工ID，可输入多个值，用分号(;)隔开
     */
    private String userIds;
    /**
     * 客户的ID，可输入多个值，用分号(;)隔开
     */
    private String crmIds;
    /**
     * 统计时间年
     */
    private String year;
    /**
     * 统计时间月
     */
    private String month;
    /**
     * 统计时间开始日
     */
    private String startDayOfMonth = "1";

    /**
     * 统统计时间结束日
     */
    private String endDayOfMonth = "31";

    /**
     * 分页请求时当前请求第几页的数据，从1开始
     */
    private Integer pageNo = 1;

    public String getDeptIds() {
        return deptIds;
    }

    public void setDeptIds(String deptIds) {
        this.deptIds = deptIds;
    }

    public String getUserIds() {
        return userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public String getCrmIds() {
        return crmIds;
    }

    public void setCrmIds(String crmIds) {
        this.crmIds = crmIds;
    }

    public Integer getYear() {
        return Integer.valueOf(year);
    }

    public void setYear(String year) {
        this.year = year;
    }

    public Integer getMonth() {
        return Integer.valueOf(month);
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public Integer getStartDayOfMonth() {
        return Integer.valueOf(startDayOfMonth);
    }

    public void setStartDayOfMonth(String startDayOfMonth) {
        this.startDayOfMonth = startDayOfMonth;
    }

    public Integer getEndDayOfMonth() {
        return Integer.valueOf(endDayOfMonth);
    }

    public void setEndDayOfMonth(String endDayOfMonth) {
        this.endDayOfMonth = endDayOfMonth;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    @Override
    public String toString() {
        return "[crmIds=" + crmIds + ", deptIds=" + deptIds + ", userIds=" + userIds +", year=" + year +", month=" + month +", startDayOfMonth=" + startDayOfMonth + ", endDayOfMonth=" + endDayOfMonth + "]";
    }

    public JSONObject notPageString() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deptIds",deptIds);
        jsonObject.put("crmIds",crmIds);
        jsonObject.put("startDayOfMonth",startDayOfMonth);
        jsonObject.put("endDayOfMonth",endDayOfMonth);
        jsonObject.put("year",year);
        jsonObject.put("month",month);
        jsonObject.put("userIds",userIds);
        return jsonObject;
    }
}
