package com.ec.v2.entity.sales;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SaleFieldItemDTO implements Serializable {


    private static final long serialVersionUID = 3693812717815829843L;
    /**
     * 字段ID
      */
    private Long id;
    /**
     *  字段名称
     */
    private String name;

    /**
     * 系统字段类型，0其他, 1主题, 2客户, 3状态, 4总金额, 5产品信息, 6备注，7产品，8预计成交时间
     */
    private Integer stype;

    /**
     * 类型ID 1文本, 6时间, 7货币, 8下拉, 9单选, 10复选, 11状态
     */
    private Integer type;
    /**
     * 字段属性
     */
    private List<FieldParamDTO> params;
    /**
     * 是否必填 1是必填 0不是必填
     */
    private Integer isnotnull;

    /**
     * 是否禁止 0启用/1禁用
     */
    private Integer status;
}
