package com.ec.v2.constact;

public class UrlConstants {
	/**
	 *
	 * @Title: UrlConstants.java
	 * @Description: 标签相关接口
	 * @author shicy
	 * @date 2020-03-24 11:05:52
	 */
	public interface LABEL {
		String UPDATE = "/v2/label/update";
		String GET_LABEL_INFO = "/v2/label/getLabelInfo";
		String ADD_LABEL = "/v2/label/addLabel";
		String ADD_LABEL_GROUP = "/v2/label/addLabelGroup";
	}
	public interface TRAJECTORY{
		/**
		 * 批量添加跟进记录
		 */
		String SAVE_USER_TRAJECTORY = "/v2/trajectory/saveUserTrajectory";
		/**
		 * 导出跟进记录
		 */
		String FIND_USER_TRAJECTORY = "/v2/trajectory/findUserTrajectory";
		/**
		 * 导出历史跟进记录
		 */
		String FIND_HISTORY_USER_TRAJECTORY = "/v2/trajectory/findHistoryUserTrajectory";
	}

	/**
	 *
	 * @Title: UrlConstants.java
	 * @Description: 客户相关接口
	 * @author shicy
	 * @date 2020-03-24 11:11:34
	 */
	public interface CUSTOMER {

		/**
		 * 查询客户标签
		 */
		String POST_QUERYLABEL = "/v2/customer/queryLabel";

		/**
		 * 新增客户
		 */
		String POST_ADDCUSTOMER = "/v2/customer/addCustomer";

		/**
		 * 合并客户复
		 */
		String POST_COMBINE = "/v2/customer/combine";

		/**
		 * 客户分组
		 */
		String GET_CUSTOMERGROUP = "/v2/customer/getCustomerGroup";

		/**
		 * 分页查询客户轨迹
		 */
		String GET_TRAJECTORY = "/v2/customer/getTrajectory";

		/**
		 * 批量查询客户信息
		 */
		String POST_PRECISEQUERY = "/v2/customer/preciseQuery";

		/**
		 * 分页查询客户信息
		 */
		String POST_QUERY = "/v2/customer/query";

		/**
		 * 分页查询客户信息
		 */
		String POST_HIGH_QUERY = "/v2/customer/highQuery";

		/**
		 * 修改客户
		 */
		String POST_UPDATECUSTOMER = "/v2/customer/updateCustomer";

		/**
		 * 批量修改客户
		 */
		String POST_BATCH_UPDATECUSTOMER = "/v2/customer/batchUpdateCustomer";

		/**
		 * 修改客户阶段
		 */
		String POST_UPDATECUSTOMER_STEP = "/v2/step/update";

		/**
		 * 获取员工拜访记录
		 */
		String GET_CRM_VISIT_DETAILS = "/v2/customer/getCrmVisitDetails";
		/**
		 * 获取删除的客户
		 */
		String DEL_CRMS = "/v2/customer/delcrms";
		/**
		 * 获取级联字段
		 */
		String GET_CASCADE_FIELDMAPPING = "/v2/customer/getCasCadeFieldMapping";
		/**
		 * 获取来源信息
		 */
		String GET_CHANNEL_SOURCE = "/v2/customer/getChannelSource";
		/**
		 * 共享客户
		 */
		String SHARE = "/v2/customer/share";
	}

	/**
	 *
	 * @Title: UrlConstants.java
	 * @Description: 客户更变相关接口
	 * @author shicy
	 * @date 2020-03-24 11:05:34
	 */
	public interface CUSTOMERCHANGE {
		/**
		 * 放弃客户
		 */
		String ABANDON = "/v2/customer/change/abandon";
		/**
		 * 修改跟进人
		 */
		String USER = "/v2/customer/change/user";

	}

	/**
	 *
	 * @Title: UrlConstants.java
	 * @Description: 文件上传
	 * @author shicy
	 * @date 2020-03-24 11:05:34
	 */
	public interface CUSTOMERFILE {
		/**
		 * 客户资料 文件上传
		 */
		String UPLOAD = "/v2/customer/file/upload";

	}



	public interface RECORD {

		/**
		 * 电话外呼
		 */
		String TELL_CALL = "/v2/record/call";
		/**
		 * 电话空闲用户
		 */
		String GET_FREE_STATUS_UID = "/v2/record/getFreeStatusUid";
		/**
		 * 短信记录
		 */
		String SMS_RECORD = "/v2/record/smsRecord";
		/**
		 * 电话记录
		 */
		String TEL_RECORD = "/v2/record/telRecord";

		/**
		 * 导出历史电话记录
		 */
		String TEL_RECORD_HISTORY = "/v2/record/telRecordHistory";

		/**
		 * 导出历史短信记录
		 */
		String SEND_SMS_HISTORY = "/v2/record/sendSmsHistory";

		/**
		 * 添加电话记录
		 */
		String ADD_TEL_RECORD = "/v2/record/addTelRecord";
	}

	public interface CONFIG {

		/**
		 * 获取自定字段
		 */
		String GET_FIELD_MAPPING = "/v2/config/getFieldMapping";
		/**
		 * 标签信息
		 */
		String GET_LABEL_INFO = "/v2/config/getLabelInfo";
		/**
		 * 业务组信息
		 */
		String GET_PUBLIC_POND = "/v2/config/getPubicPond";

		/**
		 * 客户进展
		 */
		String GET_STAGES = "/v2/config/getStages";
	}

	public interface ORGANIZATION {

		/**
		 * 创建部门
		 */
		String CREATE = "/v2/org/dept/create";
		/**
		 * 编辑部门
		 */
		String EDIT = "/v2/org/dept/edit";
		/**
		 * 组织架构信息
		 */
		String INFO = "/v2/org/struct/info";
		/**
		 * 创建用户
		 */
		String CREATE_USER = "/v2/org/user/create";
		/**
		 * 启用或者禁用用户
		 */
		String ON_OFF_USER = "/v2/org/user/onoff";

		/**
		 * 更新员工
		 */
		String UPDATE_USER = "/v2/org/user/updateUser";

		/**
		 * 查看员工信息
		 */
		String FIND_USER_INFO_BY_ID = "/v2/org/user/findUserInfoById";
	}

	public interface ROBOT {

		String ADD_TASK = "/v2/robot/addtask";
		String ADD_TASK_RECORD = "/v2/robot/addtaskrecord";
		String UPDATE_TASK = "/v2/robot/updatetask";
	}

	public interface ASYNCHRONIZATION {
		String CREATE = "/v2/asynchronization/create";
		String QUERY = "/v2/asynchronization/query";
	}

	public interface STATISTICS {
		/**
		 * 工作效率 - 数字图
		 */
		String WORKEFFIC_DIGITALMAP = "/v2/statistics/digitalMap/workeffic";
		/**
		 * 工作效率 - 柱状图
		 */
		String WORKEFFIC_HISTOGRAM = "/v2/statistics/histogram/workeffic";

		/**
		 * 电话分析 - 数字图
		 */
		String PHONE_DIGITALMAP = "/v2/statistics/digitalMap/phone";
		/**
		 * 电话分析 - 折线图
		 */
		String PHONE_LINEGRAPH = "/v2/statistics/lineGraph/phone";

		/**
		 * 客户分析 - 数字图
		 */
		String CRMQUANTITY_DIGITALMAP = "/v2/statistics/digitalMap/crmQuantity";
		/**
		 * 客户分析 - 折线图
		 */
		String CRMQUANTITY_LINEGRAPH = "/v2/statistics/lineGraph/crmQuantity";

		/**
		 * 标签分析 - 数字图
		 */
		String TAG_DIGITALMAP = "/v2/statistics/digitalMap/tag";
		/**
		 * 标签分析 - 柱状图
		 */
		String TAG_HISTOGRAM = "/v2/statistics/histogram/tag";

	}

	public interface SALES{
		/**
		 * 获取销售金额字段信息
		 */
		String GET_SALES_FIELD_MAPPING = "/v2/sales/getSalesFieldMapping";
		/**
		 * 创建销售金额
		 */
		String ADD_SALES = "/v2/sales/addSales";
		/**
		 * 修改销售金额
		 */
		String UPDATE_SALES = "/v2/sales/updateSales";
		/**
		 * 更新销售金额状态
		 */
		String UPDATE_STATUS = "/v2/sales/updateStatus";
		/**
		 * 查询销售金额列表
		 */
		String GET_SALES = "/v2/sales/getSales";
		/**
		 * 查询销售金额详情
		 */
		String GET_SALES_DETAIL = "/v2/sales/getSalesDetail";
	}



	public interface CONTACT_BOOK {

		/**
		 * 根据crmid， 获取企业联系人列表
		 */
		String LIST = "/v2/contactbook/list";
		/**
		 * 新增1个企业联系人
		 */
		String ADD = "/v2/contactbook/add";
		/**
		 * 删除1个企业联系人
		 */
		String DELETE = "/v2/contactbook/delete";

		/**
		 * 修改一个企业联系人
		 */
		String UPDATE = "/v2/contactbook/update";

	}

	public interface API_PUSH {
		/**
		 * 查询主动推送的内容
		 */
		String list = "/v2/apipush/getApiPush";

	}


}
