/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.File;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.EncryptedDirectory;
import org.elasticsearch.index.store.EncryptedIndexStore;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.NodeKeyProviderComponent;
import org.elasticsearch.index.store.fs.FsDirectoryService;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0017\tIRI\\2ssB$X\r\u001a#je\u0016\u001cGo\u001c:z'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0003ti>\u0014XM\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=\u0011\u0011A\u00014t\u0013\t\tbB\u0001\nGg\u0012K'/Z2u_JL8+\u001a:wS\u000e,\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u000fMD\u0017M\u001d3JIB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\u0006g\"\f'\u000fZ\u0005\u00033Y\u0011qa\u00155be\u0012LE\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u00035Ig\u000eZ3y'\u0016$H/\u001b8hgB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\tg\u0016$H/\u001b8hg*\u0011\u0011EB\u0001\u0007G>lWn\u001c8\n\u0005\rr\"\u0001C*fiRLgnZ:)\u0005i)\u0003C\u0001\u0014)\u001b\u00059#BA\u0010\u0005\u0013\tIsEA\u0007J]\u0012,\u0007pU3ui&twm\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005Q\u0011N\u001c3fqN#xN]3\u0011\u00055rS\"\u0001\u0002\n\u0005=\u0012!aE#oGJL\b\u000f^3e\u0013:$W\r_*u_J,\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\r\rd\u0017.\u001a8u!\t\u0019T'D\u00015\u0015\t\td!\u0003\u00027i\t11\t\\5f]RD\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\nG>l\u0007o\u001c8f]R\u0004\"!\f\u001e\n\u0005m\u0012!\u0001\u0007(pI\u0016\\U-\u001f)s_ZLG-\u001a:D_6\u0004xN\\3oi\")Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"ba\u0010!B\u0007\u0012+\u0005CA\u0017\u0001\u0011\u0015\u0019B\b1\u0001\u0015\u0011\u0015YB\b1\u0001\u001dQ\t\tU\u0005C\u0003,y\u0001\u0007A\u0006C\u00032y\u0001\u0007!\u0007C\u00039y\u0001\u0007\u0011\b\u000b\u0002=\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nI\u0001\u0007S:TWm\u0019;\n\u00051K%AB%oU\u0016\u001cG\u000fC\u0003O\u0001\u0011\u0005s*\u0001\boK^45\u000bR5sK\u000e$xN]=\u0015\u0007AK6\r\u0005\u0002R/6\t!K\u0003\u0002\u0004'*\u0011A+V\u0001\u0007YV\u001cWM\\3\u000b\u0005YC\u0011AB1qC\u000eDW-\u0003\u0002Y%\nIA)\u001b:fGR|'/\u001f\u0005\u000656\u0003\raW\u0001\tY>\u001c\u0017\r^5p]B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0003S>T\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u0002c;\n!a)\u001b7f\u0011\u0015!W\n1\u0001f\u0003-awnY6GC\u000e$xN]=\u0011\u0005E3\u0017BA4S\u0005-aunY6GC\u000e$xN]=")
public class EncryptedDirectoryService
extends FsDirectoryService {
    private final ShardId shardId;
    private final Client client;
    private final NodeKeyProviderComponent component;

    public Directory newFSDirectory(File location, LockFactory lockFactory) {
        return new EncryptedDirectory(location, lockFactory, this.shardId, this.client, this.component);
    }

    @Inject
    public EncryptedDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings, EncryptedIndexStore indexStore, Client client, NodeKeyProviderComponent component) {
        this.shardId = shardId;
        this.client = client;
        this.component = component;
        super(shardId, indexSettings, (IndexStore)indexStore);
    }
}

