/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2Q!\u0001\u0002\u0001\u0005)\u00111c\u00115v].,GmT;uaV$8\u000b\u001e:fC6T!a\u0001\u0003\u0002\u000bM$xN]3\u000b\u0005\u00151\u0011!B5oI\u0016D(BA\u0004\t\u00035)G.Y:uS\u000e\u001cX-\u0019:dQ*\t\u0011\"A\u0002pe\u001e\u001c\"\u0001A\u0006\u0011\u00051\tR\"A\u0007\u000b\u00059y\u0011AA5p\u0015\u0005\u0001\u0012\u0001\u00026bm\u0006L!AE\u0007\u0003%\u0019KG\u000e^3s\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\t)\u0001\u0011\t\u0011)A\u0005-\u0005\u0011qn]\u0002\u0001!\taq#\u0003\u0002\u0019\u001b\taq*\u001e;qkR\u001cFO]3b[\"A!\u0004\u0001B\u0001B\u0003%1$A\u0005dQVt7nU5{KB\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t\u0019\u0011J\u001c;\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\r!ce\n\t\u0003K\u0001i\u0011A\u0001\u0005\u0006)\u0005\u0002\rA\u0006\u0005\u00065\u0005\u0002\ra\u0007\u0005\u0006S\u0001!\tEK\u0001\u0006oJLG/\u001a\u000b\u0005W92\u0004\b\u0005\u0002\u001dY%\u0011Q&\b\u0002\u0005+:LG\u000fC\u00030Q\u0001\u0007\u0001'A\u0001c!\ra\u0012gM\u0005\u0003eu\u0011Q!\u0011:sCf\u0004\"\u0001\b\u001b\n\u0005Uj\"\u0001\u0002\"zi\u0016DQa\u000e\u0015A\u0002m\taa\u001c4gg\u0016$\b\"B\u001d)\u0001\u0004Y\u0012A\u00027f]\u001e$\b\u000e")
public class ChunkedOutputStream
extends FilterOutputStream {
    private final int chunkSize;

    @Override
    public void write(byte[] b, int offset, int length) {
        int l = length;
        int o = offset;
        while (l > 0) {
            int chunk = Math.min(l, this.chunkSize);
            this.out.write(b, o, chunk);
            l -= chunk;
            o += chunk;
        }
    }

    public ChunkedOutputStream(OutputStream os, int chunkSize) {
        this.chunkSize = chunkSize;
        super(os);
    }
}

