/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.security.InvalidKeyException;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.lucene.util.CryptoException;
import org.apache.lucene.util.CryptoException$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HmacUtil$ {
    public static final HmacUtil$ MODULE$;
    private final String HMAC_ERROR_PREFIX;
    private final String DATA_CIPHER_ALGORITHM;
    private final int DATA_KEY_SIZE;
    private final String HMAC_SHA256_ALGORITHM;

    static {
        new HmacUtil$();
    }

    public String DATA_CIPHER_ALGORITHM() {
        return this.DATA_CIPHER_ALGORITHM;
    }

    public int DATA_KEY_SIZE() {
        return this.DATA_KEY_SIZE;
    }

    public String HMAC_SHA256_ALGORITHM() {
        return this.HMAC_SHA256_ALGORITHM;
    }

    public byte[] hmacValue(byte[] plaintext, SecretKey key) {
        try {
            if (Option$.MODULE$.apply((Object)plaintext).isEmpty() || plaintext.length == 0) {
                throw this.error("No plaintext was provided", this.error$default$2());
            }
            if (Option$.MODULE$.apply((Object)key).isEmpty()) {
                throw this.error("Null key", this.error$default$2());
            }
            if (key.getAlgorithm().equalsIgnoreCase(this.DATA_CIPHER_ALGORITHM())) {
                int keySize = key.getEncoded().length * 8;
                if (keySize < this.DATA_KEY_SIZE()) {
                    throw this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key is too small. Expected at least ", " bits but found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.DATA_KEY_SIZE()), BoxesRunTime.boxToInteger((int)keySize)})), this.error$default$2());
                }
                Mac hmac = Mac.getInstance(this.HMAC_SHA256_ALGORITHM());
                hmac.init(key);
                return hmac.doFinal(plaintext);
            }
            throw this.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected key of type ", ", but found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DATA_CIPHER_ALGORITHM(), key.getAlgorithm()})), this.error$default$2());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw this.error("InvalidKeyException", (Option<Throwable>)new Some((Object)invalidKeyException));
        }
    }

    private Nothing$ error(String msg, Option<Throwable> ex) {
        Option<Throwable> option = ex;
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable e = (Throwable)some.x();
            throw new CryptoException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HMAC_ERROR_PREFIX, msg})), e);
        }
        None$ none$ = None$.MODULE$;
        Option<Throwable> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new CryptoException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HMAC_ERROR_PREFIX, msg})), CryptoException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(option);
    }

    private Option<Throwable> error$default$2() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] generateRandomBytes(int numBytes) {
        void var2_2;
        byte[] randomBytes = new byte[numBytes];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        return var2_2;
    }

    private HmacUtil$() {
        MODULE$ = this;
        this.HMAC_ERROR_PREFIX = "HMAC Error - ";
        this.DATA_CIPHER_ALGORITHM = "AES";
        this.DATA_KEY_SIZE = 256;
        this.HMAC_SHA256_ALGORITHM = "HmacSHA256";
    }
}

