/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.workday.elasticrypt.KeyProvider;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.lucene.util.FileHeader;

public class AESReader {
    private static final int BLOCKSIZE = 16;
    private RandomAccessFile raf;
    private final Cipher dcipher;
    private final byte[] cur_iv;
    private long header_offset = 0L;
    private FileHeader fileHeader;
    private final byte[] buffer;
    private long filePos;
    private long bufferStart;
    private int bufferLength;
    private int bufferPosition;
    private long end;
    private final int page_size;
    private final SecretKeySpec key;
    private final Object lock = new Object();
    private final String name;
    private String indexName;

    public AESReader(String string, RandomAccessFile randomAccessFile, int n, KeyProvider keyProvider, String string2, FileHeader fileHeader) throws IOException, NoSuchAlgorithmException, InvalidKeyException, ShortBufferException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        try {
            this.name = string;
            this.raf = randomAccessFile;
            this.indexName = string2;
            this.fileHeader = fileHeader;
            this.readFileHeader();
            this.key = keyProvider.getKey(string2);
            long l = n * 16;
            this.dcipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.buffer = new byte[n * 16];
            this.cur_iv = new byte[16];
            this.page_size = n;
            this.raf.seek(Math.max(this.raf.length() - l, this.header_offset));
            this.raf.readFully(this.cur_iv);
            int n2 = this.raf.read(this.buffer);
            this.dcipher.init(2, (Key)this.key, new IvParameterSpec(this.cur_iv));
            int n3 = this.dcipher.doFinal(this.buffer, 0, n2, this.buffer, 0);
            if (n3 != n2) {
                throw new IOException("Not enough bytes decrypted");
            }
            byte by = this.buffer[n3 - 1];
            int n4 = 16 - by;
            if (n4 < 0 || n4 > 16) {
                throw new IOException("Bad padding: " + by);
            }
            for (int i = n3 - 16 + n4; i < n3; ++i) {
                if (by == this.buffer[i]) continue;
                throw new IOException("Bad padding @ byte " + (n3 - i) + ". Expected: " + by + ". Value: " + this.buffer[i]);
            }
            long l2 = (this.raf.length() - this.header_offset) / 16L - 1L;
            long l3 = l2 / (long)(n + 1) + 1L;
            this.end = this.raf.length() - (long)by - l3 * 16L - this.header_offset;
            this.seek(0L);
        }
        catch (Exception exception) {
            this.raf.close();
            throw exception;
        }
    }

    private void readFileHeader() throws IOException {
        this.fileHeader.readHeader();
        this.header_offset = this.raf.getFilePointer();
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getFilePointer() throws IOException {
        return this.filePos;
    }

    public void setLength(long l) {
        this.end = l;
    }

    public long length() {
        return this.end;
    }

    public int read() throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        return this.read(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        int n = byteBuffer.remaining();
        if (this.filePos >= this.end) {
            return -1;
        }
        if (n <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            int n2 = n;
            if (this.bufferPosition >= this.bufferLength) {
                this.refill();
            }
            if (n <= this.bufferLength - this.bufferPosition) {
                byteBuffer.put(this.buffer, this.bufferPosition, n);
                this.bufferPosition += n;
                this.filePos += (long)n;
                n2 = 0;
            } else {
                while (n2 > 0 && this.filePos < this.end) {
                    int n3 = this.bufferLength - this.bufferPosition;
                    if (n3 > 0) {
                        int n4 = Math.min(n3, n2);
                        byteBuffer.put(this.buffer, this.bufferPosition, n4);
                        n2 -= n4;
                        this.bufferPosition += n4;
                        this.filePos += (long)n4;
                        continue;
                    }
                    this.refill();
                }
            }
            return n - n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long l) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (l >= this.end || l < 0L) {
            throw new RuntimeException("Pos: " + l + " end: " + this.end + " file: " + this.name);
        }
        Object object = this.lock;
        synchronized (object) {
            this.filePos = l;
            this.refill();
        }
    }

    private void refill() throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        long l = this.encryptedAddrToPhysicalAddr(this.filePos);
        this.bufferStart = l / ((long)this.page_size * 16L + 16L);
        this.bufferStart *= (long)this.page_size * 16L + 16L;
        this.raf.seek(this.bufferStart + this.header_offset);
        this.bufferStart += 16L;
        this.raf.readFully(this.cur_iv);
        this.dcipher.init(2, (Key)this.key, new IvParameterSpec(this.cur_iv));
        int n = this.raf.read(this.buffer);
        int n2 = this.dcipher.doFinal(this.buffer, 0, n, this.buffer, 0);
        if (n2 != n) {
            throw new IOException("Not enough bytes decrypted");
        }
        this.bufferLength = n2;
        this.bufferPosition = (int)(this.filePos % (long)this.buffer.length);
    }

    private long numPageIVBlocksAt(long l) {
        return l / (long)this.page_size + 1L;
    }

    private long encryptedAddrToPhysicalAddr(long l) {
        long l2 = l / 16L;
        return (l2 + this.numPageIVBlocksAt(l2)) * 16L + l % 16L;
    }
}

