/*
 * Decompiled with CFR 0.152.
 */
package com.workday.elasticrypt.translog;

import com.workday.elasticrypt.KeyProvider;
import com.workday.elasticrypt.translog.EncryptedFileChannel;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.translog.EncryptedTranslogStream;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.fs.RafReference;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001-\u0011Q#\u00128def\u0004H/\u001a3SC\u001a\u0014VMZ3sK:\u001cWM\u0003\u0002\u0004\t\u0005AAO]1og2|wM\u0003\u0002\u0006\r\u0005YQ\r\\1ti&\u001c'/\u001f9u\u0015\t9\u0001\"A\u0004x_J\\G-Y=\u000b\u0003%\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u000559R\"\u0001\b\u000b\u0005=\u0001\u0012A\u00014t\u0015\t\u0019\u0011C\u0003\u0002\u0013'\u0005)\u0011N\u001c3fq*\u0011A#F\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003Y\t1a\u001c:h\u0013\tAbB\u0001\u0007SC\u001a\u0014VMZ3sK:\u001cW\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u00111\u0017\u000e\\3\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012AA5p\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\t\u0019KG.\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u00051An\\4hKJ\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000f1|wmZ5oO*\u0011!fE\u0001\u0007G>lWn\u001c8\n\u00051:#\u0001C#T\u0019><w-\u001a:\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0001\u0002]1hKNK'0\u001a\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0004\u0013:$\b\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0017-,\u0017\u0010\u0015:pm&$WM\u001d\t\u0003qej\u0011\u0001B\u0005\u0003u\u0011\u00111bS3z!J|g/\u001b3fe\"AA\b\u0001B\u0001B\u0003%Q(A\u0005j]\u0012,\u0007PT1nKB\u0011a(\u0011\b\u0003a}J!\u0001Q\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001FBQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDCB$J\u0015.cU\n\u0005\u0002I\u00015\t!\u0001C\u0003\u001b\t\u0002\u00071\u0004C\u0003%\t\u0002\u0007Q\u0005C\u0003/\t\u0002\u0007q\u0006C\u00037\t\u0002\u0007q\u0007C\u0003=\t\u0002\u0007Q\b\u0003\u0004P\u0001\u0001\u0006I\u0001U\u0001\u0015K:\u001c'/\u001f9uK\u00124\u0015\u000e\\3DQ\u0006tg.\u001a7\u0011\u0005!\u000b\u0016B\u0001*\u0003\u0005Q)en\u0019:zaR,GMR5mK\u000eC\u0017M\u001c8fY\"AA\u000b\u0001b\u0001\n\u0003\u0011Q+\u0001\u0005sK\u001a\u001cu.\u001e8u+\u00051\u0006CA,_\u001b\u0005A&BA-[\u0003\u0019\tGo\\7jG*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/ \u0003\u0011)H/\u001b7\n\u0005}C&!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0004b\u0001\u0001\u0006IAV\u0001\ne\u001647i\\;oi\u0002BQa\u0019\u0001\u0005B\u0011\fqa\u00195b]:,G\u000eF\u0001f!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0005dQ\u0006tg.\u001a7t\u0015\tQw$A\u0002oS>L!\u0001\\4\u0003\u0017\u0019KG.Z\"iC:tW\r\u001c\u0005\u0006]\u0002!\te\\\u0001\u0011S:\u001c'/Z1tKJ+gmQ8v]R$\u0012\u0001\u001d\t\u0003aEL!A]\u0019\u0003\u000f\t{w\u000e\\3b]\")A\u000f\u0001C!k\u0006\u0001B-Z2sK\u0006\u001cXMU3g\u0007>,h\u000e\u001e\u000b\u0003mf\u0004\"\u0001M<\n\u0005a\f$\u0001B+oSRDQA_:A\u0002A\f!\u0002Z3mKR,g)\u001b7f\u0011\u0015a\b\u0001\"\u0001~\u0003E!(/\u00198tY><7\u000b\u001e:fC64uN]\u000b\u0002}B\u0019q0!\u0001\u000e\u0003AI1!a\u0001\u0011\u00059!&/\u00198tY><7\u000b\u001e:fC6D3a_A\u0004!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007?\u0005!A.\u00198h\u0013\u0011\t\t\"a\u0003\u0003\u0011=3XM\u001d:jI\u0016\u0004")
public class EncryptedRafReference
extends RafReference {
    private final File file;
    private final ESLogger logger;
    private final int pageSize;
    private final KeyProvider keyProvider;
    private final String indexName;
    private final EncryptedFileChannel encryptedFileChannel;
    private final AtomicInteger refCount;

    public AtomicInteger refCount() {
        return this.refCount;
    }

    public FileChannel channel() {
        return this.encryptedFileChannel;
    }

    public boolean increaseRefCount() {
        return this.refCount().incrementAndGet() > 1;
    }

    public void decreaseRefCount(boolean deleteFile) {
        int refsCount = this.refCount().decrementAndGet();
        if (refsCount <= 0) {
            try {
                this.logger.trace("closing RAF reference delete: {} length: {} file: {}", new Object[]{((Object)BoxesRunTime.boxToBoolean((boolean)deleteFile)).toString(), ((Object)BoxesRunTime.boxToLong((long)this.raf().length())).toString(), this.file.getAbsolutePath()});
                this.channel().close();
                if (deleteFile) {
                    this.file.delete();
                }
            }
            catch (IOException iOException) {
                this.logger.debug("failed to close RAF file", (Throwable)iOException, new Object[0]);
            }
        }
    }

    @Override
    public TranslogStream translogStreamFor() {
        return new EncryptedTranslogStream(this.pageSize, this.keyProvider, this.indexName);
    }

    public EncryptedRafReference(File file, ESLogger logger, int pageSize, KeyProvider keyProvider, String indexName) {
        this.file = file;
        this.logger = logger;
        this.pageSize = pageSize;
        this.keyProvider = keyProvider;
        this.indexName = indexName;
        super(file, logger);
        this.encryptedFileChannel = new EncryptedFileChannel(file.getName(), this.raf(), pageSize, keyProvider, indexName);
        this.refCount = new AtomicInteger();
        this.refCount().incrementAndGet();
    }
}

