/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swaggersocket.protocol;

import com.wordnik.swaggersocket.protocol.Header;
import com.wordnik.swaggersocket.protocol.ProtocolBase;
import com.wordnik.swaggersocket.protocol.QueryString;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Request
extends ProtocolBase {
    private Object attachment;

    public Request() {
    }

    private Request(Builder b) {
        this.headers = b.headers;
        this.queryString = b.queryString;
        this.path = b.path;
        this.uuid = b.uuid;
        this.method = b.method;
        this.dataFormat = b.dataFormat;
        this.messageBody = b.messageBody;
        this.attachment = b.attachment;
    }

    public Object attachment() {
        return this.attachment;
    }

    public Request attach(Object attachment) {
        this.attachment = attachment;
        return this;
    }

    public static final class Builder {
        private String dataFormat = "application/json";
        private List<Header> headers = Collections.emptyList();
        private List<QueryString> queryString = Collections.emptyList();
        private String path = "/";
        private String uuid = UUID.randomUUID().toString();
        private String method = "POST";
        private Object messageBody = "";
        private Object attachment;

        public Builder format(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder body(Object messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder headers(List<Header> headers) {
            this.headers = headers;
            return this;
        }

        public Builder queryString(List<QueryString> queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder attach(Object attachment) {
            this.attachment = attachment;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }
}

