/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.mongo.connection;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.wordnik.mongo.connection.DBServer;
import com.wordnik.mongo.connection.Member;
import com.wordnik.mongo.connection.Member$;
import com.wordnik.mongo.connection.PersistenceException;
import com.wordnik.mongo.connection.SchemaType$;
import java.util.logging.Logger;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class MongoDBConnectionManager$ {
    public static final MongoDBConnectionManager$ MODULE$;
    private final Logger LOGGER;
    private final HashMap<String, Member> mongos;
    private final HashMap<String, List<DBServer>> pool;
    private volatile byte bitmap$init$0;

    static {
        new MongoDBConnectionManager$();
    }

    public Logger LOGGER() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.LOGGER;
        }
        throw new UninitializedFieldError("Uninitialized field: MongoDBConnectionManager.scala: 18".toString());
    }

    public HashMap<String, Member> mongos() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.mongos;
        }
        throw new UninitializedFieldError("Uninitialized field: MongoDBConnectionManager.scala: 19".toString());
    }

    public HashMap<String, List<DBServer>> pool() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.pool;
        }
        throw new UninitializedFieldError("Uninitialized field: MongoDBConnectionManager.scala: 20".toString());
    }

    public DB getConnection(String schemaName, int schemaType) throws PersistenceException {
        this.LOGGER().finest(new StringBuilder().append((Object)"getting from, key: ").append((Object)schemaName).append((Object)", schemaType: ").append((Object)BoxesRunTime.boxToInteger((int)schemaType)).toString());
        String snl = schemaName.toLowerCase();
        if (this.pool().contains((Object)snl)) {
            Option option;
            List servers = (List)this.pool().apply((Object)snl);
            ObjectRef output = new ObjectRef((Object)None$.MODULE$);
            if (SchemaType$.MODULE$.READ_WRITE() == schemaType) {
                List list = servers;
                while (!list.isEmpty()) {
                    DBServer dBServer = (DBServer)list.head();
                    if (dBServer.replicationType() == Member$.MODULE$.RS() || dBServer.replicationType() == Member$.MODULE$.M()) {
                        Option<String> x11 = dBServer.username();
                        if (x11 instanceof Some) {
                            Some x21 = (Some)x11;
                            if (!dBServer.db().isAuthenticated()) {
                                dBServer.db().authenticate((String)x21.x(), dBServer.password().toCharArray());
                            }
                        }
                        output.elem = new Some((Object)dBServer.db());
                    }
                    list = (List)list.tail();
                }
            } else {
                List list = servers;
                while (!list.isEmpty()) {
                    DBServer dBServer = (DBServer)list.head();
                    if (dBServer.replicationType() == Member$.MODULE$.RS() || dBServer.replicationType() == Member$.MODULE$.S()) {
                        Option<String> x12 = dBServer.username();
                        if (x12 instanceof Some) {
                            Some x22 = (Some)x12;
                            if (!dBServer.db().isAuthenticated()) {
                                dBServer.db().authenticate((String)x22.x(), dBServer.password().toCharArray());
                            }
                        } else {
                            dBServer.db().setReadPreference(ReadPreference.secondaryPreferred());
                        }
                        output.elem = new Some((Object)dBServer.db());
                    }
                    list = (List)list.tail();
                }
                Option option2 = (Option)output.elem;
                None$ none$ = None$.MODULE$;
                if (!(option2 != null ? !option2.equals(none$) : none$ != null)) {
                    output.elem = new Some((Object)((DBServer)servers.apply(0)).db());
                }
            }
            if ((option = (Option)output.elem) instanceof Some) {
                Some some = (Some)option;
                return (DB)some.x();
            }
            throw new PersistenceException(new StringBuilder().append((Object)"no configurations found for ").append((Object)schemaName).toString());
        }
        throw new PersistenceException(new StringBuilder().append((Object)"no configurations found for ").append((Object)schemaName).toString());
    }

    public Option<DBCollection> getOplog(String friendlyName, String host, String username, String password) {
        this.getConnection(friendlyName, host, "local", username, password, SchemaType$.MODULE$.READ_WRITE());
        Option servers = this.pool().get((Object)friendlyName);
        ObjectRef coll = new ObjectRef((Object)None$.MODULE$);
        List list = (List)servers.get();
        while (!list.isEmpty()) {
            DBServer dBServer = (DBServer)list.head();
            if (dBServer.replicationType() == Member$.MODULE$.RS()) {
                coll.elem = new Some((Object)dBServer.db().getCollection("oplog.rs"));
            } else if (dBServer.replicationType() == Member$.MODULE$.M()) {
                coll.elem = new Some((Object)dBServer.db().getCollection("oplog.$main"));
            }
            list = (List)list.tail();
        }
        return (Option)coll.elem;
    }

    public DB getConnection(String schemaName, String h, String schema, String u, String pw, int schemaType) throws PersistenceException {
        DB dB;
        if (h.indexOf(":") > 0) {
            String string = h.split(":")[1];
            Predef$ predef$ = Predef$.MODULE$;
            dB = this.getConnection(schemaName, h.split(":")[0], new StringOps(string).toInt(), schema, u, pw, schemaType);
        } else {
            dB = this.getConnection(schemaName, h, 27017, schema, u, pw, schemaType);
        }
        return dB;
    }

    /*
     * Unable to fully structure code
     */
    public DB getConnection(String friendlyName, String h, int p, String schema, String u, String pw, int schemaType) throws PersistenceException {
        host = h;
        port = p;
        if (u == null) ** GOTO lbl-1000
        v0 = u.trim();
        if (!(v0 != null ? v0.equals("") == false : "" != null)) lbl-1000:
        // 2 sources

        {
            v1 = None$.MODULE$;
        } else {
            v1 = new Some((Object)u);
        }
        username = v1;
        password = pw == null ? "" : pw;
        try {
            if (h == null) {
                host = "localhost";
            }
            if (p <= 0) {
                port = 27017;
            }
            this.LOGGER().finest(new StringBuilder().append((Object)"getting connection to ").append((Object)host).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"/").append((Object)schema).append((Object)" with username: ").append((Object)username).append((Object)", password: ").append((Object)password).toString());
            schemaId = new StringBuilder().append((Object)host).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)":").append((Object)schema).toString().toLowerCase();
            var8_13 = this.mongos().contains((Object)schemaId);
            if (var8_13) {
                this.LOGGER().finest(new StringBuilder().append((Object)"getting ").append((Object)schemaId).append((Object)" from map").toString());
                db = ((Member)this.mongos().apply((Object)schemaId)).mongo().getDB(schema);
                replicationType = this.detectReplicationType(db, (Option<String>)username, password);
                this.LOGGER().finest(new StringBuilder().append((Object)"all known servers: ").append((Object)db.getMongo().getServerAddressList()).toString());
                this.addServer(friendlyName, schema, db, (Option<String>)username, password, replicationType);
                var19_16 = db;
            } else {
                this.LOGGER().finest(new StringBuilder().append((Object)"creating ").append((Object)schemaId).toString());
                sa = new ServerAddress(host, port);
                mongo = new Mongo(sa);
                db = mongo.getDB(schema);
                replicationType = this.detectReplicationType(db, (Option<String>)username, password);
                if (replicationType == Member$.MODULE$.RS()) {
                    mongo = new Mongo(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ServerAddress[]{sa}))));
                    db = mongo.getDB(schema);
                }
                var12_21 = Predef$.MODULE$;
                var15_22 = new Member(replicationType, mongo);
                var14_23 = Predef.ArrowAssoc$.MODULE$;
                this.mongos().$plus$eq(new Tuple2((Object)schemaId, (Object)var15_22));
                this.LOGGER().finest(new StringBuilder().append((Object)"schemaName: ").append((Object)friendlyName).append((Object)", schemaId: ").append((Object)schemaId).toString());
                this.addServer(friendlyName, schema, db, (Option<String>)username, password, replicationType);
                var19_16 = db;
            }
            return var19_16;
        }
        catch (Exception var24_24) {
            this.LOGGER().severe(new StringBuilder().append((Object)"can't get connection to ").append((Object)host).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"/").append((Object)schema).append((Object)" with username ").append((Object)username).append((Object)", password ").append((Object)password).toString());
            throw new PersistenceException(var24_24);
        }
    }

    public int detectReplicationType(DB db, Option<String> username, String password) {
        int n;
        try {
            int n2;
            if (username instanceof Some) {
                Some some = (Some)username;
                db.authenticate((String)some.x(), password.toCharArray());
                n2 = db.command("isMaster").toString().indexOf("\"ismaster\" : true") > 0 ? Member$.MODULE$.M() : Member$.MODULE$.S();
            } else {
                int n3;
                String stat = db.command("isMaster").toString();
                if (stat.indexOf("setName") > 0) {
                    this.LOGGER().finest("detected replica set");
                    n3 = Member$.MODULE$.RS();
                } else {
                    n3 = stat.indexOf("\"ismaster\" : true") > 0 ? Member$.MODULE$.M() : (stat.indexOf("\"ismaster\" : false") > 0 ? Member$.MODULE$.S() : Member$.MODULE$.UNKNOWN());
                }
                n2 = n3;
            }
            n = n2;
        }
        catch (Throwable throwable) {
            throw new PersistenceException("Failed to detect replication type");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = Member$.MODULE$.UNKNOWN();
        }
        return n;
    }

    public void addServer(String friendlyName, String schema, DB db, Option<String> username, String password, int replicationType) {
        BoxedUnit boxedUnit;
        String snl = friendlyName.toLowerCase();
        if (this.pool().contains((Object)snl)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            Nil$ nil$ = Nil$.MODULE$;
            Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
            boxedUnit = this.pool().$plus$eq(new Tuple2((Object)snl, (Object)nil$));
        }
        ListBuffer serverList = new ListBuffer();
        List list = (List)this.pool().apply((Object)snl);
        while (!list.isEmpty()) {
            DBServer dBServer = (DBServer)list.head();
            serverList.$plus$eq((Object)dBServer);
            list = (List)list.tail();
        }
        DBServer dbServer = new DBServer(db, username, password, replicationType);
        Object object = serverList.contains((Object)dbServer) ? BoxedUnit.UNIT : serverList.$plus$eq((Object)dbServer);
        Predef$ predef$ = Predef$.MODULE$;
        List list2 = serverList.toList();
        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
        this.pool().$plus$eq(new Tuple2((Object)snl, (Object)list2));
        this.LOGGER().finest(new StringBuilder().append((Object)"adding to pool, key: ").append((Object)snl).append((Object)", db: ").append((Object)db).toString());
    }

    private MongoDBConnectionManager$() {
        MODULE$ = this;
        this.LOGGER = Logger.getLogger(this.getClass().getName());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.mongos = new HashMap();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.pool = new HashMap();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

