/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.http;

import com.wizzardo.tools.http.Cookie;
import com.wizzardo.tools.http.Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;

public class Response {
    private static ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat get() {
            SimpleDateFormat format = (SimpleDateFormat)super.get();
            if (format == null) {
                format = new SimpleDateFormat("EEE, dd-MMM-yyyy kk:mm:ss z", Locale.US);
                this.set(format);
            }
            return format;
        }
    };
    protected HttpURLConnection connection;
    protected List<Cookie> cookies;
    protected Request request;

    protected Response(Request request, HttpURLConnection connection) {
        this.connection = connection;
        this.request = request;
        if (request.session != null) {
            request.session.appendCookies(this.parseCookies());
        }
    }

    public String asString() throws IOException {
        int i;
        String encoding = this.connection.getHeaderField("Content-Type");
        encoding = encoding != null ? ((i = encoding.indexOf("charset=")) > 0 ? encoding.substring(i + "charset=".length()) : "utf-8") : "utf-8";
        return this.asString(encoding);
    }

    public byte[] asBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.headerInt("Content-Length", 1024));
        this.writeTo(out);
        return out.toByteArray();
    }

    public void writeTo(OutputStream out) throws IOException {
        int r;
        byte[] buffer = new byte[10240];
        InputStream in = this.asStream();
        while ((r = in.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        out.flush();
    }

    public InputStream asStream() throws IOException {
        InputStream inputStream = this.connection.getResponseCode() < 400 ? this.connection.getInputStream() : this.connection.getErrorStream();
        String encoding = this.connection.getHeaderField("Content-Encoding");
        if ("gzip".equals(encoding)) {
            inputStream = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(encoding)) {
            inputStream = new DeflaterInputStream(inputStream);
        }
        return inputStream;
    }

    public String asString(String charset) throws IOException {
        byte[] bytes = this.asBytes();
        return new String(bytes, charset);
    }

    public List<Cookie> getCookies() {
        if (this.request.session != null) {
            return this.request.session.getCookies(this.connection.getURL());
        }
        return this.parseCookies();
    }

    public List<Cookie> cookies() {
        return this.getCookies();
    }

    public Request request() {
        return this.request;
    }

    private List<Cookie> parseCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Map<String, List<String>> headers = this.connection.getHeaderFields();
        if (headers.containsKey("Set-Cookie")) {
            for (String raw : headers.get("Set-Cookie")) {
                String[] data = raw.split("; *");
                String[] kv = data[0].split("=", 2);
                Cookie cookie = new Cookie(kv[0], kv[1]);
                for (int i = 1; i < data.length; ++i) {
                    kv = data[i].split("=", 2);
                    if (kv[0].equalsIgnoreCase("expires")) {
                        try {
                            cookie.expired = dateFormatThreadLocal.get().parse(kv[1]);
                        }
                        catch (ParseException ignore) {}
                        continue;
                    }
                    if (kv[0].equalsIgnoreCase("path")) {
                        cookie.path = kv[1];
                        continue;
                    }
                    if (!kv[0].equalsIgnoreCase("domain")) continue;
                    cookie.domain = kv[1];
                }
                if (cookie.path == null) {
                    cookie.path = "/";
                }
                if (cookie.domain == null) {
                    cookie.domain = this.connection.getURL().getHost();
                }
                cookies.add(cookie);
            }
        }
        this.cookies = cookies;
        return cookies;
    }

    public String getHeader(String key) {
        return this.connection.getHeaderField(key);
    }

    public Map<String, List<String>> getHeaders() {
        return this.connection.getHeaderFields();
    }

    public String header(String key) {
        return this.getHeader(key);
    }

    public int headerInt(String key, int def) {
        try {
            return this.headerInt(key);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public long headerLong(String key, long def) {
        try {
            return this.headerLong(key);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public int headerInt(String key) {
        return Integer.parseInt(this.getHeader(key));
    }

    public Long headerLong(String key) {
        return Long.parseLong(this.getHeader(key));
    }

    public Map<String, List<String>> headers() {
        return this.getHeaders();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public int getContentLength() throws IOException {
        return this.connection.getContentLength();
    }
}

