/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.http;

import com.wizzardo.tools.http.ConnectionMethod;
import com.wizzardo.tools.http.ContentType;
import com.wizzardo.tools.http.Cookie;
import com.wizzardo.tools.http.Request;
import com.wizzardo.tools.security.Base64;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class RequestArguments<T extends RequestArguments> {
    protected int maxRetryCount = 0;
    protected long pauseBetweenRetries = 0L;
    protected ConnectionMethod method = ConnectionMethod.GET;
    protected Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<String, byte[]> dataArrays = new HashMap<String, byte[]>();
    protected Map<String, String> dataTypes = new HashMap<String, String>();
    protected boolean multipart = false;
    protected String charsetForEncoding = "utf-8";
    protected Proxy proxy;
    protected boolean redirects = true;
    protected byte[] data;
    protected HostnameVerifier hostnameVerifier;
    protected SSLSocketFactory sslFactory;

    public Request createRequest(String url) {
        Request request = (Request)((Request)((Request)((Request)((Request)((Request)((Request)((Request)((Request)new Request(url).addHeaders(this.headers)).addParameterLists(this.params)).setPauseBetweenRetries(this.pauseBetweenRetries)).setMaxRetryCount(this.maxRetryCount)).setProxy(this.proxy)).setSSLSocketFactory(this.sslFactory)).setHostnameVerifier(this.hostnameVerifier)).method(this.method)).setUrlEncoding(this.charsetForEncoding);
        request.data = this.data;
        request.dataTypes = this.dataTypes;
        request.dataArrays = this.dataArrays;
        request.redirects = this.redirects;
        request.multipart = this.multipart;
        return request;
    }

    protected T self() {
        return (T)this;
    }

    public ConnectionMethod method() {
        return this.method;
    }

    public T setMaxRetryCount(int n) {
        this.maxRetryCount = n;
        return this.self();
    }

    public T setBasicAuthentication(String user, String password) {
        this.header("Authorization", "Basic " + Base64.encodeToString((byte[])(user + ":" + password).getBytes()));
        return this.self();
    }

    public T setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this.self();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public T maxRetryCount(int n) {
        this.maxRetryCount = n;
        return this.self();
    }

    public T setPauseBetweenRetries(long pause) {
        this.pauseBetweenRetries = pause;
        return this.self();
    }

    public T pauseBetweenRetries(long pause) {
        this.pauseBetweenRetries = pause;
        return this.self();
    }

    public T setMethod(ConnectionMethod method) {
        this.method = method;
        return this.self();
    }

    public T method(ConnectionMethod method) {
        this.method = method;
        return this.self();
    }

    public T setCookies(String cookie) {
        this.headers.put("Cookie", cookie);
        return this.self();
    }

    public T cookies(String cookie) {
        this.headers.put("Cookie", cookie);
        return this.self();
    }

    public T cookies(List<Cookie> cookies) {
        StringBuilder sb = new StringBuilder();
        for (Cookie c : cookies) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(c.key).append("=").append(c.value);
        }
        if (sb.length() > 0) {
            this.headers.put("Cookie", sb.toString());
        }
        return this.self();
    }

    public T setCookies(List<Cookie> cookies) {
        return this.cookies(cookies);
    }

    public T setReferer(String referer) {
        this.headers.put("Referer", referer);
        return this.self();
    }

    public T referer(String referer) {
        this.headers.put("Referer", referer);
        return this.self();
    }

    public T setJson(String json) {
        return this.json(json);
    }

    public T json(String json) {
        try {
            return this.data(json.getBytes("utf-8"), ContentType.JSON);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.self();
        }
    }

    public T setXml(String xml) {
        return this.xml(xml);
    }

    public T xml(String xml) {
        try {
            return this.data(xml.getBytes("utf-8"), ContentType.XML);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.self();
        }
    }

    public T setData(byte[] data, String contentType) {
        return this.data(data, contentType);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] data() {
        return this.data;
    }

    public T data(byte[] data, String contentType) {
        this.data = data;
        this.method = ConnectionMethod.POST;
        this.setContentType(contentType);
        return this.self();
    }

    public T data(byte[] data, ContentType contentType) {
        return this.data(data, contentType.value);
    }

    public T removeParameter(String key) {
        this.params.remove(key);
        this.dataArrays.remove(key);
        this.dataTypes.remove(key);
        return this.self();
    }

    public T addParameter(String key, Object value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public T addParameter(String key, String value) {
        List<String> l = this.params.get(key);
        if (l == null) {
            l = new ArrayList<String>();
            this.params.put(key, l);
        }
        l.add(value);
        return this.self();
    }

    public T addParameters(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
        return this.self();
    }

    public String param(String key) {
        List<String> strings = this.params(key);
        return strings == null || strings.isEmpty() ? null : strings.get(0);
    }

    public List<String> params(String key) {
        return this.params.get(key);
    }

    public T param(String key, String value) {
        return this.addParameter(key, value);
    }

    public T param(String key, Object value) {
        return this.addParameter(key, value);
    }

    public T params(Map<String, String> params) {
        return this.addParameters(params);
    }

    public T addParameterList(String key, List<String> values) {
        List<String> l = this.params.get(key);
        if (l == null) {
            l = new ArrayList<String>();
            this.params.put(key, l);
        }
        l.addAll(values);
        return this.self();
    }

    public T addParameterLists(Map<String, List<String>> params) {
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            this.addParameterList(entry.getKey(), entry.getValue());
        }
        return this.self();
    }

    public Map<String, List<String>> params() {
        return this.params;
    }

    public T setUrlEncoding(String charset) {
        this.charsetForEncoding = charset;
        return this.self();
    }

    public T disableRedirects() {
        this.redirects = false;
        return this.self();
    }

    public T addFile(String key, File value) {
        return this.addFile(key, value.getAbsolutePath());
    }

    public T addFile(String key, String path) {
        return this.addFile(key, path, null);
    }

    public T addFile(String key, String path, String type) {
        this.multipart = true;
        this.method = ConnectionMethod.POST;
        this.addParameter(key, "file://" + path);
        if (type != null) {
            this.dataTypes.put(key, type);
        }
        return this.self();
    }

    public T addByteArray(String key, byte[] array, String name) {
        return this.addByteArray(key, array, name, null);
    }

    public T addByteArray(String key, byte[] array, String name, String type) {
        this.multipart = true;
        this.method = ConnectionMethod.POST;
        this.addParameter(key, "array://" + name);
        this.dataArrays.put(key, array);
        if (type != null) {
            this.dataTypes.put(key, type);
        }
        return this.self();
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public T addHeader(String key, String value) {
        this.headers.put(key, value);
        return this.self();
    }

    public T removeHeader(String key) {
        this.headers.remove(key);
        return this.self();
    }

    public T addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this.self();
    }

    public T header(String key, String value) {
        this.headers.put(key, value);
        return this.self();
    }

    public String header(String key) {
        return this.headers.get(key);
    }

    public T setHostnameVerifier(HostnameVerifier hv) {
        this.hostnameVerifier = hv;
        return this.self();
    }

    public T setSSLSocketFactory(SSLSocketFactory sslFactory) {
        this.sslFactory = sslFactory;
        return this.self();
    }

    public T setContentType(String contentType) {
        return this.addHeader("Content-Type", contentType);
    }

    public T setContentType(ContentType contentType) {
        return this.addHeader("Content-Type", contentType.value);
    }
}

