/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.http;

import com.wizzardo.tools.http.Cookie;
import com.wizzardo.tools.http.Request;
import com.wizzardo.tools.http.RequestArguments;
import com.wizzardo.tools.misc.Unchecked;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpSession
extends RequestArguments<HttpSession> {
    private Map<String, List<Cookie>> cookies = new ConcurrentHashMap<String, List<Cookie>>();

    public HttpSession() {
        this.headers.put("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/14.0.835.187 Safari/535.1");
        this.headers.put("Accept-Encoding", "gzip, deflate");
    }

    @Override
    public Request createRequest(String url) {
        return (Request)super.createRequest(url).setSession(this).setCookies(this.getCookies(url));
    }

    @Override
    protected HttpSession self() {
        return this;
    }

    public List<Cookie> getCookies(String url) {
        try {
            return this.getCookies(new URL(url));
        }
        catch (MalformedURLException e) {
            throw Unchecked.rethrow((Exception)e);
        }
    }

    public Map<String, List<Cookie>> getCookies() {
        return this.cookies;
    }

    public List<Cookie> getCookies(URL url) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        String domain = url.getHost();
        while (domain.length() > 0) {
            int index;
            List<Cookie> l = this.cookies.get(domain);
            if (l != null) {
                Iterator<Cookie> i = l.iterator();
                while (i.hasNext()) {
                    Cookie cookie = i.next();
                    if (cookie.isExpired()) {
                        i.remove();
                        continue;
                    }
                    if (!(url.getPath().isEmpty() ? "/" : url.getPath()).startsWith(cookie.path)) continue;
                    cookies.add(cookie);
                }
            }
            if ((index = domain.indexOf(46)) < 0) break;
            domain = domain.substring(index + 1);
        }
        return cookies;
    }

    public void appendCookies(Map<String, List<Cookie>> cookies) {
        this.cookies.putAll(cookies);
    }

    public synchronized void appendCookies(List<Cookie> cookies) {
        block0: for (Cookie cookie : cookies) {
            String domain = cookie.domain.startsWith(".") ? cookie.domain.substring(1) : cookie.domain;
            List<Cookie> l = this.cookies.get(domain);
            if (cookie.value.equalsIgnoreCase("deleted") && l != null) {
                Iterator<Cookie> i = l.iterator();
                while (i.hasNext()) {
                    Cookie it = i.next();
                    if (!it.key.equals(cookie.key) || !it.domain.equals(cookie.domain)) continue;
                    i.remove();
                }
                continue;
            }
            if (l == null) {
                l = new ArrayList<Cookie>();
                this.cookies.put(domain, l);
            }
            for (Cookie it : l) {
                if (!it.key.equals(cookie.key) || !it.domain.equals(cookie.domain)) continue;
                it.expired = cookie.expired;
                it.value = cookie.value;
                continue block0;
            }
            l.add(cookie);
        }
    }
}

