/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;

public class Unchecked {
    private static <T extends Exception> void throwsUnchecked(Exception toThrow) throws T {
        throw toThrow;
    }

    public static RuntimeException rethrow(Exception ex) {
        Unchecked.throwsUnchecked(ex);
        return new IllegalStateException("unreachable statement");
    }

    public static void run(UncheckedRunnable runnable) {
        Unchecked.run(runnable, null);
    }

    public static <T> T call(Callable<T> callable) {
        return Unchecked.call(callable, null);
    }

    public static void run(UncheckedRunnable runnable, Runnable finaly) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw Unchecked.rethrow(e);
        }
        finally {
            if (finaly != null) {
                finaly.run();
            }
        }
    }

    public static <T> T call(Callable<T> callable, Runnable finaly) {
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw Unchecked.rethrow(e);
        }
        finally {
            if (finaly != null) {
                finaly.run();
            }
        }
    }

    public static <T, C extends Closeable> T call(C closeable, Consumer<C, T> consumer) {
        T t;
        try {
            t = consumer.call(closeable);
        }
        catch (Exception e) {
            throw Unchecked.rethrow(e);
        }
        finally {
            try {
                closeable.close();
            }
            catch (IOException ignored) {}
        }
        return t;
    }

    public static void ignore(UncheckedRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> T ignore(Callable<T> callable) {
        return Unchecked.ignore(callable, null);
    }

    public static <T> T ignore(Callable<T> callable, T def) {
        try {
            return callable.call();
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static interface Consumer<T, R> {
        public R call(T var1) throws Exception;
    }

    public static interface UncheckedRunnable {
        public void run() throws Exception;
    }
}

