/*
 * Decompiled with CFR 0.152.
 */
package com.wiris.plugin.storage;

import com.wiris.plugin.storage.CompressedStorageAndCache;
import com.wiris.plugin.storage.FileStorageAndCache;
import com.wiris.plugin.storage.StorageAndCache;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ContainerStorageAndCache
implements StorageAndCache {
    private StorageAndCache storage;

    public void init(HttpServletRequest request, Properties config) {
        String method = request.getParameter("m");
        if ("files".equals(method)) {
            this.storage = new FileStorageAndCache();
        } else if ("compressed".equals(method)) {
            this.storage = new CompressedStorageAndCache();
        } else {
            String className = config.getProperty("wiriscontainerstorageclass");
            if (className == null) {
                this.storage = new FileStorageAndCache();
            } else {
                try {
                    this.storage = (StorageAndCache)this.getClass().getClassLoader().loadClass(className).newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        }
        this.storage.init(request, config);
    }

    public String codeDigest(String content) {
        return this.storage.codeDigest(content);
    }

    public String decodeDigest(String digest) {
        return this.storage.decodeDigest(digest);
    }

    public byte[] retreiveData(String digest) {
        return this.storage.retreiveData(digest);
    }

    public void storeData(String digest, byte[] stream) {
        this.storage.storeData(digest, stream);
    }
}

