/*
 * Decompiled with CFR 0.152.
 */
package com.wiris.plugin.dispatchers;

import com.wiris.plugin.storage.StorageAndCache;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;

public class TestDispatcher {
    public static void dispatch(Properties config, HttpServletResponse response, StorageAndCache storage) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print("<html><head><title>Plugin WIRIS test page</title><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" /><style type=\"text/css\">/*<!--*/html {font-family: sans-serif;}h2 {margin-left: 1em;}h3 {margin-left: 2em;}p {margin-left: 3em;}p.concrete {margin-left: 4em;}.ok {font-weight: bold;color: #0c0;}.error {font-weight: bold;color: #f00;}/*-->*/</style></head><body><h1>Plugin WIRIS test page</h1>");
        out.print("<h2>Connecting to WIRIS image server</h2><p>");
        out.print("Connecting to " + config.getProperty("wirisimageservicehost") + " on port " + config.getProperty("wirisimageserviceport") + "... ");
        try {
            Socket socket = new Socket(config.getProperty("wirisimageservicehost"), Integer.parseInt(config.getProperty("wirisimageserviceport")));
            TestDispatcher.wrs_assert(out, socket.isConnected());
            socket.close();
        }
        catch (IOException e) {
            TestDispatcher.wrs_assert(out, false);
        }
        out.print("</p><h2>Storing</h2><p>");
        out.print("Generating digest... ");
        String digest = storage.codeDigest("test");
        TestDispatcher.wrs_assert(out, true);
        out.print("Storing data... ");
        storage.storeData(digest, "test".getBytes("UTF-8"));
        TestDispatcher.wrs_assert(out, true);
        out.print("</p><h2>Retreiving</h2><p>");
        out.print("Retreiving content... ");
        storage.decodeDigest(digest);
        TestDispatcher.wrs_assert(out, true);
        out.print("Retreiving data... ");
        storage.retreiveData(digest);
        TestDispatcher.wrs_assert(out, true);
        out.print("</p></body></html>");
        out.close();
    }

    private static void wrs_assert(PrintWriter out, boolean condition) {
        if (condition) {
            out.print("<span class=\"ok\">OK</span><br/>");
        } else {
            out.print("<span class=\"error\">ERROR</span><br/>");
        }
    }
}

