/*
 * Decompiled with CFR 0.152.
 */
package com.wiris.plugin.dispatchers;

import com.wiris.plugin.LibWIRIS;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CASDispatcher {
    public static void dispatch(Properties config, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        String[] availableLanguages = LibWIRIS.getAvailableCASLanguages(config.getProperty("wiriscaslanguages"));
        String mode = request.getParameter("mode");
        if (mode != null && mode.equals("applet")) {
            String language = request.getParameter("lang");
            if (language == null || !LibWIRIS.inArray(language, availableLanguages)) {
                language = availableLanguages[0];
            }
            String codebase = LibWIRIS.replaceVariable(config.getProperty("wiriscascodebase"), "LANG", language);
            String archive = LibWIRIS.replaceVariable(config.getProperty("wiriscasarchive"), "LANG", language);
            String className = LibWIRIS.replaceVariable(config.getProperty("wiriscasclass"), "LANG", language);
            CASDispatcher.printCAS(out, codebase, archive, className);
        } else {
            CASDispatcher.printCASContainer(out, config, availableLanguages);
        }
        out.close();
    }

    private static void printCAS(PrintWriter out, String codebase, String archive, String className) {
        out.print("<html><head><style type=\"text/css\">/*<!--*/ html, body { height: 100%; } body { overflow: hidden; margin: 0; } applet { height: 100%; width: 100%; } /*-->*/</style></head><body><applet id=\"applet\" alt=\"WIRIS CAS\" codebase=\"" + LibWIRIS.htmlentities(codebase, true) + "\" archive=\"" + LibWIRIS.htmlentities(archive, true) + "\" code=\"" + LibWIRIS.htmlentities(className, true) + "\"><p>You need JAVA&reg; to use WIRIS tools.<br />FREE download from <a target=\"_blank\" href=\"http://www.java.com\">www.java.com</a></p></applet></body></html>");
    }

    private static void printCASContainer(PrintWriter out, Properties config, String[] availableLanguages) {
        out.print("<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/><script type=\"text/javascript\" src=\"../resources/cas.js\"></script><title>WIRIS CAS</title><style type=\"text/css\">/*<!--*/ html, body, #optionForm { height: 100%; } body { overflow: hidden; margin: 0; } #controls { width: 100%; } /*-->*/</style></head><body><form id=\"optionForm\"><div id=\"appletContainer\"></div><table id=\"controls\"><tr><td>Width</td><td><input name=\"width\" type=\"text\" value=\"" + config.getProperty("CAS_width") + "\"/></td><td><input name=\"executeonload\" type=\"checkbox\"/> Calculate on load</td><td><input name=\"toolbar\" type=\"checkbox\" checked /> Show toolbar</td><td>Language <select id=\"languageList\">");
        for (int i = 0; i < availableLanguages.length; ++i) {
            String language = LibWIRIS.htmlentities(availableLanguages[i], true);
            out.print("<option value=\"" + language + "\">" + language + "</option>");
        }
        out.print("</select></td></tr><tr><td>Height</td><td><input name=\"height\" type=\"text\" value=\"" + config.getProperty("CAS_height") + "\"/></td><td><input name=\"focusonload\" type=\"checkbox\"/> Focus on load</td><td><input name=\"level\" type=\"checkbox\"/> Elementary mode</td><td></td></tr><tr><td colspan=\"5\"><input id=\"submit\" value=\"Accept\" type=\"button\"/> <input id=\"cancel\" value=\"Cancel\" type=\"button\"/></td></tr></table></form></body></html>");
    }
}

