package com.wiris.plugin.dispatchers;

import com.wiris.plugin.LibWIRIS;
import com.wiris.plugin.storage.StorageAndCache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;

import java.net.URL;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public abstract class ShowImageDispatcher {
    // Retrocompatibility: there was a time that the files had another format.

    private static Hashtable getConfigurationAndFonts(Properties config, String content) throws Exception {
        BufferedReader formulaBufferedReader = new BufferedReader(new StringReader(content));
        String line;
        String mathml = "";
        Properties fonts = new Properties();

        try {
            if ((line = formulaBufferedReader.readLine()) != null) {
                mathml = line.trim();
                int i = 0;

                while ((line = formulaBufferedReader.readLine()) != null && i < LibWIRIS.xmlFileAttributes.length) {
                    config.setProperty(LibWIRIS.imageConfigProperties.getProperty(LibWIRIS.xmlFileAttributes[i]), 
                                       line.trim());
                    ++i;
                }

                i = 0;

                while ((line = formulaBufferedReader.readLine()) != null) {
                    line = line.trim();

                    if (line.length() > 0) {
                        fonts.setProperty("font" + i, line);
                        ++i;
                    }
                }

                Hashtable toReturn = new Hashtable();
                toReturn.put("mathml", mathml);
                toReturn.put("config", config);
                toReturn.put("fonts", fonts);
                return toReturn;
            }

            throw new Exception("Empty content");
        } catch (IOException e) {
            throw new Exception("Error: the formula content can not be readed.");
        }
    }

    private static Hashtable getConfigurationAndFontsFromIni(Properties config, String content) throws Exception {
        Properties formulaConfig = new Properties();

        try {
            formulaConfig.load(new ByteArrayInputStream(content.getBytes("UTF-8")));
            Properties fonts = new Properties();
            Iterator i = formulaConfig.keySet().iterator();

            while (i.hasNext()) {
                String key = (String)i.next();

                if (!key.equals("mml")) {
                    if (key.length() >= 4 && key.substring(0, 4).equals("font")) {
                        fonts.setProperty(key, formulaConfig.getProperty(key).trim());
                    } else {
                        config.setProperty(key, formulaConfig.getProperty(key).trim());
                    }
                }
            }

            Hashtable toReturn = new Hashtable();
            toReturn.put("mathml", formulaConfig.getProperty("mml").trim());
            toReturn.put("config", config);
            toReturn.put("fonts", fonts);
            return toReturn;
        } catch (IOException e) {
            throw new Exception("Error: the formula content can not be readed.");
        }
    }

    private static byte[] createImage(Properties config, StorageAndCache storage, String digest, 
                                      String referer) throws Exception {
        String content = storage.decodeDigest(digest);

        if (content == null) {
            throw new Exception("Error: the formula has not been created.");
        }

        Hashtable configAndFonts;

        if (content.startsWith("<")) {
            configAndFonts = ShowImageDispatcher.getConfigurationAndFonts(config, content);
        } else {
            configAndFonts = ShowImageDispatcher.getConfigurationAndFontsFromIni(config, content);
        }

        config = (Properties)configAndFonts.get("config");

        // Retrocompatibility: when wirisimagenumbercolor is not defined

        if (!config.containsKey("wirisimagenumbercolor") && config.containsKey("wirisimagesymbolcolor")) {
            config.setProperty("wirisimagenumbercolor", config.getProperty("wirisimagesymbolcolor"));
        }

        // Retrocompatibility: when wirisimageidentcolor is not defined

        if (!config.containsKey("wirisimageidentcolor") && config.containsKey("wirisimagesymbolcolor")) {
            config.setProperty("wirisimageidentcolor", config.getProperty("wirisimagesymbolcolor"));
        }

        // Converting configuration to parameters.
        Properties properties = new Properties();
        properties.setProperty("mml", (String)configAndFonts.get("mathml"));
        Iterator i = LibWIRIS.imageConfigProperties.keySet().iterator();

        while (i.hasNext()) {
            String serverParam = (String)i.next();
            String configKey = LibWIRIS.imageConfigProperties.getProperty(serverParam);
            String configValue = config.getProperty(configKey);

            if (configValue != null) {
                properties.setProperty(serverParam, configValue.trim());
            }
        }

        // Converting fonts to parameters.
        Properties fonts = (Properties)configAndFonts.get("fonts");
        String fontRangesString = config.getProperty("wirisimagefontranges");

        if (fontRangesString != null) {
            int carry = fonts.size();
            int j = 0;
            StringTokenizer tokens = new StringTokenizer(fontRangesString, ",");

            while (tokens.hasMoreElements()) {
                String rangeName = ((String)tokens.nextElement()).trim();
                String range = config.getProperty(rangeName);

                if (range != null) {
                    fonts.setProperty("font" + (carry + j), range.trim());
                    ++j;
                }
            }
        }

        i = fonts.keySet().iterator();

        while (i.hasNext()) {
            String key = (String)i.next();
            properties.setProperty(key, fonts.getProperty(key));
        }

        // Query.
        URL url = LibWIRIS.getImageServiceURL(config, null);
        BufferedInputStream httpInput = new BufferedInputStream(LibWIRIS.getContents(url, properties, referer));
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        LibWIRIS.flow(httpInput, dataStream);
        byte[] data = dataStream.toByteArray();
        storage.storeData(digest, data);

        return data;
    }

    public static void dispatch(Properties config, HttpServletRequest request, HttpServletResponse response, 
                                StorageAndCache storage) throws ServletException, IOException {
        String digest = request.getParameter("formula");

        if (digest == null) {
            PrintWriter out = response.getWriter();
            out.print("Error: no image name has been sended.");
            out.close();
        } else {
            ServletOutputStream out = response.getOutputStream();
            byte[] data = storage.retreiveData(digest);

            try {
                if (data == null) {
                    data = ShowImageDispatcher.createImage(config, storage, digest, LibWIRIS.getReferer(request));
                }

                response.setContentType("image/png"); // Caution: the content type depends on the format of the image.
                out.write(data);
            } catch (Exception e) {
                out.print(e.getMessage());
            }

            out.close();
        }
    }
}
