/*
 * Decompiled with CFR 0.152.
 */
package oak.widget.spreadsheetview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Scroller;
import java.util.Arrays;
import java.util.Comparator;
import oak.R;
import oak.util.OakUtils;
import oak.widget.spreadsheetview.SpreadsheetCell;
import oak.widget.spreadsheetview.SpreadsheetRow;

public class SpreadsheetView
extends View
implements GestureDetector.OnGestureListener {
    private GestureDetector gestureDetector;
    private Scroller scroller;
    private OnHeaderClickListener headerListener;
    private OnFooterClickListener footerListener;
    private OnCellClickListener cellListener;
    private OnFooterChangedListener footerChangedListener;
    private static final int FLING_SCALE = -2;
    private float stickyTableWidth;
    private float stickyTableHeight;
    private float stickyFooterHeight;
    private float stickyHeaderHeight;
    private float stickyColumnWidth;
    private float dataCellWidth;
    private float dataCellHeight;
    private boolean dataSet;
    private final float DEFAULT_CELL_WIDTH = 150.0f;
    private final float DEFAULT_CELL_HEIGHT = 150.0f;
    private final float DEFAULT_STICKY_FOOTER_HEIGHT = 0.0f;
    private final float DEFAULT_STICKY_HEADER_HEIGHT = 100.0f;
    private final float DEFAULT_STICKY_COLUMN_WIDTH = 150.0f;
    private final float DEFAULT_HORIZONTAL_BORDER_WIDTH = 0.0f;
    private final float DEFAULT_DIVIDING_LINE_WIDTH = 4.0f;
    private final int DEFAULT_TEXT_SIZE = 32;
    private float activeDataWindowWidth;
    private float activeDataWindowHeight;
    private float windowScrollX;
    private float windowScrollY;
    private float scrollStartX;
    private float scrollStartY;
    private float maxWindowScrollX;
    private float maxWindowScrollY;
    private int dataSizeObjects;
    private int dataSizeValues;
    protected SpreadsheetRow[] objectData;
    protected String[] headers;
    private boolean[] headerSelected;
    private boolean[] footerSelected;
    protected int[] sorted;
    public static final int SORTED_UNSORTED = 0;
    public static final int SORTED_ASCENDING = 1;
    public static final int SORTED_DESCENDING = 2;
    protected String[] footers;
    private float[] stickyColumnWidths;
    private int numberStickyColumns;
    private int targetNumberStickyColumns;
    private Paint vertDividingPaint;
    private Paint horzDividingPaint;
    private SpreadsheetCell dataCell;
    private SpreadsheetCell stickyHeaderCell;
    private SpreadsheetCell stickyFooterCell;
    private SpreadsheetCell stickyColumnCell;
    private SpreadsheetCell leftFootCornerCell;
    private SpreadsheetCell leftHeadCornerCell;

    public SpreadsheetView(Context context) {
        super(context);
        this.init(context);
        this.defaultCells();
        this.defaultDimensions();
    }

    public SpreadsheetView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.defaultCells();
        this.defaultDimensions();
        this.parseAttributes(context, attrs);
    }

    public SpreadsheetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
        this.defaultCells();
        this.defaultDimensions();
        this.parseAttributes(context, attrs);
    }

    private void parseAttributes(Context context, AttributeSet attrs) {
        TypedArray a;
        if (attrs != null && (a = context.obtainStyledAttributes(R.styleable.SpreadsheetView)) != null) {
            float dataCellHeight;
            float dataCellWidth;
            int horizontalDividingLineColor;
            int horizontalDividingLineWidth;
            int verticalDividingLineColor;
            int allTextSize;
            int stickyFooterCellSelectedTextColor;
            int stickyFooterCellTextColor;
            int stickyHeaderCellSelectedTextColor;
            int stickyHeaderCellTextColor;
            int stickyColumnCellSelectedTextColor;
            int stickyColumnCellTextColor;
            int dataCellSelectedTextColor;
            int dataCellTextColor;
            int allTextSelectedColorRes;
            int allTextSelectedColor;
            int allTextColorRes;
            int allTextColor;
            int leftFooterCornerCellSelectedDrawable;
            int leftFooterCornerCellDrawable;
            int leftHeaderCornerCellSelectedDrawable;
            int leftHeaderCornerCellDrawable;
            int stickyFooterCellSelectedDrawable;
            int stickyFooterCellDrawable;
            int stickyHeaderCellSelectedDrawable;
            int stickyHeaderCellDrawable;
            int stickyColumnCellSelectedDrawable;
            int stickyColumnCellDrawable;
            int dataCellSelectedDrawable;
            int dataCellDrawable = a.getResourceId(R.styleable.SpreadsheetView_dataCellDrawable, 0);
            if (dataCellDrawable != 0) {
                this.dataCell.setDrawable(context.getResources().getDrawable(dataCellDrawable));
            }
            if ((dataCellSelectedDrawable = a.getResourceId(R.styleable.SpreadsheetView_dataCellSelectedDrawable, 0)) != 0) {
                this.dataCell.setSelectedDrawable(this.getContext().getResources().getDrawable(dataCellSelectedDrawable));
            }
            if ((stickyColumnCellDrawable = a.getResourceId(R.styleable.SpreadsheetView_stickyColumnCellDrawable, 0)) != 0) {
                this.stickyColumnCell.setDrawable(this.getContext().getResources().getDrawable(stickyColumnCellDrawable));
            }
            if ((stickyColumnCellSelectedDrawable = a.getResourceId(R.styleable.SpreadsheetView_stickyColumnCellSelectedDrawable, 0)) != 0) {
                this.stickyColumnCell.setSelectedDrawable(this.getContext().getResources().getDrawable(stickyColumnCellSelectedDrawable));
            }
            if ((stickyHeaderCellDrawable = a.getResourceId(R.styleable.SpreadsheetView_stickyHeaderCellDrawable, 0)) != 0) {
                this.stickyHeaderCell.setDrawable(this.getContext().getResources().getDrawable(stickyHeaderCellDrawable));
                this.leftHeadCornerCell.setDrawable(this.getContext().getResources().getDrawable(stickyHeaderCellDrawable));
            }
            if ((stickyHeaderCellSelectedDrawable = a.getResourceId(R.styleable.SpreadsheetView_stickyHeaderCellSelectedDrawable, 0)) != 0) {
                this.stickyHeaderCell.setSelectedDrawable(this.getContext().getResources().getDrawable(stickyHeaderCellSelectedDrawable));
                this.leftHeadCornerCell.setSelectedDrawable(this.getContext().getResources().getDrawable(stickyHeaderCellSelectedDrawable));
            }
            if ((stickyFooterCellDrawable = a.getResourceId(R.styleable.SpreadsheetView_stickyFooterCellDrawable, 0)) != 0) {
                this.stickyFooterCell.setDrawable(this.getContext().getResources().getDrawable(stickyFooterCellDrawable));
                this.leftFootCornerCell.setDrawable(this.getContext().getResources().getDrawable(stickyFooterCellDrawable));
            }
            if ((stickyFooterCellSelectedDrawable = a.getResourceId(R.styleable.SpreadsheetView_stickyFooterCellSelectedDrawable, 0)) != 0) {
                this.stickyFooterCell.setSelectedDrawable(this.getContext().getResources().getDrawable(stickyFooterCellSelectedDrawable));
                this.leftFootCornerCell.setSelectedDrawable(this.getContext().getResources().getDrawable(stickyFooterCellSelectedDrawable));
            }
            if ((leftHeaderCornerCellDrawable = a.getResourceId(R.styleable.SpreadsheetView_leftHeaderCornerCellDrawable, 0)) != 0) {
                this.leftHeadCornerCell.setDrawable(this.getContext().getResources().getDrawable(leftHeaderCornerCellDrawable));
            }
            if ((leftHeaderCornerCellSelectedDrawable = a.getResourceId(R.styleable.SpreadsheetView_leftHeaderCornerCellSelectedDrawable, 0)) != 0) {
                this.leftHeadCornerCell.setSelectedDrawable(this.getContext().getResources().getDrawable(leftHeaderCornerCellSelectedDrawable));
            }
            if ((leftFooterCornerCellDrawable = a.getResourceId(R.styleable.SpreadsheetView_leftFooterCornerCellDrawable, 0)) != 0) {
                this.leftFootCornerCell.setDrawable(this.getContext().getResources().getDrawable(leftFooterCornerCellDrawable));
            }
            if ((leftFooterCornerCellSelectedDrawable = a.getResourceId(R.styleable.SpreadsheetView_leftFooterCornerCellSelectedDrawable, 0)) != 0) {
                this.leftFootCornerCell.setSelectedDrawable(this.getContext().getResources().getDrawable(leftFooterCornerCellSelectedDrawable));
            }
            if ((allTextColor = a.getColor(R.styleable.SpreadsheetView_cellTextColor, -1)) != -1) {
                this.setAllCellsTextColor(allTextColor);
            }
            if ((allTextColorRes = a.getResourceId(R.styleable.SpreadsheetView_cellTextColor, -1)) != -1) {
                this.setAllCellsTextColor(this.getContext().getResources().getColor(allTextColorRes));
            }
            if ((allTextSelectedColor = a.getColor(R.styleable.SpreadsheetView_cellSelectedTextColor, -1)) != -1) {
                this.setAllCellsSelectedTextColor(allTextSelectedColor);
            }
            if ((allTextSelectedColorRes = a.getResourceId(R.styleable.SpreadsheetView_cellSelectedTextColor, -1)) != -1) {
                this.setAllCellsSelectedTextColor(this.getContext().getResources().getColor(allTextSelectedColorRes));
            }
            if ((dataCellTextColor = a.getColor(R.styleable.SpreadsheetView_dataCellTextColor, -1)) != -1) {
                this.dataCell.setTextColor(dataCellTextColor);
            }
            if ((dataCellSelectedTextColor = a.getColor(R.styleable.SpreadsheetView_dataCellSelectedTextColor, -1)) != -1) {
                this.dataCell.setSelectedTextColor(dataCellSelectedTextColor);
            }
            if ((stickyColumnCellTextColor = a.getColor(R.styleable.SpreadsheetView_stickyColumnCellTextColor, -1)) != -1) {
                this.stickyColumnCell.setTextColor(stickyColumnCellTextColor);
            }
            if ((stickyColumnCellSelectedTextColor = a.getColor(R.styleable.SpreadsheetView_stickyColumnCellSelectedTextColor, -1)) != -1) {
                this.stickyColumnCell.setSelectedTextColor(stickyColumnCellSelectedTextColor);
            }
            if ((stickyHeaderCellTextColor = a.getColor(R.styleable.SpreadsheetView_stickyHeaderCellTextColor, -1)) != -1) {
                this.stickyHeaderCell.setTextColor(stickyHeaderCellTextColor);
                this.leftHeadCornerCell.setTextColor(stickyHeaderCellTextColor);
            }
            if ((stickyHeaderCellSelectedTextColor = a.getColor(R.styleable.SpreadsheetView_stickyHeaderCellSelectedTextColor, -1)) != -1) {
                this.stickyHeaderCell.setSelectedTextColor(stickyHeaderCellSelectedTextColor);
                this.leftHeadCornerCell.setSelectedTextColor(stickyHeaderCellSelectedTextColor);
            }
            if ((stickyFooterCellTextColor = a.getColor(R.styleable.SpreadsheetView_stickyFooterCellTextColor, -1)) != -1) {
                this.stickyFooterCell.setTextColor(stickyFooterCellTextColor);
                this.leftFootCornerCell.setTextColor(stickyFooterCellTextColor);
            }
            if ((stickyFooterCellSelectedTextColor = a.getColor(R.styleable.SpreadsheetView_stickyFooterCellSelectedTextColor, -1)) != -1) {
                this.stickyFooterCell.setSelectedTextColor(stickyFooterCellSelectedTextColor);
                this.leftFootCornerCell.setSelectedTextColor(stickyFooterCellSelectedTextColor);
            }
            if ((allTextSize = a.getDimensionPixelSize(R.styleable.SpreadsheetView_cellTextSize, -1)) != -1) {
                this.setAllCellsTextSize(allTextSize);
            }
            try {
                String fontName = a.getString(R.styleable.SpreadsheetView_cellFont);
                if (fontName != null) {
                    this.setAllCellsTypeface(OakUtils.getStaticTypeFace((Context)this.getContext(), (String)fontName));
                }
            }
            catch (IllegalArgumentException ex) {
                try {
                    int fontNameId = a.getResourceId(R.styleable.SpreadsheetView_cellFont, -1);
                    if (fontNameId != -1) {
                        this.setAllCellsTypeface(OakUtils.getStaticTypeFace((Context)this.getContext(), (String)this.getResources().getString(fontNameId)));
                    }
                }
                catch (IllegalArgumentException fx) {
                    fx.printStackTrace();
                }
            }
            int verticalDividingLineWidth = a.getDimensionPixelSize(R.styleable.SpreadsheetView_verticalDividingLineWidth, -1);
            if (verticalDividingLineWidth != -1) {
                this.getVerticalDividingPaint().setStrokeWidth((float)verticalDividingLineWidth);
            }
            if ((verticalDividingLineColor = a.getInt(R.styleable.SpreadsheetView_verticalDividingLineColor, -1)) != -1) {
                this.getVerticalDividingPaint().setColor(verticalDividingLineColor);
            }
            if ((horizontalDividingLineWidth = a.getDimensionPixelSize(R.styleable.SpreadsheetView_horizontalDividingLineWidth, -1)) != -1) {
                this.getHorizontalDividingPaint().setStrokeWidth((float)horizontalDividingLineWidth);
            }
            if ((horizontalDividingLineColor = a.getInt(R.styleable.SpreadsheetView_horizontalDividingLineColor, -1)) != -1) {
                this.getHorizontalDividingPaint().setColor(horizontalDividingLineColor);
            }
            boolean showFooter = a.getBoolean(R.styleable.SpreadsheetView_showFooter, false);
            int footerHeight = a.getDimensionPixelSize(R.styleable.SpreadsheetView_footerHeight, -1);
            if (!showFooter) {
                this.setStickyFooterHeight(0.0f);
            } else if (footerHeight != -1) {
                this.setStickyFooterHeight(footerHeight);
            }
            int headerHeight = a.getDimensionPixelSize(R.styleable.SpreadsheetView_headerHeight, -1);
            if (headerHeight != -1) {
                this.setStickyHeaderHeight(headerHeight);
            }
            if ((dataCellWidth = (float)a.getDimensionPixelSize(R.styleable.SpreadsheetView_cellWidth, -1)) == -1.0f) {
                dataCellWidth = 150.0f;
            }
            if ((dataCellHeight = (float)a.getDimensionPixelSize(R.styleable.SpreadsheetView_cellHeight, -1)) == -1.0f) {
                dataCellHeight = 150.0f;
            }
            this.setDataCellDimensions(dataCellWidth, dataCellHeight);
            int numStickyCol = a.getInt(R.styleable.SpreadsheetView_stickyColumns, -1);
            if (numStickyCol != -1) {
                this.setNumberStickyColumns(numStickyCol);
            }
            boolean setBorders = false;
            float horizontalCellBorderWidth = a.getDimensionPixelSize(R.styleable.SpreadsheetView_cellHorizontalBorderWidth, -1);
            float verticalCellBorderWidth = a.getDimensionPixelSize(R.styleable.SpreadsheetView_cellVerticalBorderWidth, -1);
            if (verticalCellBorderWidth != -1.0f || horizontalCellBorderWidth != -1.0f) {
                setBorders = true;
            }
            if (horizontalCellBorderWidth == -1.0f) {
                horizontalCellBorderWidth = 0.0f;
            }
            if (verticalCellBorderWidth == -1.0f) {
                verticalCellBorderWidth = 0.0f;
            }
            if (setBorders) {
                this.setAllCellsBorderWidth(horizontalCellBorderWidth, verticalCellBorderWidth);
            }
            a.recycle();
        }
    }

    private void defaultCells() {
        Paint stickyColumnPaint = new Paint();
        stickyColumnPaint.setColor(-12303292);
        stickyColumnPaint.setStyle(Paint.Style.FILL);
        Paint stickyColumnTextPaint = new Paint();
        stickyColumnTextPaint.setTextAlign(Paint.Align.CENTER);
        stickyColumnTextPaint.setStyle(Paint.Style.FILL);
        stickyColumnTextPaint.setColor(-1);
        Paint stickyColumnBorderPaint = new Paint();
        stickyColumnBorderPaint.setStyle(Paint.Style.FILL);
        stickyColumnBorderPaint.setColor(-16777216);
        Paint stickyHeaderPaint = new Paint(stickyColumnPaint);
        Paint stickyHeaderTextPaint = new Paint(stickyColumnTextPaint);
        Paint stickyHeaderBorderPaint = new Paint(stickyColumnBorderPaint);
        Paint stickyFooterPaint = new Paint(stickyColumnPaint);
        Paint stickyFooterTextPaint = new Paint(stickyColumnTextPaint);
        Paint stickyFooterBorderPaint = new Paint(stickyColumnBorderPaint);
        Paint leftHeadCornerPaint = new Paint(stickyColumnPaint);
        Paint leftHeadCornerBorderPaint = new Paint(stickyColumnBorderPaint);
        Paint leftHeadCornerTextPaint = new Paint(stickyColumnTextPaint);
        Paint leftFootCornerPaint = new Paint(leftHeadCornerPaint);
        Paint leftFootCornerBorderPaint = new Paint(leftHeadCornerBorderPaint);
        Paint leftFootCornerTextPaint = new Paint(leftHeadCornerTextPaint);
        Paint borderPaint = new Paint();
        borderPaint.setColor(-16777216);
        borderPaint.setStyle(Paint.Style.FILL);
        this.vertDividingPaint = new Paint(borderPaint);
        this.horzDividingPaint = new Paint(borderPaint);
        this.vertDividingPaint.setStyle(Paint.Style.STROKE);
        this.vertDividingPaint.setStrokeWidth(4.0f);
        this.horzDividingPaint.setStyle(Paint.Style.STROKE);
        this.horzDividingPaint.setStrokeWidth(4.0f);
        Paint cellPaint = new Paint();
        cellPaint.setColor(-3355444);
        cellPaint.setStyle(Paint.Style.FILL);
        Paint cellTextPaint = new Paint();
        cellTextPaint.setColor(-16776961);
        cellTextPaint.setStyle(Paint.Style.FILL);
        Paint cellBorderPaint = new Paint(stickyColumnBorderPaint);
        SpreadsheetCell stickyColumnCell = new SpreadsheetCell(this, stickyColumnPaint, stickyColumnTextPaint, stickyColumnBorderPaint, 0.0f, 0.0f);
        stickyColumnCell.getSelectedTextPaint().setFakeBoldText(true);
        SpreadsheetCell stickyHeaderCell = new SpreadsheetCell(this, stickyHeaderPaint, stickyHeaderTextPaint, stickyHeaderBorderPaint, 0.0f, 0.0f);
        stickyHeaderCell.getSelectedTextPaint().setFakeBoldText(true);
        SpreadsheetCell stickyFooterCell = new SpreadsheetCell(this, stickyFooterPaint, stickyFooterTextPaint, stickyFooterBorderPaint, 0.0f, 0.0f);
        stickyFooterCell.getSelectedTextPaint().setFakeBoldText(true);
        SpreadsheetCell dataCell = new SpreadsheetCell(this, cellPaint, cellTextPaint, cellBorderPaint, 0.0f, 0.0f);
        dataCell.getSelectedCellPaint().setColor(-256);
        dataCell.getSelectedTextPaint().setFakeBoldText(true);
        SpreadsheetCell leftHeadCornerCell = new SpreadsheetCell(this, leftHeadCornerPaint, leftHeadCornerTextPaint, leftHeadCornerBorderPaint, 0.0f, 0.0f);
        leftHeadCornerCell.getSelectedTextPaint().setFakeBoldText(true);
        SpreadsheetCell leftFootCornerCell = new SpreadsheetCell(this, leftFootCornerPaint, leftFootCornerTextPaint, leftFootCornerBorderPaint, 0.0f, 0.0f);
        leftFootCornerCell.getSelectedTextPaint().setFakeBoldText(true);
        this.setStickyHeaderCell(stickyHeaderCell);
        this.setStickyFooterCell(stickyFooterCell);
        this.setStickyColumnCell(stickyColumnCell);
        this.setLeftFootCornerCell(leftFootCornerCell);
        this.setLeftHeadCornerCell(leftHeadCornerCell);
        this.setDataCell(dataCell);
    }

    private void defaultDimensions() {
        this.stickyColumnWidths = new float[1];
        this.setNumberStickyColumns(1);
        this.headers = new String[1];
        this.headers[0] = "EMPTY";
        this.headerSelected = new boolean[1];
        this.footerSelected = new boolean[1];
        this.footers = new String[1];
        this.footers[0] = "EMPTY";
        this.dataSizeValues = 1;
        this.dataSizeObjects = 0;
        this.sorted = new int[1];
        this.sorted[0] = 0;
        this.setStickyColumnWidth(0, 150.0f);
        this.setDataCellDimensions(150.0f, 150.0f);
        this.setStickyHeaderHeight(100.0f);
        this.setStickyFooterHeight(0.0f);
        this.setAllCellsTextSize(32.0f);
    }

    private void init(Context context) {
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.scroller = new Scroller(context);
        this.windowScrollX = 0.0f;
        this.windowScrollY = 0.0f;
        this.dataSet = false;
    }

    protected void onSizeChanged(int width, int height, int oldwidth, int oldheight) {
        this.stickyTableWidth = width;
        this.stickyTableHeight = height;
        this.adjustTable();
        super.onSizeChanged(width, height, oldwidth, oldheight);
    }

    private void adjustTable() {
        this.activeDataWindowHeight = this.stickyTableHeight - this.stickyHeaderHeight - this.stickyFooterHeight;
        this.activeDataWindowWidth = this.stickyTableWidth - this.stickyColumnWidth;
        this.fitCellWidthToFill();
        this.maxWindowScrollX = (float)(this.dataSizeValues - this.numberStickyColumns) * this.dataCellWidth - this.activeDataWindowWidth;
        if (this.maxWindowScrollX < 0.0f) {
            this.maxWindowScrollX = 0.0f;
        }
        this.maxWindowScrollY = (float)this.dataSizeObjects * this.dataCellHeight - this.activeDataWindowHeight;
        if (this.maxWindowScrollY < 0.0f) {
            this.maxWindowScrollY = 0.0f;
        }
        this.scroll(0.0f, 0.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        super.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                this.scrollStartX = event.getX();
                this.scrollStartY = event.getY();
                break;
            }
            case 2: {
                float x = event.getX();
                float y = event.getY();
                float scrollByX = x - this.scrollStartX;
                float scrollByY = y - this.scrollStartY;
                this.scrollStartX = x;
                this.scrollStartY = y;
                this.scroll(scrollByX * -1.0f, scrollByY * -1.0f);
            }
        }
        return true;
    }

    private void processClick(float x, float y) {
        if (y < this.stickyHeaderHeight) {
            if (this.headerListener != null) {
                this.headerListener.headerClick(this.getValueDataCellIndex(x));
                this.invalidate();
            }
        } else if (y < this.stickyHeaderHeight + this.activeDataWindowHeight) {
            if (this.cellListener != null) {
                this.cellListener.cellClick(this.getObjectDataCellIndex(y), this.getValueDataCellIndex(x));
                this.invalidate();
            }
        } else if (x < this.stickyTableWidth && y < this.stickyTableHeight && this.footerListener != null) {
            this.footerListener.footerClick(this.getValueDataCellIndex(x));
            this.invalidate();
        }
    }

    public void setFooterChangedListener(OnFooterChangedListener listener) {
        this.footerChangedListener = listener;
    }

    public void setOnHeaderClickListener(OnHeaderClickListener listener) {
        this.headerListener = listener;
    }

    public void setOnFooterClickListener(OnFooterClickListener listener) {
        this.footerListener = listener;
    }

    public void setOnCellClickListener(OnCellClickListener listener) {
        this.cellListener = listener;
    }

    public void sortDataAscBy(int valueIndex, Comparator<SpreadsheetRow> comparator) {
        Arrays.sort(this.objectData, comparator);
        for (int i = 0; i < this.dataSizeValues; ++i) {
            this.sorted[i] = 0;
        }
        this.sorted[valueIndex] = 1;
    }

    public void sortDataDescBy(int valueIndex, Comparator<SpreadsheetRow> comparator) {
        Arrays.sort(this.objectData, comparator);
        for (int i = 0; i < this.dataSizeValues; ++i) {
            this.sorted[i] = 0;
        }
        this.sorted[valueIndex] = 2;
    }

    private int getValueDataCellIndex(float x) {
        if (x < this.stickyColumnWidth) {
            float widthSearched = 0.0f;
            for (int i = 0; i < this.numberStickyColumns; ++i) {
                if (!(x < (widthSearched += this.stickyColumnWidths[i]))) continue;
                return i;
            }
        }
        int startValuesIndex = this.windowScrollX == 0.0f ? this.numberStickyColumns : (int)((float)this.numberStickyColumns + this.windowScrollX / this.dataCellWidth);
        float xOffset = this.windowScrollX % this.dataCellWidth;
        float xInto = x - this.stickyColumnWidth;
        int indexOffsetX = (int)((xInto + xOffset) / this.dataCellWidth);
        return indexOffsetX + startValuesIndex;
    }

    private int getObjectDataCellIndex(float y) {
        int startObjectsIndex = this.windowScrollY == 0.0f ? 0 : (int)(this.windowScrollY / this.dataCellHeight);
        float yOffset = this.windowScrollY % this.dataCellHeight;
        float yInto = y - this.stickyHeaderHeight;
        int indexOffsetY = (int)((yInto + yOffset) / this.dataCellHeight);
        return indexOffsetY + startObjectsIndex;
    }

    public void setData(SpreadsheetRow[] data, String[] headers) {
        this.objectData = data;
        this.headers = headers;
        this.footers = new String[headers.length];
        this.sorted = new int[headers.length];
        this.headerSelected = new boolean[headers.length];
        this.footerSelected = new boolean[headers.length];
        if (headers.length > this.stickyColumnWidths.length) {
            float[] tempArray = new float[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                tempArray[i] = i < this.stickyColumnWidths.length ? this.stickyColumnWidths[i] : this.dataCellWidth;
            }
            this.stickyColumnWidths = tempArray;
            this.dataSet = true;
        }
        this.dataSizeObjects = data.length;
        this.dataSizeValues = headers.length;
        for (int i = 0; i < this.dataSizeValues; ++i) {
            this.footers[i] = "";
            this.updateFooter(i);
            this.sorted[i] = 0;
        }
        this.setNumberStickyColumns(this.targetNumberStickyColumns);
    }

    public void setDataAt(int objectIndex, int valueIndex, String data) {
        this.getRowAt(objectIndex).setValue(valueIndex, data);
    }

    public String getDataAt(int objectIndex, int valueIndex) {
        return this.getRowAt(objectIndex).getValueAt(valueIndex);
    }

    public void setValuesColumn(int headerIndex, String[] column) {
        for (int i = 0; i < this.dataSizeObjects; ++i) {
            this.objectData[i].setValue(headerIndex, column[i]);
        }
        this.updateFooter(headerIndex);
    }

    public void setFooters(String[] footers, float height) {
        this.footers = footers;
        this.setStickyFooterHeight(height);
    }

    public void setRow(int objectIndex, String[] row) {
        int i;
        for (i = 0; i < this.dataSizeValues; ++i) {
            this.objectData[objectIndex].setValue(objectIndex, row[i]);
        }
        for (i = 0; i < this.dataSizeValues; ++i) {
            this.updateFooter(i);
        }
    }

    public void setRow(int objectIndex, SpreadsheetRow row) {
        this.objectData[objectIndex] = row;
        for (int i = 0; i < this.dataSizeValues; ++i) {
            this.updateFooter(i);
        }
    }

    public SpreadsheetRow getRowAt(int objectIndex) {
        return this.objectData[objectIndex];
    }

    public String getFooterAt(int valueIndex) {
        return this.footers[valueIndex];
    }

    public String getHeaderAt(int valueIndex) {
        return this.headers[valueIndex];
    }

    public int getNumberObjects() {
        return this.dataSizeObjects;
    }

    private void updateFooter(int valueIndex) {
        if (this.footerChangedListener != null) {
            this.footerChangedListener.updateFooter(valueIndex);
        }
    }

    public void scroll(float x, float y) {
        this.windowScrollX += x;
        if (this.windowScrollX < 0.0f) {
            this.windowScrollX = 0.0f;
        }
        if (this.windowScrollX >= this.maxWindowScrollX) {
            this.windowScrollX = this.maxWindowScrollX;
        }
        this.windowScrollY += y;
        if (this.windowScrollY < 0.0f) {
            this.windowScrollY = 0.0f;
        }
        if (this.windowScrollY >= this.maxWindowScrollY) {
            this.windowScrollY = this.maxWindowScrollY;
        }
        this.invalidate();
    }

    private void fitCellWidthToFill() {
        int numDataCells = this.getNumberNonStickyColumns();
        if (numDataCells == 0) {
            return;
        }
        if (this.getTotalStickyColumnsWidth() + (float)numDataCells * this.getDataCellWidth() < this.getStickyTableWidth()) {
            float dataWindowWidth = this.getStickyTableWidth() - this.getTotalStickyColumnsWidth();
            this.setDataCellDimensions(dataWindowWidth / (float)numDataCells, this.getDataCellHeight());
        }
    }

    public void selectRow(int objectIndex, boolean select) {
        this.objectData[objectIndex].selectRow(select);
    }

    public void selectColumn(int valueIndex, boolean select) {
        for (int i = 0; i < this.dataSizeObjects; ++i) {
            this.objectData[i].select(valueIndex, select);
        }
        this.selectHeader(valueIndex, select);
        this.selectFooter(valueIndex, select);
    }

    public void select(int objectIndex, int valueIndex, boolean select) {
        this.objectData[objectIndex].select(valueIndex, select);
    }

    public void selectFooter(int valueIndex, boolean select) {
        this.footerSelected[valueIndex] = select;
    }

    public void selectHeader(int valueIndex, boolean select) {
        this.headerSelected[valueIndex] = select;
    }

    public boolean isFooterSelected(int valueIndex) {
        return this.footerSelected[valueIndex];
    }

    public boolean isHeaderSelected(int valueIndex) {
        return this.headerSelected[valueIndex];
    }

    public boolean isSelected(int objectIndex, int valueIndex) {
        return this.objectData[objectIndex].isSelected(valueIndex);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.dataSet) {
            return;
        }
        if (this.scroller.computeScrollOffset()) {
            this.scroll((float)this.scroller.getCurrX() - this.windowScrollX, (float)this.scroller.getCurrY() - this.windowScrollY);
        }
        this.drawDataCells(canvas);
        this.drawStickyColumn(canvas);
        this.drawStickyHeader(canvas);
        this.drawStickyFooter(canvas);
        this.drawCornerCells(canvas);
        canvas.drawLine(this.stickyColumnWidth, 0.0f, this.stickyColumnWidth, this.stickyTableHeight, this.vertDividingPaint);
        canvas.drawLine(0.0f, this.stickyHeaderHeight, this.stickyTableWidth, this.stickyHeaderHeight, this.horzDividingPaint);
        canvas.drawLine(0.0f, this.stickyTableHeight - this.stickyFooterHeight, this.stickyTableWidth, this.stickyTableHeight - this.stickyFooterHeight, this.horzDividingPaint);
    }

    private void drawCornerCells(Canvas canvas) {
        int i;
        float leftX = 0.0f;
        float topY = 0.0f;
        if (this.headers != null) {
            for (i = 0; i < this.numberStickyColumns; ++i) {
                if (this.leftHeadCornerCell != null && this.stickyHeaderHeight > 0.0f && this.stickyColumnWidths[i] > 0.0f) {
                    this.leftHeadCornerCell.draw(canvas, this.headers[i], leftX, topY, this.stickyColumnWidths[i], this.stickyHeaderHeight, this.isHeaderSelected(i));
                }
                leftX += this.stickyColumnWidths[i];
            }
        }
        if (this.footers != null) {
            leftX = 0.0f;
            topY = 0.0f + this.stickyHeaderHeight + this.activeDataWindowHeight;
            for (i = 0; i < this.numberStickyColumns; ++i) {
                if (this.leftFootCornerCell != null && this.stickyFooterHeight > 0.0f && this.stickyColumnWidths[i] > 0.0f) {
                    this.leftFootCornerCell.draw(canvas, this.footers[i], leftX, topY, this.stickyColumnWidths[i], this.stickyFooterHeight, this.isFooterSelected(i));
                }
                leftX += this.stickyColumnWidths[i];
            }
        }
    }

    protected void drawStickyColumn(Canvas canvas) {
        if (this.dataCellHeight == 0.0f || this.stickyColumnWidth == 0.0f || this.stickyColumnCell == null || this.objectData == null) {
            return;
        }
        int startIndex = this.windowScrollY == 0.0f ? 0 : (int)(this.windowScrollY / this.dataCellHeight);
        float yOffset = this.windowScrollY % this.dataCellHeight;
        int numberCellsDown = (int)(this.activeDataWindowHeight / this.dataCellHeight + 2.0f);
        if (numberCellsDown + startIndex > this.dataSizeObjects) {
            numberCellsDown = this.dataSizeObjects - startIndex;
        }
        float currentLeftX = 0.0f;
        for (int i = 0; i < this.numberStickyColumns; ++i) {
            for (int j = 0; j < numberCellsDown; ++j) {
                float topY = this.stickyHeaderHeight + (float)j * this.dataCellHeight - yOffset;
                if (!(topY < this.stickyHeaderHeight + this.activeDataWindowHeight) || this.objectData[startIndex + j] == null) continue;
                this.stickyColumnCell.draw(canvas, this.objectData[startIndex + j].getValueAt(i), currentLeftX, topY, this.stickyColumnWidths[i], this.dataCellHeight, this.objectData[startIndex + j].isSelected(i));
            }
            currentLeftX += this.stickyColumnWidths[i];
        }
    }

    protected void drawStickyHeader(Canvas canvas) {
        if (this.dataCellWidth == 0.0f || this.stickyHeaderHeight == 0.0f || this.stickyHeaderCell == null || this.headers == null) {
            return;
        }
        int startIndex = this.windowScrollX == 0.0f ? this.numberStickyColumns : (int)((float)this.numberStickyColumns + this.windowScrollX / this.dataCellWidth);
        float xOffset = this.windowScrollX % this.dataCellWidth;
        int numberCellsAcross = (int)(this.activeDataWindowWidth / this.dataCellWidth + 2.0f);
        if (numberCellsAcross + startIndex > this.dataSizeValues) {
            numberCellsAcross = this.dataSizeValues - startIndex;
        }
        for (int i = 0; i < numberCellsAcross; ++i) {
            float leftX = this.stickyColumnWidth + (float)i * this.dataCellWidth - xOffset;
            float topY = 0.0f;
            if (!(leftX < this.stickyColumnWidth + this.activeDataWindowWidth)) continue;
            this.stickyHeaderCell.draw(canvas, this.headers[startIndex + i], leftX, topY, this.dataCellWidth, this.stickyHeaderHeight, this.isHeaderSelected(startIndex + i));
        }
    }

    protected void drawStickyFooter(Canvas canvas) {
        if (this.dataCellWidth <= 0.0f || this.stickyFooterHeight <= 0.0f || this.stickyFooterCell == null || this.footers == null) {
            return;
        }
        int startIndex = this.windowScrollX == 0.0f ? this.numberStickyColumns : (int)((float)this.numberStickyColumns + this.windowScrollX / this.dataCellWidth);
        float xOffset = this.windowScrollX % this.dataCellWidth;
        int numberCellsAcross = (int)(this.activeDataWindowWidth / this.dataCellWidth + 2.0f);
        if (numberCellsAcross + startIndex > this.dataSizeValues) {
            numberCellsAcross = this.dataSizeValues - startIndex;
        }
        for (int i = 0; i < numberCellsAcross; ++i) {
            float leftX = this.stickyColumnWidth + (float)i * this.dataCellWidth - xOffset;
            float topY = this.stickyHeaderHeight + this.activeDataWindowHeight;
            if (!(leftX < this.stickyColumnWidth + this.activeDataWindowWidth)) continue;
            this.stickyFooterCell.draw(canvas, "" + this.footers[startIndex + i], leftX, topY, this.dataCellWidth, this.stickyFooterHeight, this.isFooterSelected(startIndex + i));
        }
    }

    private void drawDataCells(Canvas canvas) {
        int numberCellsAcross;
        if (this.dataCellWidth == 0.0f || this.dataCellHeight == 0.0f || this.dataCell == null || this.objectData == null) {
            return;
        }
        int startValuesIndex = this.windowScrollX == 0.0f ? this.numberStickyColumns : (int)((float)this.numberStickyColumns + this.windowScrollX / this.dataCellWidth);
        float xOffset = this.windowScrollX % this.dataCellWidth;
        int startObjectsIndex = this.windowScrollY == 0.0f ? 0 : (int)(this.windowScrollY / this.dataCellHeight);
        float yOffset = this.windowScrollY % this.dataCellHeight;
        int numberCellsDown = (int)(this.activeDataWindowHeight / this.dataCellHeight + 2.0f);
        if (numberCellsDown + startObjectsIndex > this.dataSizeObjects) {
            numberCellsDown = this.dataSizeObjects - startObjectsIndex;
        }
        if ((numberCellsAcross = (int)(this.activeDataWindowWidth / this.dataCellWidth + 2.0f)) + startValuesIndex > this.dataSizeValues) {
            numberCellsAcross = this.dataSizeValues - startValuesIndex;
        }
        for (int i = 0; i < numberCellsAcross; ++i) {
            for (int j = 0; j < numberCellsDown; ++j) {
                float leftX = this.stickyColumnWidth + (float)i * this.dataCellWidth - xOffset;
                float topY = this.stickyHeaderHeight + (float)j * this.dataCellHeight - yOffset;
                if (!(leftX < this.stickyColumnWidth + this.activeDataWindowWidth) || !(topY < this.stickyHeaderHeight + this.activeDataWindowHeight) || this.objectData[startObjectsIndex + j] == null) continue;
                this.dataCell.draw(canvas, "" + this.objectData[startObjectsIndex + j].getValueAt(startValuesIndex + i), leftX, topY, this.dataCellWidth, this.dataCellHeight, this.objectData[startObjectsIndex + j].isSelected(startValuesIndex + i));
            }
        }
    }

    public float getStickyTableWidth() {
        float width = this.stickyColumnWidth + this.activeDataWindowWidth;
        return width;
    }

    public float getStickyTableHeight() {
        float height = this.stickyHeaderHeight + this.activeDataWindowHeight + this.stickyFooterHeight;
        return height;
    }

    public boolean onDown(MotionEvent e) {
        if (!this.scroller.isFinished()) {
            this.scroller.forceFinished(true);
        }
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.processClick(e.getX(), e.getY());
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        int velX = (int)(velocityX / -2.0f);
        int velY = (int)(velocityY / -2.0f);
        this.scroller.fling((int)this.windowScrollX, (int)this.windowScrollY, velX, velY, 0, (int)this.maxWindowScrollX, 0, (int)this.maxWindowScrollY);
        this.postInvalidate();
        return false;
    }

    public int getTotalNumberColumns() {
        return this.dataSizeValues;
    }

    public int getNumberNonStickyColumns() {
        return this.dataSizeValues - this.numberStickyColumns;
    }

    public float getTotalStickyColumnsWidth() {
        return this.stickyColumnWidth;
    }

    public void setStickyColumnWidth(int columnIndex, float width) {
        if (this.stickyColumnWidths == null || columnIndex + 1 > this.stickyColumnWidths.length) {
            return;
        }
        this.stickyColumnWidths[columnIndex] = width;
        this.calculateStickyColumnWidth();
        this.adjustTable();
    }

    public float getStickyColumnWidth(int columnIndex) {
        if (columnIndex + 1 > this.stickyColumnWidths.length) {
            return 0.0f;
        }
        return this.stickyColumnWidths[columnIndex];
    }

    public void setNumberStickyColumns(int number) {
        this.targetNumberStickyColumns = number;
        if (number > this.dataSizeValues) {
            number = this.dataSizeValues;
        }
        if (number < 0) {
            number = 0;
        }
        this.numberStickyColumns = number;
        this.calculateStickyColumnWidth();
        this.adjustTable();
    }

    public int getNumberStickyColumns() {
        return this.numberStickyColumns;
    }

    public void incStickyColumnWidth(int columnIndex, float dw) {
        int n = columnIndex;
        this.stickyColumnWidths[n] = this.stickyColumnWidths[n] + dw;
        this.calculateStickyColumnWidth();
        this.adjustTable();
    }

    private void calculateStickyColumnWidth() {
        float sum = 0.0f;
        for (int i = 0; i < this.numberStickyColumns; ++i) {
            sum += this.getStickyColumnWidth(i);
        }
        this.stickyColumnWidth = sum;
    }

    public void setStickyHeaderTextSize(float size) {
        this.stickyHeaderCell.setTextSize(size);
    }

    public float getStickyHeaderTextSize() {
        return this.stickyHeaderCell.getTextPaint().getTextSize();
    }

    public void setStickyFooterTextSize(float size) {
        this.stickyFooterCell.setTextSize(size);
    }

    public float getStickyFooterTextSize() {
        return this.stickyFooterCell.getTextPaint().getTextSize();
    }

    public void setStickyColumnTextSize(float size) {
        this.stickyColumnCell.setTextSize(size);
    }

    public float getStickyColumnTextSize() {
        return this.stickyColumnCell.getTextPaint().getTextSize();
    }

    public void setDataCellTextSize(float size) {
        this.dataCell.setTextSize(size);
    }

    public float getDataCellTextSize() {
        return this.dataCell.getTextPaint().getTextSize();
    }

    public void incStickyHeaderHeight(float dh) {
        this.stickyHeaderHeight += dh;
        this.adjustTable();
    }

    public void setStickyHeaderHeight(float height) {
        this.stickyHeaderHeight = height;
        this.adjustTable();
    }

    public float getStickyHeaderHeight() {
        return this.stickyHeaderHeight;
    }

    public void hideStickyFooter() {
        this.setStickyFooterHeight(0.0f);
    }

    public void showStickyFooter(float height) {
        this.setStickyFooterHeight(height);
    }

    public void setStickyFooterHeight(float height) {
        this.stickyFooterHeight = height;
        this.adjustTable();
    }

    public float getStickyFooterHeight() {
        return this.stickyFooterHeight;
    }

    public void incStickyFooterHeight(float dh) {
        this.stickyFooterHeight += dh;
        this.adjustTable();
    }

    public void setDataCellDimensions(float width, float height) {
        this.dataCellWidth = width;
        this.dataCellHeight = height;
        this.adjustTable();
    }

    public float getDataCellWidth() {
        return this.dataCellWidth;
    }

    public float getDataCellHeight() {
        return this.dataCellHeight;
    }

    public void setAllCellsTextSize(float textSize) {
        this.stickyColumnCell.setTextSize(textSize);
        this.stickyHeaderCell.setTextSize(textSize);
        this.stickyFooterCell.setTextSize(textSize);
        this.dataCell.setTextSize(textSize);
        this.leftHeadCornerCell.setTextSize(textSize);
        this.leftFootCornerCell.setTextSize(textSize);
        this.stickyColumnCell.setSelectedTextSize(textSize);
        this.stickyHeaderCell.setSelectedTextSize(textSize);
        this.stickyFooterCell.setSelectedTextSize(textSize);
        this.dataCell.setSelectedTextSize(textSize);
        this.leftHeadCornerCell.setSelectedTextSize(textSize);
        this.leftFootCornerCell.setSelectedTextSize(textSize);
    }

    public void setAllCellsBorderWidth(float horizontalWidth, float verticalWidth) {
        this.stickyColumnCell.setHorizontalBorderWidth(horizontalWidth);
        this.stickyHeaderCell.setHorizontalBorderWidth(horizontalWidth);
        this.stickyFooterCell.setHorizontalBorderWidth(horizontalWidth);
        this.dataCell.setHorizontalBorderWidth(horizontalWidth);
        this.leftHeadCornerCell.setHorizontalBorderWidth(horizontalWidth);
        this.leftFootCornerCell.setHorizontalBorderWidth(horizontalWidth);
        this.stickyColumnCell.setVerticalBorderWidth(verticalWidth);
        this.stickyHeaderCell.setVerticalBorderWidth(verticalWidth);
        this.stickyFooterCell.setVerticalBorderWidth(verticalWidth);
        this.dataCell.setVerticalBorderWidth(verticalWidth);
        this.leftHeadCornerCell.setVerticalBorderWidth(verticalWidth);
        this.leftFootCornerCell.setVerticalBorderWidth(verticalWidth);
    }

    public void setAllCellsTextColor(int color) {
        this.stickyColumnCell.setTextColor(color);
        this.stickyHeaderCell.setTextColor(color);
        this.stickyFooterCell.setTextColor(color);
        this.dataCell.setTextColor(color);
        this.leftHeadCornerCell.setTextColor(color);
        this.leftFootCornerCell.setTextColor(color);
    }

    public void setAllCellsSelectedTextColor(int color) {
        this.stickyColumnCell.setSelectedTextColor(color);
        this.stickyHeaderCell.setSelectedTextColor(color);
        this.stickyFooterCell.setSelectedTextColor(color);
        this.dataCell.setSelectedTextColor(color);
        this.leftHeadCornerCell.setSelectedTextColor(color);
        this.leftFootCornerCell.setSelectedTextColor(color);
    }

    public void setAllCellsTypeface(Typeface typeface) {
        this.stickyColumnCell.setTypeface(typeface);
        this.stickyHeaderCell.setTypeface(typeface);
        this.stickyFooterCell.setTypeface(typeface);
        this.dataCell.setTypeface(typeface);
        this.leftHeadCornerCell.setTypeface(typeface);
        this.leftFootCornerCell.setTypeface(typeface);
        this.stickyColumnCell.setSelectedTypeface(typeface);
        this.stickyHeaderCell.setSelectedTypeface(typeface);
        this.stickyFooterCell.setSelectedTypeface(typeface);
        this.dataCell.setSelectedTypeface(typeface);
        this.leftHeadCornerCell.setSelectedTypeface(typeface);
        this.leftFootCornerCell.setSelectedTypeface(typeface);
    }

    public void setLeftFootCornerCell(SpreadsheetCell cell) {
        this.leftFootCornerCell = cell;
    }

    public SpreadsheetCell getLeftFootCornerCell() {
        return this.leftFootCornerCell;
    }

    public void setLeftFootCornerCellTypeface(Typeface typeface) {
        this.leftFootCornerCell.setTypeface(typeface);
    }

    public Typeface getLeftFootCornerCellTypeface() {
        return this.leftFootCornerCell.getTypeface();
    }

    public void setLeftFootCornerCellTextColor(int color) {
        this.leftFootCornerCell.setTextColor(color);
    }

    public int getLeftFootCornerCellTextColor() {
        return this.leftFootCornerCell.getTextColor();
    }

    public void setLeftHeadCornerCell(SpreadsheetCell cell) {
        this.leftHeadCornerCell = cell;
    }

    public SpreadsheetCell getLeftHeadCornerCell() {
        return this.leftHeadCornerCell;
    }

    public void setLeftHeadCornerCellTypeface(Typeface typeface) {
        this.leftHeadCornerCell.setTypeface(typeface);
    }

    public Typeface getLeftHeadCornerCellTypeface() {
        return this.leftHeadCornerCell.getTypeface();
    }

    public void setLeftHeadCornerCellTextColor(int color) {
        this.leftHeadCornerCell.setTextColor(color);
    }

    public int getLeftHeadCornerCellTextColor() {
        return this.leftHeadCornerCell.getTextColor();
    }

    public void setDataCell(SpreadsheetCell cell) {
        this.dataCell = cell;
    }

    public SpreadsheetCell getDataCell() {
        return this.dataCell;
    }

    public void setDataCellTypeface(Typeface typeface) {
        this.dataCell.setTypeface(typeface);
    }

    public Typeface getDataCellTypeface() {
        return this.dataCell.getTypeface();
    }

    public void setDataCellTextColor(int color) {
        this.dataCell.setTextColor(color);
    }

    public int getDataCellTextColor() {
        return this.dataCell.getTextColor();
    }

    public void setStickyColumnCell(SpreadsheetCell cell) {
        this.stickyColumnCell = cell;
    }

    public SpreadsheetCell getStickyColumnCell() {
        return this.stickyColumnCell;
    }

    public void setStickyColumnCellTypeface(Typeface typeface) {
        this.stickyColumnCell.setTypeface(typeface);
    }

    public Typeface getStickyColumnCellTypeface() {
        return this.stickyColumnCell.getTypeface();
    }

    public void setStickyColumnCellTextColor(int color) {
        this.stickyColumnCell.setTextColor(color);
    }

    public int getStickyColumnCellTextColor() {
        return this.stickyColumnCell.getTextColor();
    }

    public void setStickyHeaderCell(SpreadsheetCell cell) {
        this.stickyHeaderCell = cell;
    }

    public SpreadsheetCell getStickyHeaderCell() {
        return this.stickyHeaderCell;
    }

    public void setStickyHeaderCellTypeface(Typeface typeface) {
        this.stickyHeaderCell.setTypeface(typeface);
    }

    public Typeface getStickyHeaderCellTypeface() {
        return this.stickyHeaderCell.getTypeface();
    }

    public void setStickyHeaderCellTextColor(int color) {
        this.stickyHeaderCell.setTextColor(color);
    }

    public int getStickyHeaderCellTextColor() {
        return this.stickyHeaderCell.getTextColor();
    }

    public void setStickyFooterCell(SpreadsheetCell cell) {
        this.stickyFooterCell = cell;
    }

    public SpreadsheetCell getStickyFooterCell() {
        return this.stickyFooterCell;
    }

    public void setStickyFooterCellTypeface(Typeface typeface) {
        this.stickyFooterCell.setTypeface(typeface);
    }

    public void setStickyFooterCellTextColor(int color) {
        this.stickyFooterCell.setTextColor(color);
    }

    public int getStickyFooterCellTextColor() {
        return this.stickyFooterCell.getTextColor();
    }

    public void setHorizontalDividingPaint(Paint paint) {
        this.horzDividingPaint = paint;
    }

    public Paint getHorizontalDividingPaint() {
        return this.horzDividingPaint;
    }

    public void setVerticalDividingPaint(Paint paint) {
        this.vertDividingPaint = paint;
    }

    public Paint getVerticalDividingPaint() {
        return this.vertDividingPaint;
    }

    public int getSortedStatus(int valueIndex) {
        return this.sorted[valueIndex];
    }

    public static interface OnCellClickListener {
        public void cellClick(int var1, int var2);
    }

    public static interface OnFooterClickListener {
        public void footerClick(int var1);
    }

    public static interface OnHeaderClickListener {
        public void headerClick(int var1);
    }

    public static interface OnFooterChangedListener {
        public void updateFooter(int var1);
    }
}

