/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import oak.R;

public class ResizableHeaderScrollView
extends FrameLayout {
    private static final int SPACE_ID = 1001;
    private static final int SCROLLVIEW_ID = 1002;
    private static final int NOT_SPECIFIED = -1;
    private SyncedScrollView scrollView;
    private View headerFrame;
    private View header;
    private boolean headerCentered;
    private boolean headerCollapsed;
    private int minHeaderHeight;
    private int maxHeaderHeight;
    private int headerFlipScrollThreshold;
    private HeaderChangeListener headerListener;

    public ResizableHeaderScrollView(Context context, int minHeaderHeight, int maxHeaderHeight, int headerResId, int scrollViewLayoutId, int headerFlipScrollThreshold, boolean headerCentered) {
        super(context);
        this.headerCentered = headerCentered;
        this.init(minHeaderHeight, maxHeaderHeight, headerResId, scrollViewLayoutId, headerFlipScrollThreshold, -1);
    }

    public ResizableHeaderScrollView(Context context, AttributeSet attr2) {
        super(context, attr2);
        this.parseAttributes(attr2);
    }

    public ResizableHeaderScrollView(Context context, AttributeSet attr2, int defInStyles) {
        super(context, attr2, defInStyles);
        this.parseAttributes(attr2);
    }

    private void parseAttributes(AttributeSet attr2) {
        TypedArray a;
        if (attr2 != null && (a = this.getContext().getTheme().obtainStyledAttributes(attr2, R.styleable.ResizableHeaderScrollView, 0, 0)) != null) {
            this.headerCentered = a.getBoolean(R.styleable.ResizableHeaderScrollView_headerCentered, false);
            this.minHeaderHeight = a.getDimensionPixelSize(R.styleable.ResizableHeaderScrollView_minHeaderHeight, -1);
            this.maxHeaderHeight = a.getDimensionPixelSize(R.styleable.ResizableHeaderScrollView_maxHeaderHeight, -1);
            this.headerFlipScrollThreshold = a.getDimensionPixelSize(R.styleable.ResizableHeaderScrollView_headerChangeThreshold, -1);
            int headerBackground = a.getResourceId(R.styleable.ResizableHeaderScrollView_resizableHeaderBackground, -1);
            int scrollViewRes = a.getResourceId(R.styleable.ResizableHeaderScrollView_contentLayout, -1);
            int headerRes = a.getResourceId(R.styleable.ResizableHeaderScrollView_headerLayout, -1);
            this.init(this.minHeaderHeight, this.maxHeaderHeight, headerRes, scrollViewRes, this.headerFlipScrollThreshold, headerBackground);
            a.recycle();
            return;
        }
        this.init(-1, -1, -1, -1, -1, -1);
    }

    private int getContentScrolled() {
        if (this.scrollView.getScrollY() < 0) {
            return 0;
        }
        return this.scrollView.getScrollY();
    }

    public int getHeaderDelta() {
        return this.maxHeaderHeight - this.minHeaderHeight;
    }

    private void init(int minHeaderHeight, int maxHeaderHeight, int headerRes, int scrollViewLayoutId, int headerFlipThreshold, int headerBackground) {
        if (minHeaderHeight > maxHeaderHeight) {
            minHeaderHeight = maxHeaderHeight;
        } else if (maxHeaderHeight < minHeaderHeight) {
            minHeaderHeight = maxHeaderHeight;
        }
        this.minHeaderHeight = minHeaderHeight;
        this.maxHeaderHeight = maxHeaderHeight;
        this.headerFlipScrollThreshold = headerFlipThreshold;
        this.createHeader(headerRes, headerBackground);
        this.createScrollView(scrollViewLayoutId);
        if (headerBackground != -1) {
            this.setHeaderBackground(headerBackground);
        }
        this.scrollView.setOnScrollListener(new OnScrollListener(){

            @Override
            public void onScrollChanged(int x, int y, int oldx, int oldy) {
                if (!ResizableHeaderScrollView.this.headerChangeEnabled()) {
                    return;
                }
                if (ResizableHeaderScrollView.this.getContentScrolled() > ResizableHeaderScrollView.this.headerFlipScrollThreshold) {
                    if (ResizableHeaderScrollView.this.headerListener != null && !ResizableHeaderScrollView.this.headerCollapsed) {
                        ResizableHeaderScrollView.this.headerListener.collapse(ResizableHeaderScrollView.this.header);
                        ResizableHeaderScrollView.this.headerCollapsed = true;
                    }
                } else if (ResizableHeaderScrollView.this.getContentScrolled() < ResizableHeaderScrollView.this.headerFlipScrollThreshold && ResizableHeaderScrollView.this.headerListener != null && ResizableHeaderScrollView.this.headerCollapsed) {
                    ResizableHeaderScrollView.this.headerListener.expand(ResizableHeaderScrollView.this.header);
                    ResizableHeaderScrollView.this.headerCollapsed = false;
                }
                ResizableHeaderScrollView.this.adjustChildren();
            }
        });
        this.requestLayout();
    }

    public void setHeaderChangeListener(HeaderChangeListener listener) {
        this.headerListener = listener;
    }

    private void createScrollView(int scrollViewLayoutId) {
        RelativeLayout layout2 = new RelativeLayout(this.getContext());
        FrameLayout.LayoutParams relLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        layout2.setLayoutParams((ViewGroup.LayoutParams)relLayoutParams);
        this.addView((View)layout2);
        View space = new View(this.getContext());
        space.setId(1001);
        RelativeLayout.LayoutParams spaceParams = new RelativeLayout.LayoutParams(-1, this.minHeaderHeight != -1 ? this.minHeaderHeight : 0);
        spaceParams.addRule(12);
        space.setLayoutParams((ViewGroup.LayoutParams)spaceParams);
        layout2.addView(space);
        this.scrollView = new SyncedScrollView(this.getContext(), this);
        this.scrollView.setId(1002);
        RelativeLayout.LayoutParams scrollViewParams = new RelativeLayout.LayoutParams(-1, -1);
        scrollViewParams.addRule(2, space.getId());
        this.scrollView.setLayoutParams((ViewGroup.LayoutParams)scrollViewParams);
        LayoutInflater.from((Context)this.getContext()).inflate(scrollViewLayoutId, (ViewGroup)this.scrollView);
        layout2.addView((View)this.scrollView);
    }

    private void createHeader(int headerResId, int headerBackgroundId) {
        LinearLayout frame = new LinearLayout(this.getContext());
        if (headerBackgroundId != -1) {
            frame.setBackgroundResource(headerBackgroundId);
        }
        FrameLayout container = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams container_params = new FrameLayout.LayoutParams(-1, -1);
        container.setLayoutParams((ViewGroup.LayoutParams)container_params);
        LayoutInflater.from((Context)this.getContext()).inflate(headerResId, (ViewGroup)container);
        frame.addView((View)container);
        this.headerFrame = frame;
        this.header = container;
        this.addView(this.headerFrame);
        this.headerFrame.measure(0, 0);
        int measuredHeight = this.headerFrame.getMeasuredHeight();
        if (this.minHeaderHeight == -1 || this.minHeaderHeight < measuredHeight) {
            this.minHeaderHeight = measuredHeight;
        }
        if (this.maxHeaderHeight == -1 || this.maxHeaderHeight < measuredHeight) {
            this.maxHeaderHeight = measuredHeight;
        }
        if (this.minHeaderHeight > this.maxHeaderHeight) {
            this.minHeaderHeight = this.maxHeaderHeight;
        } else if (this.maxHeaderHeight < this.minHeaderHeight) {
            this.minHeaderHeight = this.maxHeaderHeight;
        }
        FrameLayout.LayoutParams frame_params = new FrameLayout.LayoutParams(-1, this.maxHeaderHeight);
        frame.setLayoutParams((ViewGroup.LayoutParams)frame_params);
        if (this.headerFlipScrollThreshold == -1) {
            this.headerFlipScrollThreshold = this.getHeaderDelta() > 0 ? this.getHeaderDelta() / 2 : -1;
        }
        this.headerCollapsed = false;
    }

    public void setHeaderBackground(int headerBackgroundRes) {
        this.headerFrame.setBackgroundResource(headerBackgroundRes);
    }

    private boolean headerChangeEnabled() {
        return this.getHeaderDelta() > 0;
    }

    private void adjustChildren() {
        if (this.getContentScrolled() < this.getHeaderDelta()) {
            int headerOffset = 0 - this.getContentScrolled();
            int headerCurrent = this.headerFrame.getTop();
            this.headerFrame.offsetTopAndBottom(headerOffset - headerCurrent);
            this.header.offsetTopAndBottom(-(headerOffset - headerCurrent));
            if (this.headerCentered) {
                int layoutOffset = this.getContentScrolled() / 2;
                int layoutCurrent = this.header.getTop();
                this.header.offsetTopAndBottom(layoutOffset - layoutCurrent);
            }
            int scrollViewOffset = this.maxHeaderHeight - this.getContentScrolled();
            int scrollViewCurrent = this.scrollView.getTop();
            this.scrollView.offsetTopAndBottom(scrollViewOffset - scrollViewCurrent);
        } else {
            int headerOffset = 0 - this.getHeaderDelta();
            int headerCurrent = this.headerFrame.getTop();
            this.headerFrame.offsetTopAndBottom(headerOffset - headerCurrent);
            this.header.offsetTopAndBottom(-(headerOffset - headerCurrent));
            if (this.headerCentered) {
                int layoutOffset = this.getHeaderDelta() / 2;
                int layoutCurrent = this.header.getTop();
                this.header.offsetTopAndBottom(layoutOffset - layoutCurrent);
            }
            int scrollViewOffset = this.maxHeaderHeight - this.getHeaderDelta();
            int scrollViewCurrent = this.scrollView.getTop();
            this.scrollView.offsetTopAndBottom(scrollViewOffset - scrollViewCurrent);
        }
    }

    public ScrollView getScrollView() {
        return this.scrollView;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.adjustChildren();
    }

    public static interface HeaderChangeListener {
        public void collapse(View var1);

        public void expand(View var1);
    }

    public static interface OnScrollListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }

    private class SyncedScrollView
    extends ScrollView {
        private boolean scrolling;
        private float scrollAmount;
        private ResizableHeaderScrollView parent;
        public OnScrollListener listener;

        public SyncedScrollView(Context context, ResizableHeaderScrollView parent) {
            super(context);
            this.parent = parent;
        }

        public SyncedScrollView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SyncedScrollView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public boolean onTouchEvent(MotionEvent e) {
            if (this.scrolling) {
                e.offsetLocation(0.0f, this.scrollAmount);
            }
            switch (e.getAction()) {
                case 2: {
                    this.scrolling = true;
                    break;
                }
                case 0: {
                    this.scrolling = true;
                    break;
                }
                case 1: {
                    this.scrolling = false;
                    this.scrollAmount = 0.0f;
                    break;
                }
                case 3: {
                    this.scrolling = false;
                    this.scrollAmount = 0.0f;
                }
            }
            return super.onTouchEvent(e);
        }

        public void setOnScrollListener(OnScrollListener listener) {
            this.listener = listener;
        }

        protected void onScrollChanged(int x, int y, int oldx, int oldy) {
            if (this.listener != null) {
                this.listener.onScrollChanged(x, y, oldx, oldy);
            }
            if (this.scrolling && this.getScrollY() < this.parent.getHeaderDelta()) {
                this.scrollAmount += (float)(oldy - y);
            }
            super.onScrollChanged(x, y, oldx, oldy);
        }
    }
}

