/*
 * Decompiled with CFR 0.152.
 */
package oak.web;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import oak.R;

public class OakWebViewFragment
extends Fragment {
    public static final int PROVIDED_LAYOUT = 0;
    private String url;
    private WebView webView;
    private View refresh;
    private View progress;
    private View back;
    private View fwd;
    private View container;
    private boolean hidden;
    private boolean openInBrowserEnabled = false;
    private boolean showControls = true;
    private boolean refreshInMenuEnabled = false;
    private boolean fadeControls = true;
    private long fadeTimeout = 1500L;
    private int layoutId = R.layout.webview;
    private float fadeoutMinimum = 0.2f;
    private float fadeoutMaximum = 1.0f;

    public void setFadeControls(boolean fadeControls) {
        this.fadeControls = fadeControls;
    }

    public void setShowControls(boolean showControls) {
        this.showControls = showControls;
    }

    public void setFadeTimeout(long fadeTimeout) {
        this.fadeTimeout = fadeTimeout;
    }

    public void setMaximumAlpha(float maxAlpha) {
        this.fadeoutMaximum = maxAlpha;
    }

    public void setMinimumAlpha(float minAlpha) {
        this.fadeoutMinimum = minAlpha;
    }

    public void setOpenInBrowserEnabled(boolean openInBrowserEnabled) {
        this.openInBrowserEnabled = openInBrowserEnabled;
    }

    public void setRefreshInMenuEnabled(boolean refreshInMenuEnabled) {
        this.refreshInMenuEnabled = refreshInMenuEnabled;
    }

    public void setWebViewClient(WebViewClient client) {
        this.webView.setWebViewClient(client);
    }

    public void setwebChromeClient(WebChromeClient client) {
        this.webView.setWebChromeClient(client);
    }

    public void back() {
        if (this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
        }
    }

    public boolean canGoBack() {
        return this.webView.canGoBack();
    }

    public boolean canGoForward() {
        return this.webView.canGoForward();
    }

    public void forward() {
        if (this.webView != null && this.webView.canGoForward()) {
            this.webView.goForward();
        }
    }

    public void refresh() {
        if (this.webView != null) {
            this.webView.reload();
        }
    }

    public static OakWebViewFragment getInstance(String url) {
        return OakWebViewFragment.getInstance(new BundleBuilder(url).build());
    }

    public static OakWebViewFragment getInstance(Bundle arguments) {
        OakWebViewFragment fragment = new OakWebViewFragment();
        fragment.setArguments(arguments);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.url = this.getArguments().getString("oak_url");
        this.setOpenInBrowserEnabled(this.getArguments().getBoolean("oak_open_in_browser", true));
        this.setFadeControls(this.getArguments().getBoolean("oak_control_fade", true));
        this.setShowControls(this.getArguments().getBoolean("oak_show_controls", true));
        this.setFadeTimeout(this.getArguments().getLong("oak_fade_timeout", 1500L));
        this.setMaximumAlpha(this.getArguments().getFloat("oak_fade_max", 1.0f));
        this.setMinimumAlpha(this.getArguments().getFloat("oak_fade_min", 0.2f));
        this.setRefreshInMenuEnabled(this.getArguments().getBoolean("oak_refresh_in_menu", false));
        this.layoutId = this.getArguments().getInt("oak_layout", R.layout.webview);
        this.setHasOptionsMenu(this.refreshInMenuEnabled || this.openInBrowserEnabled);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(this.layoutId, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.webView = (WebView)view.findViewById(R.id.webview);
        if (this.webView == null) {
            throw new IllegalStateException("Layout used with this webview must contain a WebView with the ID R.id.webview");
        }
        if (this.showControls) {
            this.back = view.findViewById(R.id.back);
            this.fwd = view.findViewById(R.id.forward);
            this.refresh = view.findViewById(R.id.refresh);
            this.progress = view.findViewById(R.id.progress);
            if (this.back != null) {
                this.back.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (OakWebViewFragment.this.webView.canGoBack()) {
                            OakWebViewFragment.this.webView.goBack();
                        }
                    }
                });
            }
            if (this.fwd != null) {
                this.fwd.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (OakWebViewFragment.this.webView.canGoForward()) {
                            OakWebViewFragment.this.webView.goForward();
                        }
                    }
                });
            }
            if (this.refresh != null) {
                this.refresh.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        OakWebViewFragment.this.webView.reload();
                        OakWebViewFragment.this.progress.setVisibility(0);
                        OakWebViewFragment.this.refresh.setVisibility(4);
                    }
                });
            }
            this.webView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    if (OakWebViewFragment.this.hidden) {
                        OakWebViewFragment.this.hidden = false;
                        OakWebViewFragment.this.unHide();
                    } else {
                        view.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                OakWebViewFragment.this.hide();
                                OakWebViewFragment.this.hidden = true;
                            }
                        }, OakWebViewFragment.this.fadeTimeout);
                    }
                    return false;
                }
            });
        } else {
            view.findViewById(R.id.button_container).setVisibility(8);
        }
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.webView.getSettings().setAllowFileAccess(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setLoadsImagesAutomatically(true);
        this.webView.getSettings().setSupportZoom(!this.fadeControls);
        this.webView.getSettings().setBuiltInZoomControls(!this.fadeControls);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("http")) {
                    view.loadUrl(url);
                    return true;
                }
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                OakWebViewFragment.this.startActivity(intent);
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                if (OakWebViewFragment.this.showControls) {
                    OakWebViewFragment.this.refresh.setVisibility(4);
                    OakWebViewFragment.this.progress.setVisibility(0);
                }
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                if (OakWebViewFragment.this.showControls) {
                    OakWebViewFragment.this.refresh.setVisibility(0);
                    OakWebViewFragment.this.progress.setVisibility(4);
                    OakWebViewFragment.this.configureButtons(view);
                }
                super.onPageFinished(view, url);
            }
        });
        this.webView.loadUrl(this.url);
    }

    public void onResume() {
        super.onResume();
    }

    @SuppressLint(value={"NewApi"})
    private void unHide() {
        this.configureButtons(this.webView);
        if (this.fadeControls && Build.VERSION.SDK_INT > 11) {
            if (this.refresh != null) {
                this.refresh.animate().alpha(this.fadeoutMaximum);
            }
            if (this.progress != null) {
                this.progress.animate().alpha(this.fadeoutMaximum);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void hide() {
        this.configureButtons(this.webView);
        if (this.fadeControls && Build.VERSION.SDK_INT > 11) {
            if (this.refresh != null) {
                this.refresh.animate().alpha(this.fadeoutMinimum);
            }
            if (this.progress != null) {
                this.progress.animate().alpha(this.fadeoutMinimum);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void configureButtons(WebView webView) {
        if (Build.VERSION.SDK_INT > 11) {
            if (webView.canGoBack()) {
                this.back.animate().alpha(this.hidden && this.fadeControls ? this.fadeoutMinimum : this.fadeoutMaximum);
                this.back.setEnabled(true);
            } else {
                this.back.animate().alpha(this.fadeoutMinimum);
                this.back.setEnabled(false);
            }
            if (webView.canGoForward()) {
                this.fwd.animate().alpha(this.hidden && this.fadeControls ? this.fadeoutMinimum : this.fadeoutMaximum);
                this.fwd.setEnabled(true);
            } else {
                this.fwd.animate().alpha(this.fadeoutMinimum);
                this.fwd.setEnabled(false);
            }
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        if (this.openInBrowserEnabled) {
            menu.add(0, R.id.oak_menu_open_in_broswer, 0, R.string.open_in_browser);
        }
        if (this.refreshInMenuEnabled) {
            menu.add(0, R.id.oak_menu_refresh, 0, R.string.refresh_in_menu);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.oak_menu_open_in_broswer) {
            Intent toBroswer = new Intent("android.intent.action.VIEW");
            toBroswer.setData(Uri.parse((String)this.webView.getUrl()));
            this.startActivity(toBroswer);
        }
        if (item.getItemId() == R.id.oak_menu_refresh) {
            this.webView.reload();
        }
        return super.onOptionsItemSelected(item);
    }

    public static class BundleBuilder {
        private Bundle bundle;

        public BundleBuilder(Bundle bundle) {
            this.bundle = bundle;
        }

        public BundleBuilder(String url) {
            this.bundle = new Bundle();
            this.bundle.putString("oak_url", url);
        }

        public BundleBuilder showControls(boolean showControls) {
            this.bundle.putBoolean("oak_show_controls", showControls);
            return this;
        }

        public BundleBuilder fadeControls(boolean fadeControls) {
            this.bundle.putBoolean("oak_control_fade", fadeControls);
            return this;
        }

        public BundleBuilder layoutId(int layoutId) {
            this.bundle.putInt("oak_layout", layoutId);
            return this;
        }

        public BundleBuilder fadeTimeout(long milliseconds) {
            this.bundle.putLong("oak_fade_timeout", milliseconds);
            return this;
        }

        public BundleBuilder maxControlAlpha(float maxAlpha) {
            this.bundle.putFloat("oak_fade_max", maxAlpha);
            return this;
        }

        public BundleBuilder minControlAlpha(float minAlpha) {
            this.bundle.putFloat("oak_fade_min", minAlpha);
            return this;
        }

        public BundleBuilder openInBrowserEnabled(boolean enabled) {
            this.bundle.putBoolean("oak_open_in_browser", enabled);
            return this;
        }

        public BundleBuilder refreshInMenuEnabled(boolean enabled) {
            this.bundle.putBoolean("oak_refresh_in_menu", enabled);
            return this;
        }

        public Bundle build() {
            return this.bundle;
        }
    }
}

