/*
 * Decompiled with CFR 0.152.
 */
package oak.svg;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.text.ParseException;
import oak.R;
import oak.svg.MathUtil;
import oak.svg.SvgPathParser;
import oak.util.RatioSizingUtils;

public class AnimatedSvgView
extends View {
    private static final String TAG = "AnimatedSvgView";
    private int mTraceTime = 2000;
    private int mTraceTimePerGlyph = 1000;
    private int mFillStart = 1200;
    private int mFillTime = 1000;
    private static final int MARKER_LENGTH_DIP = 16;
    private int[] mTraceResidueColors;
    private int[] mTraceColors;
    private RatioSizingUtils.RatioSizingInfo mRatioSizingInfo = new RatioSizingUtils.RatioSizingInfo();
    private int mViewportWidth;
    private int mViewportHeight;
    private PointF mViewport = new PointF((float)this.mViewportWidth, (float)this.mViewportHeight);
    private static final Interpolator INTERPOLATOR = new DecelerateInterpolator();
    private Paint mFillPaint;
    private int[] mFillAlphas;
    private int[] mFillReds;
    private int[] mFillGreens;
    private int[] mFillBlues;
    private GlyphData[] mGlyphData;
    private String[] mGlyphStrings;
    private float mMarkerLength;
    private int mWidth;
    private int mHeight;
    private long mStartTime;
    public static final int STATE_NOT_STARTED = 0;
    public static final int STATE_TRACE_STARTED = 1;
    public static final int STATE_FILL_STARTED = 2;
    public static final int STATE_FINISHED = 3;
    private int mState = 0;
    private OnStateChangeListener mOnStateChangeListener;

    public AnimatedSvgView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AnimatedSvgView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AnimatedSvgView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mFillPaint = new Paint();
        this.mFillPaint.setAntiAlias(true);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mMarkerLength = TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mTraceColors = new int[1];
        this.mTraceColors[0] = -16777216;
        this.mTraceResidueColors = new int[1];
        this.mTraceResidueColors[0] = Color.argb((int)50, (int)0, (int)0, (int)0);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnimatedSvgView);
            this.mViewportWidth = a.getInt(R.styleable.AnimatedSvgView_oakSvgImageSizeX, 433);
            this.mRatioSizingInfo.aspectRatioWidth = a.getInt(R.styleable.AnimatedSvgView_oakSvgImageSizeX, 433);
            this.mViewportHeight = a.getInt(R.styleable.AnimatedSvgView_oakSvgImageSizeY, 433);
            this.mRatioSizingInfo.aspectRatioHeight = a.getInt(R.styleable.AnimatedSvgView_oakSvgImageSizeY, 433);
            this.mTraceTime = a.getInt(R.styleable.AnimatedSvgView_oakSvgTraceTime, 2000);
            this.mTraceTimePerGlyph = a.getInt(R.styleable.AnimatedSvgView_oakSvgTraceTimePerGlyph, 1000);
            this.mFillStart = a.getInt(R.styleable.AnimatedSvgView_oakSvgFillStart, 1200);
            this.mFillTime = a.getInt(R.styleable.AnimatedSvgView_oakSvgFillTime, 1000);
            a.recycle();
            this.mViewport = new PointF((float)this.mViewportWidth, (float)this.mViewportHeight);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    public void setViewportSize(int viewportWidth, int viewportHeight) {
        this.mViewportWidth = viewportWidth;
        this.mViewportHeight = viewportHeight;
        this.mRatioSizingInfo.aspectRatioWidth = viewportWidth;
        this.mRatioSizingInfo.aspectRatioHeight = viewportHeight;
        this.mViewport = new PointF((float)this.mViewportWidth, (float)this.mViewportHeight);
        this.requestLayout();
    }

    public void setGlyphStrings(String[] glyphStrings) {
        this.mGlyphStrings = glyphStrings;
    }

    public void setTraceResidueColors(int[] traceResidueColors) {
        this.mTraceResidueColors = traceResidueColors;
    }

    public void setTraceColors(int[] traceColors) {
        this.mTraceColors = traceColors;
    }

    public void setFillPaints(int[] fillAlphas, int[] fillReds, int[] fillGreens, int[] fillBlues) {
        this.mFillAlphas = fillAlphas;
        this.mFillReds = fillReds;
        this.mFillGreens = fillGreens;
        this.mFillBlues = fillBlues;
    }

    public void start() {
        this.mStartTime = System.currentTimeMillis();
        this.changeState(1);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void reset() {
        this.mStartTime = 0L;
        this.changeState(0);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void setToFinishedFrame() {
        this.mStartTime = 1L;
        this.changeState(3);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.rebuildGlyphData();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        RatioSizingUtils.RatioMeasureInfo rmi = RatioSizingUtils.getMeasureInfo(widthMeasureSpec, heightMeasureSpec, this.mRatioSizingInfo, 0, 0);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)rmi.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)rmi.height, (int)0x40000000));
    }

    private void rebuildGlyphData() {
        SvgPathParser parser = new SvgPathParser(){

            @Override
            protected float transformX(float x) {
                return x * (float)AnimatedSvgView.this.mWidth / ((AnimatedSvgView)AnimatedSvgView.this).mViewport.x;
            }

            @Override
            protected float transformY(float y) {
                return y * (float)AnimatedSvgView.this.mHeight / ((AnimatedSvgView)AnimatedSvgView.this).mViewport.y;
            }
        };
        this.mGlyphData = new GlyphData[this.mGlyphStrings.length];
        for (int i = 0; i < this.mGlyphStrings.length; ++i) {
            this.mGlyphData[i] = new GlyphData();
            try {
                this.mGlyphData[i].path = parser.parsePath(this.mGlyphStrings[i]);
            }
            catch (ParseException e) {
                this.mGlyphData[i].path = new Path();
                Log.e((String)TAG, (String)"Couldn't parse path", (Throwable)e);
            }
            PathMeasure pm = new PathMeasure(this.mGlyphData[i].path, true);
            do {
                this.mGlyphData[i].length = Math.max(this.mGlyphData[i].length, pm.getLength());
            } while (pm.nextContour());
            this.mGlyphData[i].paint = new Paint();
            this.mGlyphData[i].paint.setStyle(Paint.Style.STROKE);
            this.mGlyphData[i].paint.setAntiAlias(true);
            this.mGlyphData[i].paint.setColor(-1);
            this.mGlyphData[i].paint.setStrokeWidth(TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mState == 0 || this.mGlyphData == null) {
            return;
        }
        long t = System.currentTimeMillis() - this.mStartTime;
        for (int i = 0; i < this.mGlyphData.length; ++i) {
            float phase = MathUtil.constrain(0.0f, 1.0f, ((float)t - (float)((this.mTraceTime - this.mTraceTimePerGlyph) * i) * 1.0f / (float)this.mGlyphData.length) * 1.0f / (float)this.mTraceTimePerGlyph);
            float distance = INTERPOLATOR.getInterpolation(phase) * this.mGlyphData[i].length;
            this.mGlyphData[i].paint.setColor(this.mTraceResidueColors[i]);
            this.mGlyphData[i].paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{distance, this.mGlyphData[i].length}, 0.0f));
            canvas.drawPath(this.mGlyphData[i].path, this.mGlyphData[i].paint);
            this.mGlyphData[i].paint.setColor(this.mTraceColors[i]);
            this.mGlyphData[i].paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{0.0f, distance, phase > 0.0f ? this.mMarkerLength : 0.0f, this.mGlyphData[i].length}, 0.0f));
            canvas.drawPath(this.mGlyphData[i].path, this.mGlyphData[i].paint);
        }
        if (t > (long)this.mFillStart) {
            if (this.mState < 2) {
                this.changeState(2);
            }
            float phase = MathUtil.constrain(0.0f, 1.0f, (float)(t - (long)this.mFillStart) * 1.0f / (float)this.mFillTime);
            for (int i = 0; i < this.mGlyphData.length; ++i) {
                GlyphData glyphData = this.mGlyphData[i];
                this.mFillPaint.setARGB((int)(phase * ((float)this.mFillAlphas[i] / 255.0f) * 255.0f), this.mFillReds[i], this.mFillGreens[i], this.mFillBlues[i]);
                canvas.drawPath(glyphData.path, this.mFillPaint);
            }
        }
        if (t < (long)(this.mFillStart + this.mFillTime)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            this.changeState(3);
        }
    }

    private void changeState(int state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        if (this.mOnStateChangeListener != null) {
            this.mOnStateChangeListener.onStateChange(state);
        }
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mOnStateChangeListener = onStateChangeListener;
    }

    private static class GlyphData {
        Path path;
        Paint paint;
        float length;

        private GlyphData() {
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange(int var1);
    }
}

