/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import oak.R;

public class MaskedImageView
extends ImageView {
    private BitmapDrawable maskDrawable;
    private NinePatchDrawable maskDrawableNine;
    private BitmapDrawable overlayDrawable;
    private NinePatchDrawable overlayDrawableNine;
    private int mFillColor;
    private int shadowColor;

    public MaskedImageView(Context context) {
        super(context);
    }

    public MaskedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources res = this.getResources();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaskedImageView);
        if (typedArray != null && res != null) {
            Drawable d;
            int fillColorResourceId = typedArray.getResourceId(R.styleable.MaskedImageView_oakFillColor, -1);
            int glareColorResourceId = typedArray.getResourceId(R.styleable.MaskedImageView_oakGlareColor, -1);
            int maskResourceId = typedArray.getResourceId(R.styleable.MaskedImageView_oakMask, -1);
            int overlayResourceId = typedArray.getResourceId(R.styleable.MaskedImageView_oakOverlay, -1);
            if (fillColorResourceId != -1) {
                this.setFillColor(res.getColor(fillColorResourceId));
            }
            if (glareColorResourceId != -1) {
                this.setGlareColor(res.getColor(glareColorResourceId));
            }
            if (maskResourceId != -1) {
                d = res.getDrawable(maskResourceId);
                if (d != null && d instanceof BitmapDrawable) {
                    this.setMaskDrawable((BitmapDrawable)d);
                } else if (d != null && d instanceof NinePatchDrawable) {
                    this.setMaskDrawable((NinePatchDrawable)d);
                }
            }
            if (overlayResourceId != -1) {
                d = res.getDrawable(overlayResourceId);
                if (d != null && d instanceof BitmapDrawable) {
                    this.setOverlayDrawable((BitmapDrawable)d);
                } else if (d != null && d instanceof NinePatchDrawable) {
                    this.setOverlayDrawable((NinePatchDrawable)d);
                }
            }
            typedArray.recycle();
        }
    }

    public void setFillColor(int color) {
        this.mFillColor = color;
    }

    private void setGlareColor(int color) {
        this.shadowColor = color;
    }

    protected void onDraw(Canvas canvas) {
        BitmapDrawable bmDrawable = (BitmapDrawable)this.getDrawable();
        Rect rect = new Rect();
        this.getDrawingRect(rect);
        Bitmap product = Bitmap.createBitmap((int)rect.width(), (int)rect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bmDrawable != null && bmDrawable.getBitmap() != null) {
            Paint p;
            product.setDensity(bmDrawable.getBitmap().getDensity());
            Canvas c = new Canvas(product);
            c.setDensity(canvas.getDensity());
            c.drawColor(this.mFillColor);
            super.onDraw(c);
            if (this.maskDrawable != null) {
                p = new Paint();
                p.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY));
                c.drawBitmap(this.maskDrawable.getBitmap(), null, rect, p);
            } else if (this.maskDrawableNine != null) {
                this.maskDrawableNine.setBounds(rect);
                this.maskDrawableNine.getPaint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY));
                this.maskDrawableNine.draw(c);
            }
            if (this.shadowColor != 0) {
                Paint glarePaint = new Paint();
                glarePaint.setColor(this.shadowColor);
                glarePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                Path glarePath = new Path();
                glarePath.moveTo((float)(rect.centerX() - rect.width() / 2), (float)(rect.centerY() - rect.height() / 2));
                glarePath.lineTo((float)(rect.centerX() - rect.width() / 2), (float)(rect.centerY() + rect.height() / 2 - rect.height() / 5));
                glarePath.lineTo((float)(rect.centerX() + rect.width() / 2), (float)(rect.centerY() - rect.height() / 2 + rect.height() / 5));
                glarePath.lineTo((float)(rect.centerX() + rect.width() / 2), (float)(rect.centerY() - rect.height() / 2));
                c.drawPath(glarePath, glarePaint);
            }
            if (this.overlayDrawable != null) {
                p = new Paint();
                c.drawBitmap(this.overlayDrawable.getBitmap(), null, rect, p);
            } else if (this.overlayDrawableNine != null) {
                this.overlayDrawableNine.setBounds(rect);
                this.overlayDrawableNine.draw(c);
            }
            canvas.drawBitmap(product, null, rect, new Paint());
        }
        product.recycle();
    }

    public void setMaskDrawable(BitmapDrawable bmDrawable) {
        this.maskDrawable = bmDrawable;
    }

    public void setMaskDrawable(NinePatchDrawable bmDrawable) {
        this.maskDrawableNine = bmDrawable;
    }

    public void setOverlayDrawable(BitmapDrawable bmDrawable) {
        this.overlayDrawable = bmDrawable;
    }

    public void setOverlayDrawable(NinePatchDrawable npDrawable) {
        this.overlayDrawableNine = npDrawable;
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
    }

    public void requestLayout() {
    }
}

