/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ProgressBar;
import oak.R;

public class CustomCircularProgressBar
extends ProgressBar {
    Context c;
    public RotateAnimation rotate;

    public CustomCircularProgressBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public CustomCircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context c, AttributeSet attrs) {
        TypedArray typedArray;
        this.c = c;
        this.setIndeterminate(true);
        this.rotate = new RotateAnimation(360.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.rotate.setInterpolator((Interpolator)new LinearInterpolator());
        this.rotate.setDuration(1750L);
        this.rotate.setRepeatCount(-1);
        if (attrs != null && (typedArray = c.obtainStyledAttributes(attrs, R.styleable.CustomCircularProgressBar)) != null) {
            int resourceId = typedArray.getResourceId(R.styleable.CustomCircularProgressBar_oakProgressBarDrawable, -1);
            typedArray.recycle();
            if (resourceId != -1) {
                Drawable d = c.getResources().getDrawable(resourceId);
                this.setIndeterminateDrawable(d);
            }
        }
        this.setAnimation((Animation)this.rotate);
        this.rotate.start();
    }

    public void setVisibility(int visibility) {
        if (visibility == 8 || visibility == 4) {
            this.clearAnimation();
        } else if (visibility == 0) {
            this.setAnimation((Animation)this.rotate);
            this.rotate.start();
        }
        super.setVisibility(visibility);
    }
}

