/*
 * Decompiled with CFR 0.152.
 */
package oak.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.CheckBox;
import oak.R;
import oak.util.OakUtils;

public class CheckBoxWithFont
extends CheckBox {
    private static final String TAG = CheckBoxWithFont.class.getSimpleName();

    public CheckBoxWithFont(Context context) {
        super(context);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
    }

    public CheckBoxWithFont(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
        this.setFont(context, attrs);
    }

    public CheckBoxWithFont(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setPaintFlags(this.getPaintFlags() | 0x80);
        this.setFont(context, attrs);
    }

    private void setFont(Context context, AttributeSet attrs) {
        TypedArray typedArray;
        if (this.isInEditMode()) {
            return;
        }
        String fontName = null;
        if (attrs != null && (typedArray = context.obtainStyledAttributes(attrs, R.styleable.CheckBoxWithFont)) != null) {
            try {
                fontName = typedArray.getString(R.styleable.CheckBoxWithFont_oakFont);
                if (fontName != null) {
                    this.setTypeface(OakUtils.getStaticTypeFace((Context)context, (String)fontName));
                }
            }
            catch (IllegalArgumentException e) {
                try {
                    int fontNameRes = typedArray.getResourceId(R.styleable.CheckBoxWithFont_oakFont, -1);
                    if (fontNameRes != -1 && (fontName = context.getString(fontNameRes)) != null) {
                        this.setTypeface(OakUtils.getStaticTypeFace((Context)context, (String)fontName));
                    }
                }
                catch (IllegalArgumentException f) {
                    f.printStackTrace();
                }
            }
            typedArray.recycle();
        }
    }
}

