/*
 * Decompiled with CFR 0.152.
 */
package oak;

import android.util.Pair;
import android.widget.Filter;
import android.widget.Filterable;
import java.util.ArrayList;
import java.util.List;
import oak.BaseSectionAdapter;
import oak.Queryable;
import oak.Sectionable;

public abstract class SectionAdapter<T extends Sectionable>
extends BaseSectionAdapter
implements Filterable {
    private CustomFilter mFilter;
    private List<Pair<String, List<T>>> mObjects;
    private ArrayList<Pair<String, List<T>>> mOriginalValues;
    private final Object mLock = new Object();

    public void setDataManually(List<Pair<String, List<T>>> data) {
        this.mObjects = data;
        this.notifyDataSetChanged();
    }

    public void setData(List<T> unSectionedList) {
        ArrayList<Pair<String, List<T>>> res = new ArrayList<Pair<String, List<T>>>();
        ArrayList<Sectionable> subArray = null;
        for (int i = 0; i < unSectionedList.size(); ++i) {
            Sectionable currentSectionable = (Sectionable)unSectionedList.get(i);
            String nextSection = null;
            if (subArray == null) {
                subArray = new ArrayList<Sectionable>();
            }
            if (i + 1 < unSectionedList.size()) {
                nextSection = ((Sectionable)unSectionedList.get(i + 1)).getSection();
            }
            String currentSection = currentSectionable.getSection();
            subArray.add(currentSectionable);
            if (currentSection.equals(nextSection)) continue;
            Pair pair = new Pair((Object)currentSection, subArray);
            res.add(pair);
            subArray = null;
        }
        this.mObjects = res;
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mObjects = null;
    }

    public synchronized void replaceDataInSection(String section, List<T> dataForSection) {
        if (this.mObjects == null) {
            return;
        }
        for (int i = 0; i < this.mObjects.size(); ++i) {
            Pair<String, List<T>> pair = this.mObjects.get(i);
            if (!((String)pair.first).equals(section)) continue;
            this.mObjects.remove(i);
            Pair newPair = new Pair((Object)section, dataForSection);
            this.mObjects.add(i, newPair);
            break;
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.mObjects == null) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < this.mObjects.size(); ++i) {
            res += ((List)this.mObjects.get((int)i).second).size();
        }
        return res;
    }

    public T getItem(int position) {
        int c = 0;
        for (int i = 0; i < this.mObjects.size(); ++i) {
            if (position >= c && position < c + ((List)this.mObjects.get((int)i).second).size()) {
                return (T)((Sectionable)((List)this.mObjects.get((int)i).second).get(position - c));
            }
            c += ((List)this.mObjects.get((int)i).second).size();
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getPositionForSection(int section) {
        if (section < 0) {
            section = 0;
        }
        if (section >= this.mObjects.size()) {
            section = this.mObjects.size() - 1;
        }
        int c = 0;
        for (int i = 0; i < this.mObjects.size(); ++i) {
            if (section == i) {
                return c;
            }
            c += ((List)this.mObjects.get((int)i).second).size();
        }
        return 0;
    }

    @Override
    public int getSectionForPosition(int position) {
        int c = 0;
        for (int i = 0; i < this.mObjects.size(); ++i) {
            if (position >= c && position < c + ((List)this.mObjects.get((int)i).second).size()) {
                return i;
            }
            c += ((List)this.mObjects.get((int)i).second).size();
        }
        return -1;
    }

    public String[] getSections() {
        String[] res = new String[this.mObjects.size()];
        for (int i = 0; i < this.mObjects.size(); ++i) {
            String section = (String)this.mObjects.get((int)i).first;
            res[i] = section.length() > 1 ? ((String)this.mObjects.get((int)i).first).substring(0, 1) : section;
        }
        return res;
    }

    public String[] getSectionsWithFullName() {
        String[] res = new String[this.mObjects.size()];
        for (int i = 0; i < this.mObjects.size(); ++i) {
            res[i] = (String)this.mObjects.get((int)i).first;
        }
        return res;
    }

    public boolean isPositionTopOfSection(int position) {
        int c = 0;
        for (int i = 0; i < this.mObjects.size(); ++i) {
            if (position >= c && position < c + ((List)this.mObjects.get((int)i).second).size() && position == c) {
                return true;
            }
            c += ((List)this.mObjects.get((int)i).second).size();
        }
        return false;
    }

    public boolean isPositionBottomOfSection(int position) {
        int c = 0;
        for (int i = 0; i < this.mObjects.size(); ++i) {
            if (position >= c && position < c + ((List)this.mObjects.get((int)i).second).size() && position == c + ((List)this.mObjects.get((int)i).second).size() - 1) {
                return true;
            }
            c += ((List)this.mObjects.get((int)i).second).size();
        }
        return false;
    }

    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new CustomFilter();
        }
        return this.mFilter;
    }

    private class CustomFilter
    extends Filter {
        private CustomFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Object object;
            Filter.FilterResults results = new Filter.FilterResults();
            if (SectionAdapter.this.mOriginalValues == null) {
                object = SectionAdapter.this.mLock;
                synchronized (object) {
                    SectionAdapter.this.mOriginalValues = new ArrayList(SectionAdapter.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                object = SectionAdapter.this.mLock;
                synchronized (object) {
                    ArrayList list;
                    results.values = list = new ArrayList(SectionAdapter.this.mOriginalValues);
                    results.count = list.size();
                }
            } else {
                String prefixString = prefix.toString().toLowerCase();
                ArrayList values = SectionAdapter.this.mOriginalValues;
                int count = values.size();
                ArrayList<Pair> newValues = new ArrayList<Pair>(count);
                for (int i = 0; i < count; ++i) {
                    String sectionHeader = (String)((Pair)values.get((int)i)).first;
                    int sectionCount = ((List)((Pair)values.get((int)i)).second).size();
                    ArrayList<Sectionable> newSectionItems = new ArrayList<Sectionable>(sectionCount);
                    block7: for (int k = 0; k < sectionCount; ++k) {
                        Sectionable sectionValue = (Sectionable)((List)((Pair)values.get((int)i)).second).get(k);
                        String sectionValueText = sectionValue.toString().toLowerCase();
                        if (sectionValue instanceof Queryable && ((Queryable)((Object)sectionValue)).isQueryMatch(prefix)) {
                            newSectionItems.add(sectionValue);
                            continue;
                        }
                        if (sectionValueText.startsWith(prefixString)) {
                            newSectionItems.add(sectionValue);
                            continue;
                        }
                        String[] words = sectionValueText.split(" ");
                        int wordCount = words.length;
                        for (int j = 0; j < wordCount; ++j) {
                            if (!words[j].startsWith(prefixString)) continue;
                            newSectionItems.add(sectionValue);
                            continue block7;
                        }
                    }
                    if (newSectionItems.size() <= 0) continue;
                    newValues.add(new Pair((Object)sectionHeader, newSectionItems));
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            SectionAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                SectionAdapter.this.notifyDataSetChanged();
            } else {
                SectionAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

